/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.BaseAudioManager;
import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import java.util.Enumeration;
import java.util.Vector;
import javax.speech.AudioException;
import javax.speech.AudioManager;
import javax.speech.Engine;
import javax.speech.EngineEvent;
import javax.speech.EngineException;
import javax.speech.EngineListener;
import javax.speech.EngineModeDesc;
import javax.speech.EngineProperties;
import javax.speech.EngineStateError;
import javax.speech.SpeechEvent;
import javax.speech.VocabManager;

public abstract class BaseEngine
implements Engine,
SpeechEventDispatcher {
    protected long engineState;
    protected Object engineStateLock;
    protected Vector engineListeners;
    protected AudioManager audioManager = null;
    protected EngineModeDesc engineModeDesc = null;
    protected EngineProperties engineProperties = null;
    protected static final long CLEAR_ALL_STATE = -1L;

    public BaseEngine() {
        this(null);
    }

    public BaseEngine(EngineModeDesc engineModeDesc) {
        this.engineModeDesc = engineModeDesc;
        this.engineListeners = new Vector();
        this.engineState = 1L;
        this.engineStateLock = new Object();
        this.engineProperties = this.createEngineProperties();
    }

    public long getEngineState() {
        return this.engineState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEngineState(long l) throws InterruptedException, IllegalArgumentException {
        Object object = this.engineStateLock;
        synchronized (object) {
            while (!this.testEngineState(l)) {
                this.engineStateLock.wait();
            }
        }
    }

    public boolean testEngineState(long l) throws IllegalArgumentException {
        return (this.getEngineState() & l) == l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] setEngineState(long l, long l2) {
        long[] lArray = new long[2];
        Object object = this.engineStateLock;
        synchronized (object) {
            lArray[0] = this.engineState;
            this.engineState &= l ^ 0xFFFFFFFFFFFFFFFFL;
            this.engineState |= l2;
            lArray[1] = this.engineState;
            this.engineStateLock.notifyAll();
        }
        return lArray;
    }

    public void allocate() throws EngineException, EngineStateError {
        if (this.testEngineState(4L)) {
            return;
        }
        long[] lArray = this.setEngineState(-1L, 2L);
        this.postEngineAllocatingResources(lArray[0], lArray[1]);
        this.handleAllocate();
    }

    protected abstract void handleAllocate() throws EngineException;

    public void deallocate() throws EngineException, EngineStateError {
        if (this.testEngineState(1L)) {
            return;
        }
        long[] lArray = this.setEngineState(-1L, 8L);
        this.postEngineDeallocatingResources(lArray[0], lArray[1]);
        this.handleDeallocate();
    }

    protected abstract void handleDeallocate() throws EngineException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws EngineStateError {
        Object object = this.engineStateLock;
        synchronized (object) {
            this.checkEngineState(9L);
            if (this.testEngineState(256L)) {
                return;
            }
            this.handlePause();
            long[] lArray = this.setEngineState(512L, 256L);
            this.postEnginePaused(lArray[0], lArray[1]);
        }
    }

    protected abstract void handlePause();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws AudioException, EngineStateError {
        Object object = this.engineStateLock;
        synchronized (object) {
            this.checkEngineState(9L);
            if (this.testEngineState(512L)) {
                return;
            }
            this.handleResume();
            long[] lArray = this.setEngineState(256L, 512L);
            this.postEngineResumed(lArray[0], lArray[1]);
        }
    }

    protected abstract void handleResume();

    public AudioManager getAudioManager() {
        if (this.audioManager == null) {
            this.audioManager = new BaseAudioManager();
        }
        return this.audioManager;
    }

    public VocabManager getVocabManager() throws EngineStateError {
        return null;
    }

    public EngineProperties getEngineProperties() {
        return this.engineProperties;
    }

    public EngineModeDesc getEngineModeDesc() throws SecurityException {
        return this.engineModeDesc;
    }

    protected void setEngineModeDesc(EngineModeDesc engineModeDesc) {
        this.engineModeDesc = engineModeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngineListener(EngineListener engineListener) {
        Vector vector = this.engineListeners;
        synchronized (vector) {
            if (!this.engineListeners.contains(engineListener)) {
                this.engineListeners.addElement(engineListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEngineListener(EngineListener engineListener) {
        Vector vector = this.engineListeners;
        synchronized (vector) {
            this.engineListeners.removeElement(engineListener);
        }
    }

    protected void postEngineAllocated(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new EngineEvent((Engine)this, 501, l, l2));
    }

    public void fireEngineAllocated(EngineEvent engineEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            engineListener.engineAllocated(engineEvent);
        }
    }

    protected void postEngineAllocatingResources(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new EngineEvent((Engine)this, 503, l, l2));
    }

    public void fireEngineAllocatingResources(EngineEvent engineEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            engineListener.engineAllocatingResources(engineEvent);
        }
    }

    protected void postEngineDeallocated(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new EngineEvent((Engine)this, 502, l, l2));
    }

    public void fireEngineDeallocated(EngineEvent engineEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            engineListener.engineDeallocated(engineEvent);
        }
    }

    protected void postEngineDeallocatingResources(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new EngineEvent((Engine)this, 504, l, l2));
    }

    public void fireEngineDeallocatingResources(EngineEvent engineEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            engineListener.engineDeallocatingResources(engineEvent);
        }
    }

    protected void postEnginePaused(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new EngineEvent((Engine)this, 505, l, l2));
    }

    public void fireEnginePaused(EngineEvent engineEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            engineListener.enginePaused(engineEvent);
        }
    }

    protected void postEngineResumed(long l, long l2) {
        SpeechEventUtilities.postSpeechEvent(this, (SpeechEvent)new EngineEvent((Engine)this, 506, l, l2));
    }

    public void fireEngineResumed(EngineEvent engineEvent) {
        if (this.engineListeners == null) {
            return;
        }
        Enumeration enumeration = this.engineListeners.elements();
        while (enumeration.hasMoreElements()) {
            EngineListener engineListener = (EngineListener)enumeration.nextElement();
            engineListener.engineResumed(engineEvent);
        }
    }

    protected abstract BaseEngineProperties createEngineProperties();

    protected void checkEngineState(long l) throws EngineStateError {
        long l2 = this.getEngineState();
        if ((l2 & l) != 0L) {
            throw new EngineStateError("Invalid EngineState: expected=(" + this.stateToString(l) + ") current state=(" + this.stateToString(l2) + ")");
        }
    }

    protected String stateToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((l & 1L) != 0L) {
            stringBuffer.append(" DEALLOCATED ");
        }
        if ((l & 2L) != 0L) {
            stringBuffer.append(" ALLOCATING_RESOURCES ");
        }
        if ((l & 4L) != 0L) {
            stringBuffer.append(" ALLOCATED ");
        }
        if ((l & 8L) != 0L) {
            stringBuffer.append(" DEALLOCATING_RESOURCES ");
        }
        if ((l & 0x100L) != 0L) {
            stringBuffer.append(" PAUSED ");
        }
        if ((l & 0x200L) != 0L) {
            stringBuffer.append(" RESUMED ");
        }
        return stringBuffer.toString();
    }

    public void dispatchSpeechEvent(SpeechEvent speechEvent) {
        switch (speechEvent.getId()) {
            case 501: {
                this.fireEngineAllocated((EngineEvent)speechEvent);
                break;
            }
            case 503: {
                this.fireEngineAllocatingResources((EngineEvent)speechEvent);
                break;
            }
            case 502: {
                this.fireEngineDeallocated((EngineEvent)speechEvent);
                break;
            }
            case 504: {
                this.fireEngineDeallocatingResources((EngineEvent)speechEvent);
                break;
            }
            case 505: {
                this.fireEnginePaused((EngineEvent)speechEvent);
                break;
            }
            case 506: {
                this.fireEngineResumed((EngineEvent)speechEvent);
            }
        }
    }

    public String toString() {
        return this.getEngineModeDesc().getEngineName() + ":" + this.getEngineModeDesc().getModeName();
    }
}

