/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Browser
extends Composite {
    OleFrame frame;
    OleControlSite site;
    OleAutomation auto;
    boolean backwardEnabled;
    boolean forwardEnabled;
    LocationListener[] locationListeners = new LocationListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    static final int CommandStateChange = 105;
    static final int NavigateComplete2 = 259;
    static final int ProgressChange = 108;
    static final int StatusTextChange = 102;
    static final short CSC_UPDATECOMMANDS = -1;
    static final short CSC_NAVIGATEFORWARD = 1;
    static final short CSC_NAVIGATEBACK = 2;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";

    public Browser(Composite parent, int style) {
        super(parent, style);
        this.frame = new OleFrame(this, 0);
        this.site = new OleControlSite((Composite)this.frame, 0, "Shell.Explorer");
        this.site.doVerb(-5);
        this.auto = new OleAutomation(this.site);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                if (Browser.this.auto != null) {
                    Browser.this.auto.dispose();
                }
                Browser.this.auto = null;
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Browser.this.frame.setBounds(Browser.this.getClientArea());
            }
        });
        OleListener listener = new OleListener(){

            public void handleEvent(OleEvent event) {
                switch (event.type) {
                    case 105: {
                        int command = 0;
                        boolean enabled = false;
                        Variant varResult = event.arguments[0];
                        if (varResult != null) {
                            command = varResult.getInt();
                        }
                        if ((varResult = event.arguments[1]) != null) {
                            enabled = varResult.getBoolean();
                        }
                        if (command == 2) {
                            Browser.this.backwardEnabled = enabled;
                        }
                        if (command == 1) {
                            Browser.this.forwardEnabled = enabled;
                        }
                        return;
                    }
                    case 259: {
                        Variant varResult = event.arguments[1];
                        if (varResult != null) {
                            String url = varResult.getString();
                            LocationEvent newEvent = new LocationEvent(Browser.this);
                            newEvent.location = url;
                            if (Browser.this.locationListeners != null) {
                                int i = 0;
                                while (i < Browser.this.locationListeners.length) {
                                    Browser.this.locationListeners[i].changed(newEvent);
                                    ++i;
                                }
                            }
                        }
                        return;
                    }
                    case 108: {
                        Variant arg1 = event.arguments[0];
                        int nProgress = arg1 == null || arg1.getType() != 3 ? 0 : arg1.getInt();
                        Variant arg2 = event.arguments[1];
                        int nProgressMax = arg2 == null || arg2.getType() != 3 ? 0 : arg2.getInt();
                        ProgressEvent newEvent = new ProgressEvent(Browser.this);
                        newEvent.current = nProgress;
                        newEvent.total = nProgressMax;
                        if (Browser.this.progressListeners != null) {
                            if (nProgress != -1) {
                                int i = 0;
                                while (i < Browser.this.progressListeners.length) {
                                    Browser.this.progressListeners[i].changed(newEvent);
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < Browser.this.progressListeners.length) {
                                    Browser.this.progressListeners[i].completed(newEvent);
                                    ++i;
                                }
                            }
                        }
                        return;
                    }
                    case 102: {
                        Variant arg1 = event.arguments[0];
                        if (arg1 == null || arg1.getType() != 8) {
                            return;
                        }
                        String text = arg1.getString();
                        StatusTextEvent newEvent = new StatusTextEvent(Browser.this);
                        newEvent.text = text;
                        if (Browser.this.statusTextListeners != null) {
                            int i = 0;
                            while (i < Browser.this.statusTextListeners.length) {
                                Browser.this.statusTextListeners[i].changed(newEvent);
                                ++i;
                            }
                        }
                        return;
                    }
                }
            }
        };
        this.site.addEventListener(105, listener);
        this.site.addEventListener(259, listener);
        this.site.addEventListener(108, listener);
        this.site.addEventListener(102, listener);
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public boolean back() {
        this.checkWidget();
        if (!this.backwardEnabled) {
            return false;
        }
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"GoBack"});
        Variant pVarResult = this.auto.invoke(rgdispid[0]);
        return pVarResult.getType() == 0;
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    public boolean forward() {
        this.checkWidget();
        if (!this.forwardEnabled) {
            return false;
        }
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"GoForward"});
        Variant pVarResult = this.auto.invoke(rgdispid[0]);
        return pVarResult.getType() == 0;
    }

    public String getUrl() {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"LocationURL"});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() != 8) {
            return "";
        }
        return pVarResult.getString();
    }

    public void refresh() {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Refresh"});
        this.auto.invoke(rgdispid[0]);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.locationListeners.length) {
            if (listener == this.locationListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.progressListeners.length) {
            if (listener == this.progressListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            if (listener == this.statusTextListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Navigate", "URL"});
        Variant[] rgvarg = new Variant[]{new Variant(url)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        Variant pVarResult = this.auto.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
        return pVarResult.getType() == 0;
    }

    public void stop() {
        this.checkWidget();
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Stop"});
        this.auto.invoke(rgdispid[0]);
    }
}

