/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PreferenceDialog
extends Dialog
implements IPreferencePageContainer {
    public static final String PREF_DLG_TITLE_IMG = "preference_dialog_title_image";
    public static final String PREF_DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private static String lastPreferenceId = null;
    Composite titleArea;
    private CLabel messageLabel;
    private Label titleImage;
    Color titleAreaColor;
    private String message = "";
    private String errorMessage;
    Color normalMsgAreaBackground;
    Color errorMsgAreaBackground;
    private Image messageImage;
    private Image errorMsgImage;
    private boolean showingError = false;
    Point lastShellSize;
    private IPreferenceStore preferenceStore;
    IPreferencePage currentPage;
    private PreferenceManager preferenceManager;
    Composite pageContainer;
    Point minimumPageSize = new Point(400, 400);
    private Button okButton;
    Button cancelButton;
    Button helpButton = null;
    private boolean isHelpAvailable = false;
    Tree tree;
    TreeItem currentTreeItem;
    static /* synthetic */ Class class$0;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jface.preference.PreferenceDialog;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile(clazz, "images/pref_dialog_title.gif"));
    }

    public PreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.preferenceManager = manager;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                return;
            }
            case 1: {
                this.cancelPressed();
                return;
            }
            case 17: {
                this.helpPressed();
                return;
            }
        }
    }

    protected void cancelPressed() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            final IPreferenceNode node = (IPreferenceNode)nodes.next();
            if (node.getPage() == null) continue;
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    if (!node.getPage().performCancel()) {
                        return;
                    }
                }
            });
        }
        this.setReturnCode(1);
        this.close();
    }

    public boolean close() {
        List nodes = this.preferenceManager.getElements(0);
        int i = 0;
        while (i < nodes.size()) {
            IPreferenceNode node = (IPreferenceNode)nodes.get(i);
            node.disposeResources();
            ++i;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JFaceResources.getString("PreferenceDialog.title"));
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (PreferenceDialog.this.lastShellSize == null) {
                    PreferenceDialog.this.lastShellSize = PreferenceDialog.this.getShell().getSize();
                }
            }
        });
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        if (this.lastShellSize == null) {
            this.lastShellSize = this.getShell().getSize();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getShell().setDefaultButton(this.okButton);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.isHelpAvailable) {
            this.helpButton = this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        }
    }

    protected Control createContents(final Composite parent) {
        final Control[] control = new Control[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                control[0] = PreferenceDialog.super.createContents(parent);
                PreferenceDialog.this.selectSavedItem();
            }
        });
        return control[0];
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        ((GridLayout)composite.getLayout()).horizontalSpacing = 10;
        this.createTree(composite);
        GridData gd = new GridData(1040);
        gd.widthHint = 150;
        gd.verticalSpan = 2;
        this.tree.setLayoutData((Object)gd);
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        this.createTitleArea(titleComposite);
        this.pageContainer = this.createPageContainer(composite);
        this.pageContainer.setLayoutData((Object)new GridData(1808));
        Label separator = new Label(composite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        return composite;
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new PageLayout());
        return result;
    }

    private Composite createTitleArea(Composite parent) {
        this.titleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground(display);
        Color foreground = JFaceColors.getBannerForeground(display);
        GridData layoutData = new GridData(1808);
        this.titleArea.setLayout((Layout)layout);
        this.titleArea.setLayoutData((Object)layoutData);
        this.titleArea.setBackground(background);
        final Color borderColor = new Color((Device)this.titleArea.getDisplay(), ViewForm.borderOutsideRGB);
        this.titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(borderColor);
                Rectangle bounds = PreferenceDialog.this.titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PreferenceDialog.this.titleAreaColor != null) {
                    PreferenceDialog.this.titleAreaColor.dispose();
                }
                if (PreferenceDialog.this.errorMsgAreaBackground != null) {
                    PreferenceDialog.this.errorMsgAreaBackground.dispose();
                }
                borderColor.dispose();
            }
        });
        this.messageLabel = new CLabel(this.titleArea, 16384);
        JFaceColors.setColors((Control)this.messageLabel, foreground, background);
        this.messageLabel.setText(" ");
        this.messageLabel.setFont(JFaceResources.getBannerFont());
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    PreferenceDialog.this.updateMessage();
                }
                if ("org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                    PreferenceDialog.this.updateMessage();
                    Font dialogFont = JFaceResources.getDialogFont();
                    PreferenceDialog.this.tree.setFont(dialogFont);
                    Control[] children = ((Composite)PreferenceDialog.this.buttonBar).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        children[i].setFont(dialogFont);
                        ++i;
                    }
                }
            }
        };
        this.messageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gd = new GridData(1808);
        this.messageLabel.setLayoutData((Object)gd);
        this.titleImage = new Label(this.titleArea, 16384);
        this.titleImage.setBackground(background);
        this.titleImage.setImage(JFaceResources.getImage(PREF_DLG_TITLE_IMG));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.titleImage.setLayoutData((Object)gd);
        return this.titleArea;
    }

    private void createTree(Composite parent) {
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.tree = new Tree(parent, 2048);
        OpenStrategy eventAdapter = new OpenStrategy((Control)this.tree);
        eventAdapter.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BusyIndicator.showWhile((Display)PreferenceDialog.this.tree.getDisplay(), (Runnable)new Runnable(this, event){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ SelectionEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = selectionEvent;
                    }

                    public void run() {
                        Object data = this.val$event.item.getData();
                        if (data instanceof IPreferenceNode) {
                            if (!8.access$0(this.this$1).isCurrentPageValid()) {
                                this.handleError();
                            } else if (!8.access$0(this.this$1).showPage((IPreferenceNode)data)) {
                                this.handleError();
                            } else {
                                8.access$0(this.this$1).currentTreeItem = (TreeItem)this.val$event.item;
                            }
                            8.access$0(this.this$1).tree.setFocus();
                        }
                    }

                    private void handleError() {
                        8.access$0(this.this$1).showPageFlippingAbortDialog();
                        8.access$0(this.this$1).selectCurrentPageAgain();
                        8.access$0(this.this$1).clearSelectedNode();
                    }
                });
            }

            static /* synthetic */ PreferenceDialog access$0(8 var0) {
                return var0.PreferenceDialog.this;
            }
        });
        eventAdapter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                TreeItem[] selection = PreferenceDialog.this.tree.getSelection();
                if (selection.length > 0) {
                    selection[0].setExpanded(!selection[0].getExpanded());
                }
            }
        });
        this.tree.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (PreferenceDialog.this.currentPage != null) {
                    PreferenceDialog.this.currentPage.performHelp();
                }
            }
        });
        IPreferenceNode node = this.preferenceManager.getRoot();
        IPreferenceNode[] subnodes = node.getSubNodes();
        this.tree.setFont(parent.getFont());
        int i = 0;
        while (i < subnodes.length) {
            this.createTreeItemFor((Widget)this.tree, subnodes[i]);
            ++i;
        }
    }

    private void createTreeItemFor(Widget parent, IPreferenceNode node) {
        TreeItem item = null;
        item = parent instanceof Tree ? new TreeItem((Tree)parent, -1) : new TreeItem((TreeItem)parent, -1);
        item.setData((Object)node);
        item.setText(node.getLabelText());
        Image image = node.getLabelImage();
        if (image != null) {
            item.setImage(image);
        }
        IPreferenceNode[] subnodes = node.getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            this.createTreeItemFor((Widget)item, subnodes[i]);
            ++i;
        }
    }

    public PreferenceManager getPreferenceManager() {
        return this.preferenceManager;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    protected void handleSave() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceStore store;
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (!(page instanceof PreferencePage) || (store = ((PreferencePage)page).getPreferenceStore()) == null || !store.needsSaving() || !(store instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                MessageDialog.openError(this.getShell(), JFaceResources.getString("PreferenceDialog.saveErrorTitle"), JFaceResources.format("PreferenceDialog.saveErrorMessage", new Object[]{page.getTitle(), e.getMessage()}));
            }
        }
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected boolean isCurrentPageValid() {
        if (this.currentPage == null) {
            return true;
        }
        return this.currentPage.isValid();
    }

    protected void okPressed() {
        Iterator nodes = this.preferenceManager.getElements(0).iterator();
        while (nodes.hasNext()) {
            IPreferenceNode node = (IPreferenceNode)nodes.next();
            IPreferencePage page = node.getPage();
            if (page == null || page.performOk()) continue;
            return;
        }
        this.handleSave();
        this.close();
    }

    void selectCurrentPageAgain() {
        this.tree.setSelection(new TreeItem[]{this.currentTreeItem});
        this.currentPage.setVisible(true);
    }

    protected void selectSavedItem() {
        TreeItem selectedItem;
        Object data;
        int count;
        if (this.tree != null && (count = this.tree.getItemCount()) > 0 && (data = (selectedItem = this.getLastSelectedNode(this.tree.getItems())).getData()) instanceof IPreferenceNode) {
            this.tree.setSelection(new TreeItem[]{selectedItem});
            this.currentTreeItem = selectedItem;
            this.showPage((IPreferenceNode)data);
            this.tree.setFocus();
        }
    }

    protected String getSelectedNodePreference() {
        return lastPreferenceId;
    }

    protected void setSelectedNodePreference(String pageId) {
        lastPreferenceId = pageId;
    }

    private TreeItem getLastSelectedNode(TreeItem[] items) {
        String lastSelectedNode = this.getSelectedNodePreference();
        if (lastSelectedNode == null) {
            return items[0];
        }
        TreeItem selectedItem = this.findNodeMatching(items, lastSelectedNode);
        if (selectedItem == null) {
            return items[0];
        }
        return selectedItem;
    }

    private TreeItem findNodeMatching(TreeItem[] items, String nodeId) {
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (data instanceof IPreferenceNode) {
                if (((IPreferenceNode)data).getId().equals(nodeId)) {
                    return items[i];
                }
                TreeItem selectedChild = this.findNodeMatching(items[i].getItems(), nodeId);
                if (selectedChild != null) {
                    return selectedChild;
                }
            }
            ++i;
        }
        return null;
    }

    void clearSelectedNode() {
        this.setSelectedNodePreference(null);
    }

    private void setSelectedNode() {
        String storeValue = null;
        if (this.tree.getSelectionCount() == 1) {
            TreeItem currentSelection = this.tree.getSelection()[0];
            Object data = currentSelection.getData();
            if (currentSelection.getData() instanceof IPreferenceNode) {
                storeValue = ((IPreferenceNode)data).getId();
            }
        }
        this.setSelectedNodePreference(storeValue);
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
                this.messageLabel.setBackground(this.normalMsgAreaBackground);
                this.messageLabel.setImage(null);
                this.titleImage.setImage(JFaceResources.getImage(PREF_DLG_TITLE_IMG));
            }
            if (this.message == null) {
                this.message = "";
            }
            this.messageLabel.setText(this.message);
            this.messageLabel.setImage(this.messageImage);
            this.messageLabel.setToolTipText(this.message);
        } else {
            this.messageLabel.setText(this.errorMessage);
            this.messageLabel.setToolTipText(this.errorMessage);
            if (!this.showingError) {
                this.showingError = true;
                if (this.errorMsgAreaBackground == null) {
                    this.errorMsgAreaBackground = JFaceColors.getErrorBackground(this.messageLabel.getDisplay());
                    this.errorMsgImage = JFaceResources.getImage(PREF_DLG_IMG_TITLE_ERROR);
                }
                this.normalMsgAreaBackground = this.messageLabel.getBackground();
                this.messageLabel.setBackground(this.errorMsgAreaBackground);
                this.messageLabel.setImage(this.errorMsgImage);
                this.titleImage.setImage(null);
            }
        }
        this.titleArea.layout(true);
    }

    public void setHelpAvailable(boolean b) {
        this.isHelpAvailable = b;
    }

    public void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    public void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage("dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage("dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage(PREF_DLG_IMG_TITLE_ERROR);
                }
            }
        }
        this.showMessage(newMessage, newImage);
    }

    public void setMinimumPageSize(int minWidth, int minHeight) {
        this.minimumPageSize.x = minWidth;
        this.minimumPageSize.y = minHeight;
    }

    public void setMinimumPageSize(Point size) {
        this.minimumPageSize.x = size.x;
        this.minimumPageSize.y = size.y;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        Assert.isNotNull(store);
        this.preferenceStore = store;
    }

    private void setShellSize(int width, int height) {
        this.getShell().setSize(width, height);
        this.constrainShellSize();
    }

    private void showMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        if (this.message == null) {
            this.message = "";
        }
        this.messageImage = newImage;
        if (!this.showingError) {
            this.messageLabel.setText(this.message);
            this.messageLabel.setImage(this.messageImage);
            this.messageLabel.setToolTipText(this.message);
        }
    }

    protected boolean showPage(IPreferenceNode node) {
        if (node == null) {
            return false;
        }
        if (node.getPage() == null) {
            node.createPage();
        }
        if (node.getPage() == null) {
            return false;
        }
        IPreferencePage newPage = node.getPage();
        if (newPage == this.currentPage) {
            return true;
        }
        if (this.currentPage != null && !this.currentPage.okToLeave()) {
            return false;
        }
        IPreferencePage oldPage = this.currentPage;
        this.currentPage = newPage;
        this.currentPage.setContainer(this);
        if (this.currentPage.getControl() == null) {
            final boolean[] failed = new boolean[1];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    PreferenceDialog.this.currentPage.createControl(PreferenceDialog.this.pageContainer);
                }

                public void handleException(Throwable e) {
                    failed[0] = true;
                }
            });
            if (failed[0]) {
                return false;
            }
            Assert.isNotNull(this.currentPage.getControl());
        }
        final Point[] size = new Point[1];
        final Point failed = new Point(-1, -1);
        Platform.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                size[0] = PreferenceDialog.this.currentPage.computeSize();
            }

            public void handleException(Throwable e) {
                size[0] = failed;
            }
        });
        if (size[0].equals((Object)failed)) {
            return false;
        }
        Point contentSize = size[0];
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        if (oldPage != null) {
            Rectangle rect = this.pageContainer.getClientArea();
            Point containerSize = new Point(rect.width, rect.height);
            int hdiff = contentSize.x - containerSize.x;
            int vdiff = contentSize.y - containerSize.y;
            if (hdiff > 0 || vdiff > 0) {
                if (shellSize.equals((Object)this.lastShellSize)) {
                    hdiff = Math.max(0, hdiff);
                    vdiff = Math.max(0, vdiff);
                    this.setShellSize(shellSize.x + hdiff, shellSize.y + vdiff);
                    this.lastShellSize = shell.getSize();
                } else {
                    this.currentPage.setSize(containerSize);
                }
            } else if (hdiff < 0 || vdiff < 0) {
                this.currentPage.setSize(containerSize);
            }
        }
        Control[] children = this.pageContainer.getChildren();
        Control currentControl = this.currentPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.update();
        return true;
    }

    void showPageFlippingAbortDialog() {
        MessageDialog.openError(this.getShell(), JFaceResources.getString("AbortPageFlippingDialog.title"), JFaceResources.getString("AbortPageFlippingDialog.message"));
    }

    protected void update() {
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
        this.setSelectedNode();
    }

    public void updateButtons() {
        this.okButton.setEnabled(this.isCurrentPageValid());
    }

    public void updateMessage() {
        String pageMessage = this.currentPage.getMessage();
        int pageMessageType = 0;
        if (pageMessage != null && this.currentPage instanceof IMessageProvider) {
            pageMessageType = ((IMessageProvider)((Object)this.currentPage)).getMessageType();
        }
        String pageErrorMessage = this.currentPage.getErrorMessage();
        if (pageMessage == null && pageErrorMessage == null) {
            this.messageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.messageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (pageMessage == null) {
            this.setMessage(this.currentPage.getTitle());
        } else {
            this.setMessage(pageMessage, pageMessageType);
        }
        this.setErrorMessage(pageErrorMessage);
    }

    public void updateTitle() {
        this.updateMessage();
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = PreferenceDialog.this.minimumPageSize.x;
            int y = PreferenceDialog.this.minimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

