/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContextResolver;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContextResolver;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ActionContributionItem
extends ContributionItem {
    private static boolean USE_COLOR_ICONS = true;
    private static ImageCache globalImageCache;
    private IAction action;
    private Widget widget = null;
    private Widget parentWidget = null;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ActionContributionItem.this.actionPropertyChange(event);
        }
    };
    private Listener buttonListener;
    private Listener toolItemListener;
    private Listener menuItemListener;

    public boolean isVisible() {
        IAction action = this.getAction();
        if (action != null) {
            String commandId = action.getActionDefinitionId();
            IContextResolver contextResolver = ContextResolver.getInstance().getContextResolver();
            if (contextResolver != null) {
                return contextResolver.inContext(commandId);
            }
        }
        return true;
    }

    public static boolean getUseColorIconsInToolbars() {
        return USE_COLOR_ICONS;
    }

    public static void setUseColorIconsInToolbars(boolean useColorIcons) {
        USE_COLOR_ICONS = useColorIcons;
    }

    public ActionContributionItem(IAction action) {
        super(action.getId());
        this.action = action;
    }

    private void actionPropertyChange(final PropertyChangeEvent e) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(e.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        ActionContributionItem.this.update(e.getProperty());
                    }
                });
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean belongsToContextMenu(MenuItem item) {
        menu = item.getParent();
        if (menu != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            menu = menu.getParentMenu();
lbl5:
            // 2 sources

            ** while (menu.getParentMenu() != null)
        }
lbl6:
        // 1 sources

        return (menu.getStyle() & 2) == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActionContributionItem)) {
            return false;
        }
        return this.action.equals(((ActionContributionItem)o).action);
    }

    public void fill(Composite parent) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            if (this.action != null) {
                if (this.action.getStyle() == 2) {
                    flags = 2;
                }
                if (this.action.getStyle() == 8) {
                    flags = 16;
                }
            }
            Button b = new Button(parent, flags);
            b.setData((Object)this);
            b.addListener(12, this.getButtonListener());
            b.addListener(13, this.getButtonListener());
            if (this.action.getHelpListener() != null) {
                b.addHelpListener(this.action.getHelpListener());
            }
            this.widget = b;
            this.parentWidget = parent;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
        }
    }

    public void fill(Menu parent, int index) {
        if (this.widget == null && parent != null) {
            Menu subMenu = null;
            int flags = 8;
            if (this.action != null) {
                IMenuCreator mc;
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                } else if (style == 4 && (mc = this.action.getMenuCreator()) != null) {
                    subMenu = mc.getMenu(parent);
                    flags = 64;
                }
            }
            MenuItem mi = null;
            mi = index >= 0 ? new MenuItem(parent, flags, index) : new MenuItem(parent, flags);
            this.widget = mi;
            this.parentWidget = parent;
            mi.setData((Object)this);
            mi.addListener(12, this.getMenuItemListener());
            mi.addListener(13, this.getMenuItemListener());
            if (this.action.getHelpListener() != null) {
                mi.addHelpListener(this.action.getHelpListener());
            }
            if (subMenu != null) {
                mi.setMenu(subMenu);
            }
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            if (this.action != null) {
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                } else if (style == 4) {
                    flags = 4;
                }
            }
            ToolItem ti = null;
            ti = index >= 0 ? new ToolItem(parent, flags, index) : new ToolItem(parent, flags);
            ti.setData((Object)this);
            ti.addListener(13, this.getToolItemListener());
            ti.addListener(12, this.getToolItemListener());
            this.widget = ti;
            this.parentWidget = parent;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
        }
    }

    public IAction getAction() {
        return this.action;
    }

    private ImageCache getImageCache() {
        ImageCache cache = globalImageCache;
        if (cache == null) {
            globalImageCache = cache = new ImageCache();
            Display display = Display.getDefault();
            if (display != null) {
                display.disposeExec(new Runnable(){

                    public void run() {
                        if (globalImageCache != null) {
                            globalImageCache.dispose();
                            globalImageCache = null;
                        }
                    }
                });
            }
        }
        return cache;
    }

    private Listener getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((Button)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.buttonListener;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private Listener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((MenuItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetDispose(Event e) {
        if (e.widget == this.widget) {
            IMenuCreator mc;
            if (this.action.getStyle() == 4 && (mc = this.action.getMenuCreator()) != null) {
                mc.dispose();
            }
            this.action.removePropertyChangeListener(this.propertyListener);
            this.widget = null;
        }
    }

    private void handleWidgetSelection(Event e, boolean selection) {
        Widget item = e.widget;
        if (item != null) {
            int style = item.getStyle();
            if ((style & 0x22) != 0) {
                if (this.action.getStyle() == 2) {
                    this.action.setChecked(selection);
                }
            } else if ((style & 0x10) != 0) {
                if (this.action.getStyle() == 8) {
                    this.action.setChecked(selection);
                }
            } else if ((style & 4) != 0 && e.detail == 4 && this.action.getStyle() == 4) {
                Menu m;
                IMenuCreator mc = this.action.getMenuCreator();
                ToolItem ti = (ToolItem)item;
                if (mc != null && (m = mc.getMenu((Control)ti.getParent())) != null) {
                    Rectangle b = ti.getBounds();
                    Point p = ti.getParent().toDisplay(new Point(b.x, b.y + b.height));
                    m.setLocation(p.x, p.y);
                    m.setVisible(true);
                    return;
                }
            }
            if (this.action.isEnabled()) {
                boolean trace = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface/trace/actions"));
                long ms = System.currentTimeMillis();
                if (trace) {
                    System.out.println("Running action: " + this.action.getText());
                }
                this.action.runWithEvent(e);
                if (trace) {
                    System.out.println(String.valueOf(System.currentTimeMillis() - ms) + " ms to run action: " + this.action.getText());
                }
            }
        }
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean actionIsRadio;
            boolean itemIsCheck = (this.widget.getStyle() & 0x20) != 0;
            boolean actionIsCheck = this.getAction() != null && this.getAction().getStyle() == 2;
            boolean itemIsRadio = (this.widget.getStyle() & 0x10) != 0;
            boolean bl = actionIsRadio = this.getAction() != null && this.getAction().getStyle() == 8;
            return itemIsCheck != actionIsCheck || itemIsRadio != actionIsRadio;
        }
        return false;
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean value = this.getParent().getOverrides().getEnabled(this);
        return value == null ? true : value;
    }

    public final void update() {
        this.update(null);
    }

    public void update(String propertyName) {
        if (this.widget != null) {
            boolean checkChanged;
            boolean textChanged = propertyName == null || propertyName.equals("text");
            boolean imageChanged = propertyName == null || propertyName.equals("image");
            boolean tooltipTextChanged = propertyName == null || propertyName.equals("toolTipText");
            boolean enableStateChanged = propertyName == null || propertyName.equals("enabled") || propertyName.equals("enabled");
            boolean bl = checkChanged = !(this.action.getStyle() != 2 && this.action.getStyle() != 8 || propertyName != null && !propertyName.equals("checked"));
            if (this.widget instanceof ToolItem) {
                ToolItem ti = (ToolItem)this.widget;
                if (imageChanged) {
                    this.updateImages(true);
                }
                if (tooltipTextChanged) {
                    ti.setToolTipText(this.action.getToolTipText());
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl2 = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (ti.getEnabled() != shouldBeEnabled) {
                        ti.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (ti.getSelection() != bv) {
                        ti.setSelection(bv);
                    }
                }
                return;
            }
            if (this.widget instanceof MenuItem) {
                MenuItem mi = (MenuItem)this.widget;
                boolean isContextMenu = ActionContributionItem.belongsToContextMenu(mi);
                if (textChanged) {
                    String text;
                    if (isContextMenu) {
                        text = this.action.getText();
                        if (text != null) {
                            text = Action.removeAcceleratorText(text);
                            mi.setText(text);
                        }
                    } else {
                        text = null;
                        IContributionManagerOverrides overrides = null;
                        if (this.getParent() != null) {
                            overrides = this.getParent().getOverrides();
                        }
                        if (overrides != null) {
                            text = this.getParent().getOverrides().getText(this);
                        }
                        if (text == null) {
                            text = this.action.getText();
                        }
                        if (text != null) {
                            String label = Action.removeAcceleratorText(text);
                            String accText = null;
                            Integer acc = null;
                            if (overrides != null) {
                                accText = overrides.getAcceleratorText(this);
                                acc = overrides.getAccelerator(this);
                            }
                            if (accText == null && label.length() + 1 < text.length()) {
                                accText = text.substring(label.length() + 1);
                            }
                            if (acc == null) {
                                acc = new Integer(this.action.getAccelerator());
                            }
                            if (acc >= 0) {
                                mi.setAccelerator(acc.intValue());
                            }
                            if (accText == null) {
                                mi.setText(label);
                            } else {
                                mi.setText(String.valueOf(label) + '\t' + accText);
                            }
                        }
                    }
                }
                if (imageChanged) {
                    this.updateImages(false);
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl3 = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (mi.getEnabled() != shouldBeEnabled) {
                        mi.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (mi.getSelection() != bv) {
                        mi.setSelection(bv);
                    }
                }
                return;
            }
            if (this.widget instanceof Button) {
                String text;
                Button button = (Button)this.widget;
                if (imageChanged && this.updateImages(false)) {
                    textChanged = false;
                }
                if (textChanged && (text = this.action.getText()) != null) {
                    button.setText(text);
                }
                if (tooltipTextChanged) {
                    button.setToolTipText(this.action.getToolTipText());
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl4 = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (button.getEnabled() != shouldBeEnabled) {
                        button.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (button.getSelection() != bv) {
                        button.setSelection(bv);
                    }
                }
                return;
            }
        }
    }

    private boolean updateImages(boolean forceImage) {
        ImageCache cache = this.getImageCache();
        if (this.widget instanceof ToolItem) {
            if (USE_COLOR_ICONS) {
                Image image = cache.getImage(this.action.getHoverImageDescriptor());
                if (image == null) {
                    image = cache.getImage(this.action.getImageDescriptor());
                }
                Image disabledImage = cache.getImage(this.action.getDisabledImageDescriptor());
                if (image == null && forceImage) {
                    image = cache.getMissingImage();
                }
                if (disabledImage != null) {
                    ((ToolItem)this.widget).setDisabledImage(disabledImage);
                }
                ((ToolItem)this.widget).setImage(image);
                return image != null;
            }
            Image image = cache.getImage(this.action.getImageDescriptor());
            Image hoverImage = cache.getImage(this.action.getHoverImageDescriptor());
            Image disabledImage = cache.getImage(this.action.getDisabledImageDescriptor());
            if (image == null && hoverImage != null) {
                image = cache.getGrayImage(this.action.getHoverImageDescriptor());
            } else if (hoverImage == null && image != null) {
                hoverImage = image;
                image = cache.getGrayImage(this.action.getImageDescriptor());
            }
            if (hoverImage == null && image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (disabledImage != null) {
                ((ToolItem)this.widget).setDisabledImage(disabledImage);
            }
            ((ToolItem)this.widget).setHotImage(hoverImage);
            ((ToolItem)this.widget).setImage(image);
            return image != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            Image image = cache.getImage(this.action.getHoverImageDescriptor());
            if (image == null) {
                image = cache.getImage(this.action.getImageDescriptor());
            }
            if (image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (this.widget instanceof Item) {
                ((Item)this.widget).setImage(image);
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setImage(image);
            }
            return image != null;
        }
        return false;
    }

    private static class ImageCache {
        private Map entries = new HashMap(11);
        private Image missingImage;

        ImageCache() {
        }

        Entry getEntry(ImageDescriptor desc) {
            Entry entry = (Entry)this.entries.get(desc);
            if (entry == null) {
                entry = new Entry();
                this.entries.put(desc, entry);
            }
            return entry;
        }

        Image getImage(ImageDescriptor desc) {
            if (desc == null) {
                return null;
            }
            Entry entry = this.getEntry(desc);
            if (entry.image == null) {
                entry.image = desc.createImage();
            }
            return entry.image;
        }

        Image getGrayImage(ImageDescriptor desc) {
            Image image;
            if (desc == null) {
                return null;
            }
            Entry entry = this.getEntry(desc);
            if (entry.grayImage == null && (image = this.getImage(desc)) != null) {
                entry.grayImage = new Image(null, image, 2);
            }
            return entry.grayImage;
        }

        Image getMissingImage() {
            if (this.missingImage == null) {
                this.missingImage = this.getImage(ImageDescriptor.getMissingImageDescriptor());
            }
            return this.missingImage;
        }

        void dispose() {
            Iterator i = this.entries.values().iterator();
            while (i.hasNext()) {
                Entry entry = (Entry)i.next();
                entry.dispose();
            }
            this.entries.clear();
        }

        private class Entry {
            Image image;
            Image grayImage;

            Entry() {
            }

            void dispose() {
                if (this.image != null) {
                    this.image.dispose();
                    this.image = null;
                }
                if (this.grayImage != null) {
                    this.grayImage.dispose();
                    this.grayImage = null;
                }
            }
        }
    }
}

