package org.argosdic.dictionary;

import java.util.Properties;

import org.eclipse.jface.util.Assert;

/**
 * Dictionary.java
 * @author Xavier Cho
 * @version $Revision: 1.2 $ $Date: 2003/09/12 10:23:53 $
 */
public class Dictionary {
    private String id;
    private String name;
    private String description;
    private String copyright;

    public Dictionary(String id, Properties props) {
        this.id = id;
        this.name = props.getProperty("name"); //$NON-NLS-1$
        this.description = props.getProperty("description"); //$NON-NLS-1$
        this.copyright = props.getProperty("copyright"); //$NON-NLS-1$

        Assert.isNotNull(id);
        Assert.isNotNull(name);
    }

    /**
     * @return
     */
    public String getCopyright() {
        return copyright;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @return
     */
    public String getId() {
        return id;
    }

    /**
     * @return
     */
    public String getName() {
        return name;
    }
}
