package org.argosdic.action.program;

import org.argosdic.ArgosDic;
import org.argosdic.action.BaseAction;
import org.argosdic.speech.SpeechManager;
import org.eclipse.swt.widgets.Display;

/**
 * SpeakAction.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/13 08:32:23 $
 */
public class SpeakAction extends BaseAction {

    public SpeakAction(ArgosDic application) {
        super(application);

        setEnabled(false);
    }

    public void run() {
        Display.getCurrent().asyncExec(new Runnable() {
            public void run() {
                String sentence = application.getSearchWord();

                SpeechManager manager = SpeechManager.getInstance();
                manager.speak(sentence);
            }
        });
    }
}
