/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import com.sun.speech.freetts.relp.Sample;
import com.sun.speech.freetts.relp.SampleInfo;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SampleSet {
    private Sample[] samples;
    private SampleInfo sampleInfo;

    public SampleSet(StringTokenizer stringTokenizer, BufferedReader bufferedReader) {
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            this.samples = new Sample[n];
            this.sampleInfo = new SampleInfo(n3, n2, n4, f, f2, f3);
            int n5 = 0;
            while (n5 < n) {
                this.samples[n5] = new Sample(bufferedReader, n2);
                ++n5;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Error("Parsing sample error " + noSuchElementException.getMessage());
        }
    }

    public SampleSet(ByteBuffer byteBuffer) throws IOException {
        this.sampleInfo = new SampleInfo(byteBuffer);
        int n = byteBuffer.getInt();
        this.samples = new Sample[n];
        int n2 = 0;
        while (n2 < n) {
            this.samples[n2] = Sample.loadBinary(byteBuffer);
            ++n2;
        }
    }

    public SampleSet(DataInputStream dataInputStream) throws IOException {
        this.sampleInfo = new SampleInfo(dataInputStream);
        int n = dataInputStream.readInt();
        this.samples = new Sample[n];
        int n2 = 0;
        while (n2 < n) {
            this.samples[n2] = Sample.loadBinary(dataInputStream);
            ++n2;
        }
    }

    public void dumpBinary(DataOutputStream dataOutputStream) throws IOException {
        this.sampleInfo.dumpBinary(dataOutputStream);
        dataOutputStream.writeInt(this.samples.length);
        int n = 0;
        while (n < this.samples.length) {
            this.samples[n].dumpBinary(dataOutputStream);
            ++n;
        }
    }

    public Sample getSample(int n) {
        return this.samples[n];
    }

    public SampleInfo getSampleInfo() {
        return this.sampleInfo;
    }

    public int getUnitSize(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            n3 += this.getFrameSize(n4);
            ++n4;
        }
        return n3;
    }

    public int getFrameSize(int n) {
        return this.samples[n].getResidualSize();
    }
}

