/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SampleInfo {
    public static final String UTT_NAME = "SampleInfo";
    private final int sampleRate;
    private final int numberOfChannels;
    private final int residualFold;
    private final float coeffMin;
    private final float coeffRange;
    private final float postEmphasis;

    public SampleInfo(int n, int n2, int n3, float f, float f2, float f3) {
        this.sampleRate = n;
        this.numberOfChannels = n2;
        this.residualFold = n3;
        this.coeffMin = f;
        this.coeffRange = f2;
        this.postEmphasis = f3;
    }

    public SampleInfo(ByteBuffer byteBuffer) throws IOException {
        this.numberOfChannels = byteBuffer.getInt();
        this.sampleRate = byteBuffer.getInt();
        this.coeffMin = byteBuffer.getFloat();
        this.coeffRange = byteBuffer.getFloat();
        this.postEmphasis = byteBuffer.getFloat();
        this.residualFold = byteBuffer.getInt();
    }

    public SampleInfo(DataInputStream dataInputStream) throws IOException {
        this.numberOfChannels = dataInputStream.readInt();
        this.sampleRate = dataInputStream.readInt();
        this.coeffMin = dataInputStream.readFloat();
        this.coeffRange = dataInputStream.readFloat();
        this.postEmphasis = dataInputStream.readFloat();
        this.residualFold = dataInputStream.readInt();
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public final int getResidualFold() {
        return this.residualFold;
    }

    public final float getCoeffMin() {
        return this.coeffMin;
    }

    public final float getCoeffRange() {
        return this.coeffRange;
    }

    public final float getPostEmphasis() {
        return this.postEmphasis;
    }

    public void dumpBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.numberOfChannels);
        dataOutputStream.writeInt(this.sampleRate);
        dataOutputStream.writeFloat(this.coeffMin);
        dataOutputStream.writeFloat(this.coeffRange);
        dataOutputStream.writeFloat(this.postEmphasis);
        dataOutputStream.writeInt(this.residualFold);
    }
}

