/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Sample {
    private short[] frameData;
    private byte[] residualData;
    private int residualSize;

    public Sample(short[] sArray, byte[] byArray) {
        this.frameData = sArray;
        this.residualData = byArray;
    }

    public Sample(short[] sArray, byte[] byArray, int n) {
        this.frameData = sArray;
        this.residualData = byArray;
        this.residualSize = n;
    }

    public Sample(BufferedReader bufferedReader, int n) {
        try {
            int n2;
            String string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.nextToken().equals("FRAME")) {
                throw new Error("frame Parsing sample error");
            }
            this.frameData = new short[n];
            int n3 = 0;
            while (n3 < n) {
                n2 = Integer.parseInt(stringTokenizer.nextToken()) - 32768;
                if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                    throw new Error("data out of short range");
                }
                this.frameData[n3] = (short)n2;
                ++n3;
            }
            string = bufferedReader.readLine();
            stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.nextToken().equals("RESIDUAL")) {
                throw new Error("residual Parsing sample error");
            }
            this.residualSize = Integer.parseInt(stringTokenizer.nextToken());
            this.residualData = new byte[this.residualSize];
            n2 = 0;
            while (n2 < this.residualSize) {
                int n4 = Integer.parseInt(stringTokenizer.nextToken()) - 128;
                if (n4 < -128 || n4 > 127) {
                    throw new Error("data out of byte range");
                }
                this.residualData[n2] = (byte)n4;
                ++n2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Error("Parsing sample error " + noSuchElementException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("IO error while parsing sample" + iOException.getMessage());
        }
    }

    public short[] getFrameData() {
        return this.frameData;
    }

    public byte[] getResidualData() {
        return this.residualData;
    }

    public int getResidualSize() {
        return this.residualSize;
    }

    public int getResidualData(int n) {
        return this.residualData[n] + 128;
    }

    public int getFrameData(int n) {
        return this.frameData[n] + 32768;
    }

    public void dump() {
        System.out.println(" FD Count: " + this.getFrameData().length);
        int n = 0;
        while (n < this.getFrameData().length) {
            System.out.print(" " + this.getFrameData(n));
            ++n;
        }
        System.out.println();
        System.out.println(" RD Count: " + this.getResidualSize());
        int n2 = 0;
        while (n2 < this.getResidualData().length) {
            System.out.print(" " + this.getResidualData(n2));
            ++n2;
        }
        System.out.println();
    }

    public void dumpBinary(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(this.frameData.length);
        int n = 0;
        while (n < this.frameData.length) {
            byteBuffer.putShort(this.frameData[n]);
            ++n;
        }
        byteBuffer.putInt(this.residualData.length);
        byteBuffer.put(this.residualData);
    }

    public void dumpBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.frameData.length);
        int n = 0;
        while (n < this.frameData.length) {
            dataOutputStream.writeShort(this.frameData[n]);
            ++n;
        }
        dataOutputStream.writeInt(this.residualData.length);
        int n2 = 0;
        while (n2 < this.residualData.length) {
            dataOutputStream.writeByte(this.residualData[n2]);
            ++n2;
        }
    }

    public static Sample loadBinary(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = byteBuffer.getShort();
            ++n2;
        }
        int n3 = byteBuffer.getInt();
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < byArray.length) {
            byArray[n4] = byteBuffer.get();
            ++n4;
        }
        return new Sample(sArray, byArray, n3);
    }

    public static Sample loadBinary(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = dataInputStream.readShort();
            ++n2;
        }
        int n3 = dataInputStream.readInt();
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n4 < byArray.length) {
            byArray[n4] = dataInputStream.readByte();
            ++n4;
        }
        return new Sample(sArray, byArray, n3);
    }

    public boolean compare(Sample sample) {
        if (this.frameData.length != sample.getFrameData().length) {
            return false;
        }
        int n = 0;
        while (n < this.frameData.length) {
            if (this.frameData[n] != sample.frameData[n]) {
                return false;
            }
            ++n;
        }
        if (this.residualData.length != sample.residualData.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.residualData.length) {
            if (this.residualData[n2] != sample.residualData[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

