/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.en.us.NumberExpander;
import com.sun.speech.freetts.en.us.PronounceableFSM;
import com.sun.speech.freetts.en.us.USEnglish;
import com.sun.speech.freetts.en.us.WordRelation;
import com.sun.speech.freetts.util.Utilities;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenToWords
implements UtteranceProcessor {
    private static final String RX_HAS_VOWEL = ".*[aeiouAEIOU].*";
    private static final Pattern alphabetPattern = Pattern.compile(USEnglish.RX_ALPHABET);
    private static final Pattern commaIntPattern = Pattern.compile(USEnglish.RX_COMMAINT);
    private static final Pattern digits2DashPattern = Pattern.compile("[0-9]+(-[0-9]+)(-[0-9]+)+");
    private static final Pattern digitsPattern = Pattern.compile(USEnglish.RX_DIGITS);
    private static final Pattern digitsSlashDigitsPattern = Pattern.compile("[0-9]+/[0-9]+");
    private static final Pattern dottedAbbrevPattern = Pattern.compile(USEnglish.RX_DOTTED_ABBREV);
    private static final Pattern doublePattern = Pattern.compile(USEnglish.RX_DOUBLE);
    private static final Pattern drStPattern = Pattern.compile("([dD][Rr]|[Ss][Tt])");
    private static final Pattern fourDigitsPattern = Pattern.compile("[0-9][0-9][0-9][0-9]");
    private static final Pattern hasVowelPattern = Pattern.compile(".*[aeiouAEIOU].*");
    private static final Pattern illionPattern = Pattern.compile(".*illion");
    private static final Pattern numberTimePattern = Pattern.compile("((0[0-2])|(1[0-9])):([0-5][0-9])");
    private static final Pattern numessPattern = Pattern.compile("[0-9]+s");
    private static final Pattern ordinalPattern = Pattern.compile(USEnglish.RX_ORDINAL_NUMBER);
    private static final Pattern romanNumbersPattern = Pattern.compile("(II?I?|IV|VI?I?I?|IX|X[VIX]*)");
    private static final Pattern sevenPhoneNumberPattern = Pattern.compile("[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]");
    private static final Pattern threeDigitsPattern = Pattern.compile("[0-9][0-9][0-9]");
    private static final Pattern usMoneyPattern = Pattern.compile("\\$[0-9,]+(\\.[0-9]+)?");
    private static final String[] kingNames = new String[]{"louis", "henry", "charles", "philip", "george", "edward", "pius", "william", "richard", "ptolemy", "john", "paul", "peter", "nicholas", "frederick", "james", "alfonso", "ivan", "napoleon", "leo", "gregory", "catherine", "alexandria", "pierre", "elizabeth", "mary"};
    private static final String[] kingTitles = new String[]{"king", "queen", "pope", "duke", "tsar", "emperor", "shah", "caesar", "duchess", "tsarina", "empress", "baron", "baroness", "sultan", "count", "countess"};
    private static final String[] sectionTypes = new String[]{"section", "chapter", "part", "phrase", "verse", "scene", "act", "book", "volume", "chap", "war", "apollo", "trek", "fortran"};
    private static Hashtable kingSectionLikeHash = new Hashtable();
    private static final String KING_NAMES = "kingNames";
    private static final String KING_TITLES = "kingTitles";
    private static final String SECTION_TYPES = "sectionTypes";
    private static final String[] postrophes;
    private PronounceableFSM prefixFSM = null;
    private PronounceableFSM suffixFSM = null;
    private static final String[][] usStates;
    private static Hashtable usStatesHash;
    private WordRelation wordRelation;
    private Item tokenItem;
    private CART cart;

    public TokenToWords(CART cART, PronounceableFSM pronounceableFSM, PronounceableFSM pronounceableFSM2) {
        this.cart = cART;
        this.prefixFSM = pronounceableFSM;
        this.suffixFSM = pronounceableFSM2;
    }

    public Item getTokenItem() {
        return this.tokenItem;
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation relation = utterance.getRelation("Token");
        if (relation == null) {
            throw new IllegalStateException("TokenToWords: Token relation does not exist");
        }
        this.wordRelation = WordRelation.createWordRelation(utterance, this);
        this.tokenItem = relation.getHead();
        while (this.tokenItem != null) {
            FeatureSet featureSet = this.tokenItem.getFeatures();
            String string = featureSet.getString("name");
            this.tokenToWords(string);
            this.tokenItem = this.tokenItem.getNext();
        }
    }

    private boolean matchesPartPhoneNumber(String string) {
        String string2 = (String)this.tokenItem.findFeature("n.name");
        String string3 = (String)this.tokenItem.findFeature("n.n.name");
        String string4 = (String)this.tokenItem.findFeature("p.name");
        String string5 = (String)this.tokenItem.findFeature("p.p.name");
        boolean bl = TokenToWords.matches(threeDigitsPattern, string4);
        return TokenToWords.matches(threeDigitsPattern, string) && (!TokenToWords.matches(digitsPattern, string4) && TokenToWords.matches(threeDigitsPattern, string2) && TokenToWords.matches(fourDigitsPattern, string3) || TokenToWords.matches(sevenPhoneNumberPattern, string2) || !TokenToWords.matches(digitsPattern, string5) && bl && TokenToWords.matches(fourDigitsPattern, string2)) || TokenToWords.matches(fourDigitsPattern, string) && !TokenToWords.matches(digitsPattern, string2) && bl && TokenToWords.matches(threeDigitsPattern, string5);
    }

    private static boolean inStringArray(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void tokenToWords(String string) {
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String string2 = featureSet.getString("name");
        int n = string.length();
        if (featureSet.isPresent("phones")) {
            this.wordRelation.addWord(string);
        } else if ((string.equals("a") || string.equals("A")) && !string.equals(string2)) {
            this.wordRelation.addWord("_a");
        } else if (TokenToWords.matches(alphabetPattern, string)) {
            if (TokenToWords.matches(romanNumbersPattern, string)) {
                this.romanToWords(string);
            } else if (TokenToWords.matches(illionPattern, string) && TokenToWords.matches(usMoneyPattern, (String)this.tokenItem.findFeature("p.name"))) {
                this.wordRelation.addWord(string);
                this.wordRelation.addWord("dollars");
            } else if (TokenToWords.matches(drStPattern, string)) {
                this.drStToWords(string);
            } else if (string.equals("Mr")) {
                this.tokenItem.getFeatures().setString("punc", "");
                this.wordRelation.addWord("mister");
            } else if (string.equals("Mrs")) {
                this.tokenItem.getFeatures().setString("punc", "");
                this.wordRelation.addWord("missus");
            } else if (n == 1 && TokenToWords.isUppercaseLetter(string.charAt(0)) && ((String)this.tokenItem.findFeature("n.whitespace")).equals(" ") && TokenToWords.isUppercaseLetter(((String)this.tokenItem.findFeature("n.name")).charAt(0))) {
                featureSet.setString("punc", "");
                String string3 = string.toLowerCase();
                if (string3.equals("a")) {
                    this.wordRelation.addWord("_a");
                } else {
                    this.wordRelation.addWord(string3);
                }
            } else if (!this.isStateName(string)) {
                if (n > 1 && !this.isPronounceable(string)) {
                    NumberExpander.expandLetters(string, this.wordRelation);
                } else {
                    this.wordRelation.addWord(string.toLowerCase());
                }
            }
        } else if (TokenToWords.matches(dottedAbbrevPattern, string)) {
            String string4 = Utilities.deleteChar(string, '.');
            NumberExpander.expandLetters(string4, this.wordRelation);
        } else if (TokenToWords.matches(commaIntPattern, string)) {
            String string5 = Utilities.deleteChar(string, ',');
            NumberExpander.expandReal(string5, this.wordRelation);
        } else if (TokenToWords.matches(sevenPhoneNumberPattern, string)) {
            int n2 = string.indexOf(45);
            String string6 = string.substring(0, n2);
            String string7 = string.substring(n2 + 1);
            NumberExpander.expandDigits(string6, this.wordRelation);
            this.wordRelation.addBreak();
            NumberExpander.expandDigits(string7, this.wordRelation);
        } else if (this.matchesPartPhoneNumber(string)) {
            String string8 = (String)this.tokenItem.findFeature("punc");
            if (string8.equals("")) {
                this.tokenItem.getFeatures().setString("punc", ",");
            }
            NumberExpander.expandDigits(string, this.wordRelation);
            this.wordRelation.addBreak();
        } else if (TokenToWords.matches(numberTimePattern, string)) {
            int n3 = string.indexOf(58);
            String string9 = string.substring(0, n3);
            String string10 = string.substring(n3 + 1);
            NumberExpander.expandNumber(string9, this.wordRelation);
            if (!string10.equals("00")) {
                NumberExpander.expandID(string10, this.wordRelation);
            }
        } else if (TokenToWords.matches(digits2DashPattern, string)) {
            this.digitsDashToWords(string);
        } else if (TokenToWords.matches(digitsPattern, string)) {
            this.digitsToWords(string);
        } else if (n == 1 && TokenToWords.isUppercaseLetter(string.charAt(0)) && ((String)this.tokenItem.findFeature("n.whitespace")).equals(" ") && TokenToWords.isUppercaseLetter(((String)this.tokenItem.findFeature("n.name")).charAt(0))) {
            featureSet.setString("punc", "");
            String string11 = string.toLowerCase();
            if (string11.equals("a")) {
                this.wordRelation.addWord("_a");
            } else {
                this.wordRelation.addWord(string11);
            }
        } else if (TokenToWords.matches(doublePattern, string)) {
            NumberExpander.expandReal(string, this.wordRelation);
        } else if (TokenToWords.matches(ordinalPattern, string)) {
            String string12 = string.substring(0, n - 2);
            NumberExpander.expandOrdinal(string12, this.wordRelation);
        } else if (TokenToWords.matches(usMoneyPattern, string)) {
            this.usMoneyToWords(string);
        } else if (n > 0 && string.charAt(n - 1) == '%') {
            this.tokenToWords(string.substring(0, n - 1));
            this.wordRelation.addWord("per");
            this.wordRelation.addWord("cent");
        } else if (TokenToWords.matches(numessPattern, string)) {
            this.tokenToWords(string.substring(0, n - 1));
            this.wordRelation.addWord("'s");
        } else if (string.indexOf(39) != -1) {
            this.postropheToWords(string);
        } else if (TokenToWords.matches(digitsSlashDigitsPattern, string) && string.equals(string2)) {
            this.digitsSlashDigitsToWords(string);
        } else if (string.indexOf(45) != -1) {
            this.dashToWords(string);
        } else if (n > 1 && !TokenToWords.matches(alphabetPattern, string)) {
            this.notJustAlphasToWords(string);
        } else {
            this.wordRelation.addWord(string.toLowerCase());
        }
    }

    private void digitsDashToWords(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 <= n) {
            if (n3 == n || string.charAt(n3) == '-') {
                String string2 = string.substring(n2, n3);
                NumberExpander.expandDigits(string2, this.wordRelation);
                this.wordRelation.addBreak();
                n2 = n3 + 1;
            }
            ++n3;
        }
    }

    private void digitsToWords(String string) {
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String string2 = "";
        if (featureSet.isPresent("nsw")) {
            string2 = featureSet.getString("nsw");
        }
        if (string2.equals("nide")) {
            NumberExpander.expandID(string, this.wordRelation);
        } else {
            String string3 = featureSet.getString("name");
            String string4 = null;
            if (string.equals(string3)) {
                string4 = (String)this.cart.interpret(this.tokenItem);
            } else {
                featureSet.setString("name", string);
                string4 = (String)this.cart.interpret(this.tokenItem);
                featureSet.setString("name", string3);
            }
            if (string4.equals("ordinal")) {
                NumberExpander.expandOrdinal(string, this.wordRelation);
            } else if (string4.equals("digits")) {
                NumberExpander.expandDigits(string, this.wordRelation);
            } else if (string4.equals("year")) {
                NumberExpander.expandID(string, this.wordRelation);
            } else {
                NumberExpander.expandNumber(string, this.wordRelation);
            }
        }
    }

    private void romanToWords(String string) {
        String string2 = (String)this.tokenItem.findFeature("p.punc");
        if (string2.equals("")) {
            String string3 = String.valueOf(NumberExpander.expandRoman(string));
            if (TokenToWords.kingLike(this.tokenItem)) {
                this.wordRelation.addWord("the");
                NumberExpander.expandOrdinal(string3, this.wordRelation);
            } else if (TokenToWords.sectionLike(this.tokenItem)) {
                NumberExpander.expandNumber(string3, this.wordRelation);
            } else {
                NumberExpander.expandLetters(string, this.wordRelation);
            }
        } else {
            NumberExpander.expandLetters(string, this.wordRelation);
        }
    }

    private static boolean inKingSectionLikeHash(String string, String string2) {
        String string3 = (String)kingSectionLikeHash.get(string);
        if (string3 != null) {
            return string3.equals(string2);
        }
        return false;
    }

    public static boolean kingLike(Item item) {
        String string = ((String)item.findFeature("p.name")).toLowerCase();
        if (TokenToWords.inKingSectionLikeHash(string, KING_NAMES)) {
            return true;
        }
        String string2 = ((String)item.findFeature("p.p.name")).toLowerCase();
        return TokenToWords.inKingSectionLikeHash(string2, KING_TITLES);
    }

    public static boolean sectionLike(Item item) {
        String string = ((String)item.findFeature("p.name")).toLowerCase();
        return TokenToWords.inKingSectionLikeHash(string, SECTION_TYPES);
    }

    private void drStToWords(String string) {
        String string2 = null;
        String string3 = null;
        char c = string.charAt(0);
        if (c == 's' || c == 'S') {
            string2 = "street";
            string3 = "saint";
        } else {
            string2 = "drive";
            string3 = "doctor";
        }
        FeatureSet featureSet = this.tokenItem.getFeatures();
        String string4 = featureSet.getString("punc");
        String string5 = (String)this.tokenItem.findFeature("punc");
        if (this.tokenItem.getNext() == null || string4.indexOf(44) != -1) {
            this.wordRelation.addWord(string2);
        } else if (string5.equals(",")) {
            this.wordRelation.addWord(string3);
        } else {
            String string6 = (String)this.tokenItem.findFeature("p.name");
            String string7 = (String)this.tokenItem.findFeature("n.name");
            char c2 = string6.charAt(0);
            char c3 = string7.charAt(0);
            if (TokenToWords.isUppercaseLetter(c2) && TokenToWords.isLowercaseLetter(c3)) {
                this.wordRelation.addWord(string2);
            } else if (NumberExpander.isDigit(c2) && TokenToWords.isLowercaseLetter(c3)) {
                this.wordRelation.addWord(string2);
            } else if (TokenToWords.isLowercaseLetter(c2) && TokenToWords.isUppercaseLetter(c3)) {
                this.wordRelation.addWord(string3);
            } else {
                String string8 = (String)this.tokenItem.findFeature("n.whitespace");
                if (string8.equals(" ")) {
                    this.wordRelation.addWord(string3);
                } else {
                    this.wordRelation.addWord(string2);
                }
            }
        }
        if (string4 != null && string4.equals(".")) {
            featureSet.setString("punc", "");
        }
    }

    private void usMoneyToWords(String string) {
        int n = string.indexOf(46);
        if (TokenToWords.matches(illionPattern, (String)this.tokenItem.findFeature("n.name"))) {
            NumberExpander.expandReal(string.substring(1), this.wordRelation);
        } else if (n == -1) {
            String string2 = string.substring(1);
            this.tokenToWords(string2);
            if (string2.equals("1")) {
                this.wordRelation.addWord("dollar");
            } else {
                this.wordRelation.addWord("dollars");
            }
        } else if (n == string.length() - 1 || string.length() - n > 3) {
            NumberExpander.expandReal(string.substring(1), this.wordRelation);
            this.wordRelation.addWord("dollars");
        } else {
            String string3 = string.substring(1, n);
            string3 = Utilities.deleteChar(string3, ',');
            String string4 = string.substring(n + 1);
            NumberExpander.expandNumber(string3, this.wordRelation);
            if (string3.equals("1")) {
                this.wordRelation.addWord("dollar");
            } else {
                this.wordRelation.addWord("dollars");
            }
            if (!string4.equals("00")) {
                NumberExpander.expandNumber(string4, this.wordRelation);
                if (string4.equals("01")) {
                    this.wordRelation.addWord("cent");
                } else {
                    this.wordRelation.addWord("cents");
                }
            }
        }
    }

    private void postropheToWords(String string) {
        int n = string.indexOf(39);
        String string2 = string.substring(n).toLowerCase();
        if (TokenToWords.inStringArray(string2, postrophes)) {
            String string3 = string.substring(0, n);
            this.tokenToWords(string3);
            this.wordRelation.addWord(string2);
        } else if (string2.equals("'tve")) {
            String string4 = string.substring(0, n - 2);
            this.tokenToWords(string4);
            this.wordRelation.addWord("'ve");
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            this.tokenToWords(stringBuffer.toString());
        }
    }

    private void digitsSlashDigitsToWords(String string) {
        int n = string.indexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (TokenToWords.matches(digitsPattern, (String)this.tokenItem.findFeature("p.name")) && this.tokenItem.getPrevious() != null) {
            this.wordRelation.addWord("and");
        }
        if (string2.equals("1") && string3.equals("2")) {
            this.wordRelation.addWord("a");
            this.wordRelation.addWord("half");
        } else {
            int n2;
            int n3 = Integer.parseInt(string2);
            if (n3 < (n2 = Integer.parseInt(string3))) {
                NumberExpander.expandNumber(string2, this.wordRelation);
                NumberExpander.expandOrdinal(string3, this.wordRelation);
                if (n3 > 1) {
                    this.wordRelation.addWord("'s");
                }
            } else {
                NumberExpander.expandNumber(string2, this.wordRelation);
                this.wordRelation.addWord("slash");
                NumberExpander.expandNumber(string3, this.wordRelation);
            }
        }
    }

    private void dashToWords(String string) {
        int n = string.indexOf(45);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (TokenToWords.matches(digitsPattern, string2) && TokenToWords.matches(digitsPattern, string3)) {
            FeatureSet featureSet = this.tokenItem.getFeatures();
            featureSet.setString("name", string2);
            this.tokenToWords(string2);
            this.wordRelation.addWord("to");
            featureSet.setString("name", string3);
            this.tokenToWords(string3);
            featureSet.setString("name", "");
        } else {
            this.tokenToWords(string2);
            this.tokenToWords(string3);
        }
    }

    private void notJustAlphasToWords(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (TokenToWords.isTextSplitable(string, n)) break;
            ++n;
        }
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, n2);
        FeatureSet featureSet = this.tokenItem.getFeatures();
        featureSet.setString("nsw", "nide");
        this.tokenToWords(string2);
        this.tokenToWords(string3);
    }

    public boolean isPronounceable(String string) {
        String string2 = string.toLowerCase();
        return this.prefixFSM.accept(string2) && this.suffixFSM.accept(string2);
    }

    private boolean isStateName(String string) {
        String[] stringArray = (String[])usStatesHash.get(string);
        if (stringArray != null) {
            boolean bl = false;
            if (stringArray[1].equals("ambiguous")) {
                String string2 = (String)this.tokenItem.findFeature("p.name");
                String string3 = (String)this.tokenItem.findFeature("n.name");
                int n = string3.length();
                FeatureSet featureSet = this.tokenItem.getFeatures();
                bl = TokenToWords.isUppercaseLetter(string2.charAt(0)) && string2.length() > 2 && TokenToWords.matches(alphabetPattern, string2) && (TokenToWords.isLowercaseLetter(string3.charAt(0)) || this.tokenItem.getNext() == null || featureSet.getString("punc").equals(".") || (n == 5 || n == 10) && TokenToWords.matches(digitsPattern, string3));
            } else {
                bl = true;
            }
            if (bl) {
                int n = 2;
                while (n < stringArray.length) {
                    if (stringArray[n] != null) {
                        this.wordRelation.addWord(stringArray[n]);
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean matches(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private static boolean isTextSplitable(String string, int n) {
        char c = string.charAt(n);
        char c2 = string.charAt(n + 1);
        if (TokenToWords.isLetter(c) && TokenToWords.isLetter(c2)) {
            return false;
        }
        return !NumberExpander.isDigit(c) || !NumberExpander.isDigit(c2);
    }

    private static boolean isLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isUppercaseLetter(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isLowercaseLetter(char c) {
        return 'a' <= c && c <= 'z';
    }

    public String toString() {
        return "TokenToWords";
    }

    static {
        int n = 0;
        while (n < kingNames.length) {
            kingSectionLikeHash.put(kingNames[n], KING_NAMES);
            ++n;
        }
        int n2 = 0;
        while (n2 < kingTitles.length) {
            kingSectionLikeHash.put(kingTitles[n2], KING_TITLES);
            ++n2;
        }
        int n3 = 0;
        while (n3 < sectionTypes.length) {
            kingSectionLikeHash.put(sectionTypes[n3], SECTION_TYPES);
            ++n3;
        }
        postrophes = new String[]{"'s", "'ll", "'ve", "'d"};
        usStates = new String[][]{{"AL", "ambiguous", "alabama"}, {"Al", "ambiguous", "alabama"}, {"Ala", "", "alabama"}, {"AK", "", "alaska"}, {"Ak", "", "alaska"}, {"AZ", "", "arizona"}, {"Az", "", "arizona"}, {"CA", "", "california"}, {"Ca", "", "california"}, {"Cal", "ambiguous", "california"}, {"Calif", "", "california"}, {"CO", "ambiguous", "colorado"}, {"Co", "ambiguous", "colorado"}, {"Colo", "", "colorado"}, {"DC", "", "d", "c"}, {"DE", "", "delaware"}, {"De", "ambiguous", "delaware"}, {"Del", "ambiguous", "delaware"}, {"FL", "", "florida"}, {"Fl", "ambiguous", "florida"}, {"Fla", "", "florida"}, {"GA", "", "georgia"}, {"Ga", "", "georgia"}, {"HI", "ambiguous", "hawaii"}, {"Hi", "ambiguous", "hawaii"}, {"IA", "", "indiana"}, {"Ia", "ambiguous", "indiana"}, {"Ind", "ambiguous", "indiana"}, {"ID", "ambiguous", "idaho"}, {"IL", "ambiguous", "illinois"}, {"Il", "ambiguous", "illinois"}, {"ILL", "ambiguous", "illinois"}, {"KS", "", "kansas"}, {"Ks", "", "kansas"}, {"Kans", "", "kansas"}, {"KY", "ambiguous", "kentucky"}, {"Ky", "ambiguous", "kentucky"}, {"LA", "ambiguous", "louisiana"}, {"La", "ambiguous", "louisiana"}, {"Lou", "ambiguous", "louisiana"}, {"Lous", "ambiguous", "louisiana"}, {"MA", "ambiguous", "massachusetts"}, {"Mass", "ambiguous", "massachusetts"}, {"Ma", "ambiguous", "massachusetts"}, {"MD", "ambiguous", "maryland"}, {"Md", "ambiguous", "maryland"}, {"ME", "ambiguous", "maine"}, {"Me", "ambiguous", "maine"}, {"MI", "", "michigan"}, {"Mi", "ambiguous", "michigan"}, {"Mich", "ambiguous", "michigan"}, {"MN", "ambiguous", "minnestota"}, {"Minn", "ambiguous", "minnestota"}, {"MS", "ambiguous", "mississippi"}, {"Miss", "ambiguous", "mississippi"}, {"MT", "ambiguous", "montanna"}, {"Mt", "ambiguous", "montanna"}, {"MO", "ambiguous", "missouri"}, {"Mo", "ambiguous", "missouri"}, {"NC", "ambiguous", "north", "carolina"}, {"ND", "ambiguous", "north", "dakota"}, {"NE", "ambiguous", "nebraska"}, {"Ne", "ambiguous", "nebraska"}, {"Neb", "ambiguous", "nebraska"}, {"NH", "ambiguous", "new", "hampshire"}, {"NV", "", "nevada"}, {"Nev", "", "nevada"}, {"NY", "", "new", "york"}, {"OH", "ambiguous", "ohio"}, {"OK", "ambiguous", "oklahoma"}, {"Okla", "", "oklahoma"}, {"OR", "ambiguous", "oregon"}, {"Or", "ambiguous", "oregon"}, {"Ore", "ambiguous", "oregon"}, {"PA", "ambiguous", "pennsylvania"}, {"Pa", "ambiguous", "pennsylvania"}, {"Penn", "ambiguous", "pennsylvania"}, {"RI", "ambiguous", "rhode", "island"}, {"SC", "ambiguous", "south", "carlolina"}, {"SD", "ambiguous", "south", "dakota"}, {"TN", "ambiguous", "tennesee"}, {"Tn", "ambiguous", "tennesee"}, {"Tenn", "ambiguous", "tennesee"}, {"TX", "ambiguous", "texas"}, {"Tx", "ambiguous", "texas"}, {"Tex", "ambiguous", "texas"}, {"UT", "ambiguous", "utah"}, {"VA", "ambiguous", "virginia"}, {"WA", "ambiguous", "washington"}, {"Wa", "ambiguous", "washington"}, {"Wash", "ambiguous", "washington"}, {"WI", "ambiguous", "wisconsin"}, {"Wi", "ambiguous", "wisconsin"}, {"WV", "ambiguous", "west", "virginia"}, {"WY", "ambiguous", "wyoming"}, {"Wy", "ambiguous", "wyoming"}, {"Wyo", "", "wyoming"}, {"PR", "ambiguous", "puerto", "rico"}};
        usStatesHash = new Hashtable();
        n = 0;
        while (n < usStates.length) {
            usStatesHash.put(usStates[n][0], usStates[n]);
            ++n;
        }
    }
}

