/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.PartOfSpeechImpl;
import com.sun.speech.freetts.PhoneDurationsImpl;
import com.sun.speech.freetts.PhoneSet;
import com.sun.speech.freetts.PhoneSetImpl;
import com.sun.speech.freetts.Segmenter;
import com.sun.speech.freetts.Tokenizer;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.cart.CARTImpl;
import com.sun.speech.freetts.cart.Durator;
import com.sun.speech.freetts.cart.Intonator;
import com.sun.speech.freetts.cart.Phraser;
import com.sun.speech.freetts.diphone.DiphoneUnitSelector;
import com.sun.speech.freetts.en.ContourGenerator;
import com.sun.speech.freetts.en.PartOfSpeechTagger;
import com.sun.speech.freetts.en.PauseGenerator;
import com.sun.speech.freetts.en.TokenizerImpl;
import com.sun.speech.freetts.en.us.CMULexicon;
import com.sun.speech.freetts.en.us.FeatureProcessors;
import com.sun.speech.freetts.en.us.PrefixFSM;
import com.sun.speech.freetts.en.us.SimpleVoicePostLexicalAnalyzer;
import com.sun.speech.freetts.en.us.SuffixFSM;
import com.sun.speech.freetts.en.us.TokenToWords;
import com.sun.speech.freetts.relp.AudioOutput;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.IOException;
import java.util.List;

public class SimpleVoice
extends Voice {
    private PhoneSet phoneSet;
    private String freettsPrefix = "com.sun.speech.freetts";
    private boolean useBinaryIO = Utilities.getProperty(this.freettsPrefix + ".useBinaryIO", "true").equals("true");
    private String silence = Utilities.getProperty(this.freettsPrefix + ".silence", "pau");
    private String joinType = Utilities.getProperty(this.freettsPrefix + ".joinType", "modified_lpc");

    public SimpleVoice() {
        this(false);
    }

    public SimpleVoice(boolean bl) {
        if (bl) {
            this.setLexicon(new CMULexicon());
        }
        this.setRate(150.0f);
        this.setPitch(100.0f);
        this.setPitchRange(11.0f);
    }

    protected void loader() throws IOException {
        this.setupFeatureSet();
        this.setupUtteranceProcessors();
        this.setupFeatureProcessors();
    }

    protected void setupFeatureSet() throws IOException {
        BulkTimer.LOAD.start("FeatureSet");
        FeatureSet featureSet = this.getFeatures();
        featureSet.setString("silence", this.silence);
        featureSet.setString("join_type", this.joinType);
        BulkTimer.LOAD.stop("FeatureSet");
    }

    protected void setupUtteranceProcessors() throws IOException {
        List list = this.getUtteranceProcessors();
        BulkTimer.LOAD.start("CartLoading");
        CARTImpl cARTImpl = new CARTImpl(this.getResource("nums_cart.txt"));
        CARTImpl cARTImpl2 = new CARTImpl(this.getResource("phrasing_cart.txt"));
        CARTImpl cARTImpl3 = new CARTImpl(this.getResource("int_accent_cart.txt"));
        CARTImpl cARTImpl4 = new CARTImpl(this.getResource("int_tone_cart.txt"));
        CARTImpl cARTImpl5 = new CARTImpl(this.getResource("durz_cart.txt"));
        BulkTimer.LOAD.stop("CartLoading");
        BulkTimer.LOAD.start("UtteranceProcessors");
        PhoneDurationsImpl phoneDurationsImpl = new PhoneDurationsImpl(this.getResource("dur_stat.txt"));
        PrefixFSM prefixFSM = new PrefixFSM(this.getResource("prefix_fsm.txt"));
        SuffixFSM suffixFSM = new SuffixFSM(this.getResource("suffix_fsm.txt"));
        list.add(new TokenToWords(cARTImpl, prefixFSM, suffixFSM));
        list.add(new PartOfSpeechTagger());
        list.add(new Phraser(cARTImpl2));
        list.add(new Segmenter());
        list.add(new PauseGenerator());
        list.add(new Intonator(cARTImpl3, cARTImpl4));
        list.add(new SimpleVoicePostLexicalAnalyzer());
        list.add(new Durator(cARTImpl5, 150.0f, phoneDurationsImpl));
        list.add(new ContourGenerator(this.getResource("f0_lr_terms.txt"), 170.0f, 34.0f));
        list.add(new DiphoneUnitSelector(this.getResource(this.useBinaryIO ? "cmu_kal/diphone_units.bin" : "cmu_kal/diphone_units.txt")));
        BulkTimer.LOAD.stop("UtteranceProcessors");
    }

    protected void setupFeatureProcessors() throws IOException {
        BulkTimer.LOAD.start("FeatureProcessing");
        PartOfSpeechImpl partOfSpeechImpl = new PartOfSpeechImpl(this.getResource("part_of_speech.txt"), "content");
        this.phoneSet = new PhoneSetImpl(this.getResource("phoneset.txt"));
        this.addFeatureProcessor("gpos", new FeatureProcessors.Gpos(partOfSpeechImpl));
        this.addFeatureProcessor("word_numsyls", new FeatureProcessors.WordNumSyls());
        this.addFeatureProcessor("ssyl_in", new FeatureProcessors.StressedSylIn());
        this.addFeatureProcessor("syl_in", new FeatureProcessors.SylIn());
        this.addFeatureProcessor("syl_out", new FeatureProcessors.SylOut());
        this.addFeatureProcessor("ssyl_out", new FeatureProcessors.StressedSylOut());
        this.addFeatureProcessor("syl_break", new FeatureProcessors.SylBreak());
        this.addFeatureProcessor("old_syl_break", new FeatureProcessors.SylBreak());
        this.addFeatureProcessor("num_digits", new FeatureProcessors.NumDigits());
        this.addFeatureProcessor("month_range", new FeatureProcessors.MonthRange());
        this.addFeatureProcessor("token_pos_guess", new FeatureProcessors.TokenPosGuess());
        this.addFeatureProcessor("sub_phrases", new FeatureProcessors.SubPhrases());
        this.addFeatureProcessor("asyl_in", new FeatureProcessors.AccentedSylIn());
        this.addFeatureProcessor("last_accent", new FeatureProcessors.LastAccent());
        this.addFeatureProcessor("pos_in_syl", new FeatureProcessors.PosInSyl());
        this.addFeatureProcessor("position_type", new FeatureProcessors.PositionType());
        this.addFeatureProcessor("ph_cplace", new FeatureProcessors.PH_CPlace());
        this.addFeatureProcessor("ph_ctype", new FeatureProcessors.PH_CType());
        this.addFeatureProcessor("ph_cvox", new FeatureProcessors.PH_CVox());
        this.addFeatureProcessor("ph_vc", new FeatureProcessors.PH_VC());
        this.addFeatureProcessor("ph_vfront", new FeatureProcessors.PH_VFront());
        this.addFeatureProcessor("ph_vheight", new FeatureProcessors.PH_VHeight());
        this.addFeatureProcessor("ph_vlng", new FeatureProcessors.PH_VLength());
        this.addFeatureProcessor("ph_vrnd", new FeatureProcessors.PH_VRnd());
        this.addFeatureProcessor("seg_coda_fric", new FeatureProcessors.SegCodaFric());
        this.addFeatureProcessor("seg_onset_stop", new FeatureProcessors.SegOnsetStop());
        this.addFeatureProcessor("seg_onsetcoda", new FeatureProcessors.SegOnsetCoda());
        this.addFeatureProcessor("syl_codasize", new FeatureProcessors.SylCodaSize());
        this.addFeatureProcessor("syl_onsetsize", new FeatureProcessors.SylOnsetSize());
        this.addFeatureProcessor("accented", new FeatureProcessors.Accented());
        BulkTimer.LOAD.stop("FeatureProcessing");
    }

    protected UtteranceProcessor getAudioOutput() throws IOException {
        return new AudioOutput();
    }

    public String getPhoneFeature(String string, String string2) {
        return this.phoneSet.getPhoneFeature(string, string2);
    }

    public Tokenizer getTokenizer() {
        TokenizerImpl tokenizerImpl = new TokenizerImpl();
        tokenizerImpl.setWhitespaceSymbols(" \t\n\r");
        tokenizerImpl.setSingleCharSymbols("");
        tokenizerImpl.setPrepunctuationSymbols("\"'`({[");
        tokenizerImpl.setPostpunctuationSymbols("\"'`.,:;!?(){}[]");
        return tokenizerImpl;
    }

    public String toString() {
        return "SimpleVoice";
    }
}

