/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.synthesis.BaseVoice;
import java.util.Vector;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;

public class VoiceList {
    protected Vector voiceList = new Vector();

    public VoiceList() {
    }

    public VoiceList(SynthesizerModeDesc synthesizerModeDesc) {
        Voice[] voiceArray = synthesizerModeDesc.getVoices();
        if (voiceArray != null) {
            int n = 0;
            while (n < voiceArray.length) {
                this.addVoice((BaseVoice)voiceArray[n]);
                ++n;
            }
        }
    }

    public void addVoice(BaseVoice baseVoice) {
        if (!this.voiceList.contains((Object)baseVoice)) {
            this.voiceList.addElement(baseVoice);
        }
    }

    public void removeVoice(BaseVoice baseVoice) {
        this.voiceList.removeElement((Object)baseVoice);
    }

    public BaseVoice getVoiceById(String string) {
        int n = 0;
        while (n < this.voiceList.size()) {
            BaseVoice baseVoice = (BaseVoice)((Object)this.voiceList.elementAt(n));
            if (baseVoice.getId().equals(string)) {
                return baseVoice;
            }
            ++n;
        }
        return null;
    }

    public String getVoiceId(Voice voice, int n) {
        BaseVoice baseVoice;
        Object object;
        String string;
        if (voice instanceof BaseVoice && (string = (object = (BaseVoice)voice).getId()) != null && string.length() > 0) {
            return string;
        }
        object = new int[this.voiceList.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.voiceList.size()) {
            baseVoice = (BaseVoice)((Object)this.voiceList.elementAt(n3));
            if (baseVoice.match(voice)) {
                if (n <= 0) {
                    return baseVoice.getId();
                }
                object[n2++] = (BaseVoice)n3;
            }
            ++n3;
        }
        if (n2 == 0) {
            return "";
        }
        n = (n - 1) % n2;
        baseVoice = (BaseVoice)((Object)this.voiceList.elementAt((int)object[n]));
        return baseVoice.getId();
    }

    public String getVoiceId(String string, int n, int n2, int n3) {
        String string2;
        if (string != null && string.length() > 0 && (string2 = this.getVoiceId(new Voice(string, 65535, 65535, null), 0)) != null && string2.length() > 0) {
            return string2;
        }
        string2 = this.getVoiceId(new Voice(null, n, n2, null), n3);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        int n4 = n2 | n2 << 1 | n2 >> 1;
        string2 = this.getVoiceId(new Voice(null, n, n4, null), n3);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        string2 = this.getVoiceId(new Voice(null, n, 65535, null), n3);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "";
    }
}

