/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkStyle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Text
extends Scrollable {
    int bufferHandle;
    int tabs = 8;
    int lastEventTime = 0;
    static final int INNER_BORDER = 2;
    static final int ITER_SIZEOF = 56;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    void createHandle(int index) {
        this.state |= 0x10800;
        int parentHandle = this.parent.parentingHandle();
        if ((this.style & 4) != 0) {
            this.handle = OS.gtk_entry_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)parentHandle, (int)this.handle);
            OS.gtk_editable_set_editable((int)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
            OS.gtk_entry_set_has_frame((int)this.handle, ((this.style & 0x800) != 0 ? 1 : 0) != 0);
            OS.gtk_entry_set_visibility((int)this.handle, ((this.style & 0x400000) == 0 ? 1 : 0) != 0);
        } else {
            this.fixedHandle = OS.gtk_fixed_new();
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
            this.scrolledHandle = OS.gtk_scrolled_window_new((int)0, (int)0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            this.handle = OS.gtk_text_view_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.bufferHandle = OS.gtk_text_view_get_buffer((int)this.handle);
            if (this.bufferHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
            OS.gtk_container_add((int)this.fixedHandle, (int)this.scrolledHandle);
            OS.gtk_container_add((int)this.scrolledHandle, (int)this.handle);
            OS.gtk_widget_show((int)this.fixedHandle);
            OS.gtk_widget_show((int)this.scrolledHandle);
            OS.gtk_text_view_set_editable((int)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
            if ((this.style & 0x40) != 0) {
                OS.gtk_text_view_set_wrap_mode((int)this.handle, (int)2);
            }
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy((int)this.scrolledHandle, (int)hsp, (int)vsp);
            if ((this.style & 0x800) != 0) {
                OS.gtk_scrolled_window_set_shadow_type((int)this.scrolledHandle, (int)3);
            }
            int just = 0;
            if ((this.style & 0x1000000) != 0) {
                just = 2;
            }
            if ((this.style & 0x20000) != 0) {
                just = 1;
            }
            OS.gtk_text_view_set_justification((int)this.handle, (int)just);
        }
        OS.gtk_widget_show((int)this.handle);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])new int[]{-1});
        } else {
            byte[] position = new byte[56];
            OS.gtk_text_buffer_get_end_iter((int)this.bufferHandle, (byte[])position);
            OS.gtk_text_buffer_insert((int)this.bufferHandle, (byte[])position, (byte[])buffer, (int)buffer.length);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])position);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int position = OS.gtk_editable_get_position((int)this.handle);
            OS.gtk_editable_select_region((int)this.handle, (int)position, (int)position);
        } else {
            byte[] position = new byte[56];
            int insertMark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)insertMark);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)selectionMark, (byte[])position);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)insertMark, (byte[])position);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int xborder = 0;
        int yborder = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        if ((this.style & 4) != 0) {
            int layout = OS.gtk_entry_get_layout((int)this.handle);
            OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
            if ((this.style & 0x800) != 0) {
                GtkStyle style = new GtkStyle();
                OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)this.handle));
                xborder += style.xthickness;
                yborder += style.ythickness;
            }
            xborder += 2;
            yborder += 2;
        } else {
            byte[] start = new byte[56];
            byte[] end = new byte[56];
            OS.gtk_text_buffer_get_bounds((int)this.bufferHandle, (byte[])start, (byte[])end);
            int text = OS.gtk_text_buffer_get_text((int)this.bufferHandle, (byte[])start, (byte[])end, (boolean)true);
            int layout = OS.gtk_widget_create_pango_layout((int)this.handle, (int)text);
            OS.g_free((int)text);
            OS.pango_layout_set_width((int)layout, (int)(wHint * 1024));
            OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
            OS.g_object_unref((int)layout);
            int borderWidth = OS.gtk_container_get_border_width((int)this.handle);
            xborder += borderWidth;
            yborder += borderWidth;
        }
        int[] property = new int[1];
        OS.gtk_widget_style_get((int)this.handle, (byte[])OS.interior_focus, (int[])property, (int)0);
        if (property[0] != 0) {
            OS.gtk_widget_style_get((int)this.handle, (byte[])OS.focus_line_width, (int[])property, (int)0);
            xborder += property[0];
            yborder += property[0];
        }
        int width = OS.PANGO_PIXELS((int)w[0]);
        int height = OS.PANGO_PIXELS((int)h[0]);
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrim(0, 0, width += 2 * xborder, height += 2 * yborder);
        return new Point(trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_copy_clipboard((int)this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get((int)0);
            OS.gtk_text_buffer_copy_clipboard((int)this.bufferHandle, (int)clipboard);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_cut_clipboard((int)this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get((int)0);
            OS.gtk_text_buffer_cut_clipboard((int)this.bufferHandle, (int)clipboard, (boolean)OS.gtk_text_view_get_editable((int)this.handle));
        }
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_TEXT_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_TEXT_FOREGROUND;
    }

    void deregister() {
        int imContext;
        super.deregister();
        if (this.bufferHandle != 0) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.removeWidget(imContext);
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        byte[] position = new byte[56];
        int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)mark);
        return OS.gtk_text_iter_get_line((byte[])position);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new Point(0, 0);
        }
        byte[] position = new byte[56];
        int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)mark);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_iter_location((int)this.handle, (byte[])position, (GdkRectangle)rect);
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_text_view_buffer_to_window_coords((int)this.handle, (int)2, (int)rect.x, (int)rect.y, (int[])x, (int[])y);
        return new Point(x[0], y[0]);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_position((int)this.handle);
        }
        byte[] position = new byte[56];
        int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)mark);
        return OS.gtk_text_iter_get_offset((byte[])position);
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.getText().length();
        }
        return OS.gtk_text_buffer_get_char_count((int)this.bufferHandle);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return true;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !OS.gtk_entry_get_visibility((int)this.handle)) {
            return OS.gtk_entry_get_invisible_char((int)this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable((int)this.handle);
        }
        return OS.gtk_text_view_get_editable((int)this.handle);
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return OS.gtk_text_buffer_get_line_count((int)this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds((int)this.handle, (int[])start, (int[])end);
            return new Point(start[0], end[0]);
        }
        byte[] start = new byte[56];
        byte[] end = new byte[56];
        OS.gtk_text_buffer_get_selection_bounds((int)this.bufferHandle, (byte[])start, (byte[])end);
        return new Point(OS.gtk_text_iter_get_offset((byte[])start), OS.gtk_text_iter_get_offset((byte[])end));
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return Math.abs(selection.y - selection.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        byte[] buffer = Converter.wcsToMbcs(null, " ", true);
        int layout = OS.gtk_widget_create_pango_layout((int)this.handle, (byte[])buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size((int)layout, (int[])width, (int[])height);
        OS.g_object_unref((int)layout);
        return width[0] * tabs;
    }

    public String getText() {
        int address;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            address = OS.gtk_entry_get_text((int)this.handle);
        } else {
            byte[] start = new byte[56];
            byte[] end = new byte[56];
            OS.gtk_text_buffer_get_bounds((int)this.bufferHandle, (byte[])start, (byte[])end);
            address = OS.gtk_text_buffer_get_text((int)this.bufferHandle, (byte[])start, (byte[])end, (boolean)true);
        }
        if (address == 0) {
            return "";
        }
        int length = OS.strlen((int)address);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)address, (int)length);
        if ((this.style & 2) != 0) {
            OS.g_free((int)address);
        }
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public String getText(int start, int end) {
        int address;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            address = OS.gtk_editable_get_chars((int)this.handle, (int)start, (int)(end + 1));
        } else {
            byte[] startIter = new byte[56];
            byte[] endIter = new byte[56];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])startIter, (int)start);
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])endIter, (int)(end + 1));
            address = OS.gtk_text_buffer_get_text((int)this.bufferHandle, (byte[])startIter, (byte[])endIter, (boolean)true);
        }
        if (address == 0) {
            return "";
        }
        int length = OS.strlen((int)address);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)address, (int)length);
        OS.g_free((int)address);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int limit = OS.gtk_entry_get_max_length((int)this.handle);
        return limit == 0 ? 65535 : limit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[56];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect((int)this.handle, (GdkRectangle)rect);
        OS.gtk_text_view_get_line_at_y((int)this.handle, (byte[])position, (int)rect.y, null);
        return OS.gtk_text_iter_get_line((byte[])position);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[56];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect((int)this.handle, (GdkRectangle)rect);
        int[] lineTop = new int[1];
        OS.gtk_text_view_get_line_at_y((int)this.handle, (byte[])position, (int)rect.y, (int[])lineTop);
        return lineTop[0];
    }

    int gtk_activate(int widget) {
        this.postEvent(14);
        return 0;
    }

    int gtk_changed(int widget) {
        this.sendEvent(24);
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if ((this.style & 4) != 0 && !OS.gtk_editable_get_editable((int)this.handle)) {
            return 0;
        }
        int length = OS.strlen((int)text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)text, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (int)text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (byte[])buffer);
        }
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        return 0;
    }

    int gtk_delete_range(int widget, int iter1, int iter2) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] startIter = new byte[56];
        byte[] endIter = new byte[56];
        OS.memmove((byte[])startIter, (int)iter1, (int)startIter.length);
        OS.memmove((byte[])endIter, (int)iter2, (int)endIter.length);
        int start = OS.gtk_text_iter_get_offset((byte[])startIter);
        int end = OS.gtk_text_iter_get_offset((byte[])endIter);
        String newText = this.verifyText("", start, end);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.delete_range);
        }
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String newText = this.verifyText("", start_pos, end_pos);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.delete_text);
        }
        return 0;
    }

    int gtk_insert_text(int widget, int int0, int int1, int int2) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if ((this.style & 4) != 0) {
            String newText;
            if (int0 == 0 || int1 == 0) {
                return 0;
            }
            byte[] buffer = new byte[int1];
            OS.memmove((byte[])buffer, (int)int0, (int)buffer.length);
            String oldText = new String(Converter.mbcsToWcs(null, buffer));
            int[] position = new int[1];
            OS.memmove((int[])position, (int)int2, (int)4);
            if (position[0] == -1) {
                position[0] = this.getCharCount();
            }
            if ((newText = this.verifyText(oldText, position[0], position[0])) == null) {
                OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.insert_text);
                return 0;
            }
            if (newText != oldText) {
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)18);
                OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer3, (int)buffer3.length, (int[])position);
                OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)18);
                OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.insert_text);
                return 0;
            }
        } else {
            byte[] iter = new byte[56];
            OS.memmove((byte[])iter, (int)int0, (int)iter.length);
            int start = OS.gtk_text_iter_get_offset((byte[])iter);
            byte[] buffer = new byte[int2];
            OS.memmove((byte[])buffer, (int)int1, (int)buffer.length);
            String oldText = new String(Converter.mbcsToWcs(null, buffer));
            String newText = this.verifyText(oldText, start, start);
            if (newText == null) {
                OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.insert_text);
                return 0;
            }
            if (newText != oldText) {
                byte[] buffer1 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)18);
                OS.gtk_text_buffer_insert((int)this.bufferHandle, (byte[])iter, (byte[])buffer1, (int)buffer1.length);
                OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)18);
                OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.insert_text);
                return 0;
            }
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        if (!this.hasFocus()) {
            return 0;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)gdkEvent, (int)event, (int)36);
        if (gdkEvent.time == this.lastEventTime) {
            return 0;
        }
        this.lastEventTime = gdkEvent.time;
        int imContext = this.imContext();
        if (imContext != 0 && OS.gtk_im_context_filter_keypress((int)imContext, (int)event)) {
            return 1;
        }
        return super.gtk_key_press_event(widget, event);
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        return this.showMenu(x[0], y[0]) ? 1 : 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        int windowProc4 = this.display.windowProc4;
        int windowProc5 = this.display.windowProc5;
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_after((int)this.handle, (byte[])OS.changed, (int)windowProc2, (int)4);
            OS.g_signal_connect((int)this.handle, (byte[])OS.insert_text, (int)windowProc5, (int)18);
            OS.g_signal_connect((int)this.handle, (byte[])OS.delete_text, (int)windowProc4, (int)10);
            OS.g_signal_connect((int)this.handle, (byte[])OS.activate, (int)windowProc2, (int)1);
        } else {
            OS.g_signal_connect((int)this.bufferHandle, (byte[])OS.changed, (int)windowProc2, (int)4);
            OS.g_signal_connect((int)this.bufferHandle, (byte[])OS.insert_text, (int)windowProc5, (int)18);
            OS.g_signal_connect((int)this.bufferHandle, (byte[])OS.delete_range, (int)windowProc4, (int)9);
        }
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect((int)imContext, (byte[])OS.commit, (int)windowProc3, (int)6);
            int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        }
    }

    int imContext() {
        return (this.style & 4) != 0 ? OS.GTK_ENTRY_IM_CONTEXT((int)this.handle) : OS.GTK_TEXTVIEW_IM_CONTEXT((int)this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds((int)this.handle, (int[])start, (int[])end);
            OS.gtk_editable_delete_selection((int)this.handle);
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])start);
        } else {
            byte[] start = new byte[56];
            byte[] end = new byte[56];
            if (OS.gtk_text_buffer_get_selection_bounds((int)this.bufferHandle, (byte[])start, (byte[])end)) {
                OS.gtk_text_buffer_delete((int)this.bufferHandle, (byte[])start, (byte[])end);
            }
            OS.gtk_text_buffer_insert((int)this.bufferHandle, (byte[])start, (byte[])buffer, (int)buffer.length);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])start);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    int paintWindow() {
        OS.gtk_widget_realize((int)this.handle);
        if ((this.style & 4) != 0) {
            return OS.GTK_WIDGET_WINDOW((int)this.handle);
        }
        return OS.gtk_text_view_get_window((int)this.handle, (int)2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_paste_clipboard((int)this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get((int)0);
            OS.gtk_text_buffer_paste_clipboard((int)this.bufferHandle, (int)clipboard, null, (boolean)OS.gtk_text_view_get_editable((int)this.handle));
        }
    }

    void register() {
        int imContext;
        super.register();
        if (this.bufferHandle != 0) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_select_region((int)this.handle, (int)0, (int)-1);
        } else {
            byte[] start = new byte[56];
            byte[] end = new byte[56];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])start, (int)0);
            OS.gtk_text_buffer_get_end_iter((int)this.bufferHandle, (byte[])end);
            int insertMark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)selectionMark, (byte[])start);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)insertMark, (byte[])end);
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_visibility((int)this.handle, (echo == '\u0000' ? 1 : 0) != 0);
            OS.gtk_entry_set_invisible_char((int)this.handle, (char)echo);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_editable((int)this.handle, (boolean)editable);
        } else {
            OS.gtk_text_view_set_editable((int)this.handle, (boolean)editable);
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        this.setTabStops(this.tabs);
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setSelection(int start) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_position((int)this.handle, (int)start);
        } else {
            byte[] position = new byte[56];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])position, (int)start);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])position);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_position((int)this.handle, (int)start);
            OS.gtk_editable_select_region((int)this.handle, (int)start, (int)end);
        } else {
            byte[] startIter = new byte[56];
            byte[] endIter = new byte[56];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])startIter, (int)start);
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])endIter, (int)end);
            int insertMark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)selectionMark, (byte[])startIter);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)insertMark, (byte[])endIter);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        if ((this.style & 4) != 0) {
            return;
        }
        int tabWidth = this.getTabWidth(tabs);
        int tabArray = OS.pango_tab_array_new((int)1, (boolean)false);
        OS.pango_tab_array_set_tab((int)tabArray, (int)0, (int)0, (int)tabWidth);
        OS.gtk_text_view_set_tabs((int)this.handle, (int)tabArray);
        OS.pango_tab_array_free((int)tabArray);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_delete_text((int)this.handle, (int)0, (int)-1);
            int[] position = new int[1];
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])position);
            OS.gtk_editable_set_position((int)this.handle, (int)0);
        } else {
            byte[] position = new byte[56];
            OS.gtk_text_buffer_set_text((int)this.bufferHandle, (byte[])buffer, (int)buffer.length);
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])position, (int)0);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])position);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_max_length((int)this.handle, (int)limit);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] position = new byte[56];
        OS.gtk_text_buffer_get_iter_at_line((int)this.bufferHandle, (byte[])position, (int)index);
        OS.gtk_text_view_scroll_to_iter((int)this.handle, (byte[])position, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int mark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string((int)imContext, (int[])preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen((int)preeditString[0]);
                OS.g_free((int)preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    int traversalCode(int key, GdkEventKey event) {
        int bits = super.traversalCode(key, event);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 65289 && event != null) {
                boolean next;
                boolean bl = next = (event.state & 1) == 0;
                if (next && (event.state & 4) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        this.sendEvent(25, event);
        if (!event.doit) {
            return null;
        }
        return event.text;
    }
}

