/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    int defaultCursor;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 0x800;
        this.handle = OS.gtk_drawing_area_new();
        if (this.handle == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.handle);
        OS.gtk_widget_show((int)this.handle);
        int type = (this.style & 0x200) != 0 ? 108 : 116;
        this.defaultCursor = OS.gdk_cursor_new((int)type);
        int window = OS.GTK_WIDGET_WINDOW((int)this.handle);
        if (window != 0) {
            OS.gdk_window_set_cursor((int)window, (int)this.defaultCursor);
        }
    }

    void drawBand(int x, int y, int width, int height) {
        int window = OS.GTK_WIDGET_WINDOW((int)this.parent.paintHandle());
        if (window == 0) {
            return;
        }
        byte[] bits = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int stipplePixmap = OS.gdk_bitmap_create_from_data((int)window, (byte[])bits, (int)8, (int)8);
        int gc = OS.gdk_gc_new((int)window);
        int colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white((int)colormap, (GdkColor)color);
        OS.gdk_gc_set_foreground((int)gc, (GdkColor)color);
        OS.gdk_gc_set_stipple((int)gc, (int)stipplePixmap);
        OS.gdk_gc_set_subwindow((int)gc, (int)1);
        OS.gdk_gc_set_fill((int)gc, (int)2);
        OS.gdk_gc_set_function((int)gc, (int)2);
        OS.gdk_draw_rectangle((int)window, (int)gc, (int)1, (int)x, (int)y, (int)width, (int)height);
        OS.g_object_unref((int)stipplePixmap);
        OS.g_object_unref((int)gc);
    }

    int gtk_button_press_event(int widget, int eventPtr) {
        int result = super.gtk_button_press_event(widget, eventPtr);
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)eventPtr, (int)64);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0;
        }
        this.startX = (int)gdkEvent.x;
        this.startY = (int)gdkEvent.y;
        int border = 0;
        int x = OS.GTK_WIDGET_X((int)this.handle);
        int y = OS.GTK_WIDGET_Y((int)this.handle);
        int width = OS.GTK_WIDGET_WIDTH((int)this.handle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.handle);
        this.lastX = x - border;
        this.lastY = y - border;
        Event event = new Event();
        event.detail = 1;
        event.time = gdkEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            this.drawBand(this.lastX, this.lastY, width, height);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int eventPtr) {
        int result = super.gtk_button_release_event(widget, eventPtr);
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)eventPtr, (int)64);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0;
        }
        if (!this.dragging) {
            return 0;
        }
        this.dragging = false;
        int width = OS.GTK_WIDGET_WIDTH((int)this.handle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.handle);
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.drawBand(this.lastX, this.lastY, width, height);
        this.sendEvent(13, event);
        return result;
    }

    int gtk_motion_notify_event(int widget, int eventPtr) {
        int result = super.gtk_motion_notify_event(widget, eventPtr);
        int[] state = new int[1];
        OS.gdk_event_get_state((int)eventPtr, (int[])state);
        if (!this.dragging || (state[0] & 0x100) == 0) {
            return 0;
        }
        int x = OS.GTK_WIDGET_X((int)this.handle);
        int y = OS.GTK_WIDGET_Y((int)this.handle);
        int width = OS.GTK_WIDGET_WIDTH((int)this.handle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.handle);
        int parentBorder = 0;
        int parentWidth = OS.GTK_WIDGET_WIDTH((int)this.parent.handle);
        int parentHeight = OS.GTK_WIDGET_HEIGHT((int)this.parent.handle);
        double[] px = new double[1];
        double[] py = new double[1];
        OS.gdk_event_get_coords((int)eventPtr, (double[])px, (double[])py);
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, (int)px[0] + x - this.startX - parentBorder), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, (int)py[0] + y - this.startY - parentBorder), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return 0;
        }
        this.drawBand(this.lastX, this.lastY, width, height);
        Event event = new Event();
        event.detail = 1;
        event.time = OS.gdk_event_get_time((int)eventPtr);
        event.x = newX;
        event.y = newY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.drawBand(this.lastX, this.lastY, width, height);
        }
        return result;
    }

    int gtk_realize(int widget) {
        int window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle());
        int gdkCursor = this.cursor != null && !this.cursor.isDisposed() ? this.cursor.handle : this.defaultCursor;
        OS.gdk_window_set_cursor((int)window, (int)gdkCursor);
        return 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0) {
            OS.gdk_cursor_destroy((int)this.defaultCursor);
        }
        this.defaultCursor = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        int gdkCursor = cursor != null ? cursor.handle : this.defaultCursor;
        int window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle());
        if (window != 0) {
            OS.gdk_window_set_cursor((int)window, (int)gdkCursor);
            OS.gdk_flush();
        }
    }
}

