/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames;
    String fullPath = "";
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        this.handle = OS.gtk_file_selection_new((byte[])titleBytes);
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)this.handle, (int)this.parent.topHandle());
        }
        String answer = null;
        this.preset();
        int response = OS.gtk_dialog_run((int)this.handle);
        if (response == -5) {
            int fileNamePtr = OS.gtk_file_selection_get_filename((int)this.handle);
            int utf8Ptr = OS.g_filename_to_utf8((int)fileNamePtr, (int)-1, null, null, null);
            int[] items_written = new int[1];
            int utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
            int length = items_written[0];
            char[] buffer = new char[length];
            OS.memmove((char[])buffer, (int)utf16Ptr, (int)(length * 2));
            String osAnswer = new String(buffer);
            OS.g_free((int)utf16Ptr);
            OS.g_free((int)utf8Ptr);
            answer = this.interpretOsAnswer(osAnswer);
        }
        OS.gtk_widget_destroy((int)this.handle);
        return answer;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    void preset() {
        OS.gtk_file_selection_set_select_multiple((int)this.handle, ((this.style & 2) != 0 ? 1 : 0) != 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filterPath == null) {
            this.filterPath = "";
        } else if (this.filterPath.length() > 0) {
            stringBuffer.append(this.filterPath);
            if (this.filterPath.charAt(this.filterPath.length() - 1) != SEPARATOR) {
                stringBuffer.append(SEPARATOR);
            }
        }
        if (this.fileName == null) {
            this.fileName = "";
        } else {
            stringBuffer.append(this.fileName);
        }
        this.fullPath = stringBuffer.toString();
        int length = this.fullPath.length();
        char[] buffer = new char[length + 1];
        this.fullPath.getChars(0, length, buffer, 0);
        int utf8Ptr = OS.g_utf16_to_utf8((char[])buffer, (int)-1, null, null, null);
        int fileNamePtr = OS.g_filename_from_utf8((int)utf8Ptr, (int)-1, null, null, null);
        OS.gtk_file_selection_set_filename((int)this.handle, (int)fileNamePtr);
        OS.g_free((int)utf8Ptr);
        OS.g_free((int)fileNamePtr);
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        if (this.filterExtensions.length == 1) {
            String ext = this.filterExtensions[0];
            byte[] extBytes = Converter.wcsToMbcs(null, ext, true);
            OS.gtk_file_selection_complete((int)this.handle, (byte[])extBytes);
        }
        this.fullPath = null;
    }

    String interpretOsAnswer(String osAnswer) {
        if (osAnswer == null) {
            return null;
        }
        int separatorIndex = osAnswer.lastIndexOf(SEPARATOR);
        if (separatorIndex + 1 == osAnswer.length()) {
            return null;
        }
        String answer = this.fullPath = osAnswer;
        this.fileName = this.fullPath.substring(separatorIndex + 1);
        this.filterPath = this.fullPath.substring(0, separatorIndex);
        if ((this.style & 2) == 0) {
            this.fileNames = new String[]{this.fileName};
        } else {
            int namesPtr;
            int namesPtr1 = namesPtr = OS.gtk_file_selection_get_selections((int)this.handle);
            int[] namePtr = new int[1];
            OS.memmove((int[])namePtr, (int)namesPtr1, (int)4);
            int length = 0;
            while (namePtr[0] != 0) {
                ++length;
                OS.memmove((int[])namePtr, (int)(namesPtr1 += 4), (int)4);
            }
            this.fileNames = new String[length];
            namePtr = new int[length];
            OS.memmove((int[])namePtr, (int)namesPtr, (int)(length * 4));
            int i = 0;
            while (i < length) {
                int utf8Ptr = OS.g_filename_to_utf8((int)namePtr[i], (int)-1, null, null, null);
                int[] items_written = new int[1];
                int utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
                char[] buffer = new char[items_written[0]];
                OS.memmove((char[])buffer, (int)utf16Ptr, (int)(items_written[0] * 2));
                String name = new String(buffer);
                this.fileNames[i] = name.substring(name.lastIndexOf(SEPARATOR) + 1);
                OS.g_free((int)utf16Ptr);
                OS.g_free((int)utf8Ptr);
                ++i;
            }
            OS.g_strfreev((int)namesPtr);
        }
        return answer;
    }
}

