/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public final class Font {
    public int handle;
    Device device;

    Font() {
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fd == null) {
            SWT.error(4);
        }
        this.init(device, fd.getName(), fd.getHeight(), fd.getStyle(), fd.string);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fds) {
        FontData fd;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        if ((fd = fds[0]) == null) {
            SWT.error(4);
        }
        this.init(device, fd.getName(), fd.getHeight(), fd.getStyle(), fd.string);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, name, height, style, null);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.pango_font_description_free((int)this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        return this.handle == ((Font)object).handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int family = OS.pango_font_description_get_family((int)this.handle);
        int length = OS.strlen((int)family);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)family, (int)length);
        String name = new String(Converter.mbcsToWcs(null, buffer));
        int height = OS.pango_font_description_get_size((int)this.handle) / 1024;
        int pangoStyle = OS.pango_font_description_get_style((int)this.handle);
        int pangoWeight = OS.pango_font_description_get_weight((int)this.handle);
        int style = 0;
        if (pangoStyle == 2) {
            style |= 2;
        }
        if (pangoStyle == 1) {
            style |= 0x20;
        }
        if (pangoWeight >= 700) {
            style |= 1;
        }
        int fontString = OS.pango_font_description_to_string((int)this.handle);
        length = OS.strlen((int)fontString);
        buffer = new byte[length + 1];
        OS.memmove((byte[])buffer, (int)fontString, (int)length);
        OS.g_free((int)fontString);
        FontData data = new FontData(name, height, style);
        data.string = buffer;
        return new FontData[]{data};
    }

    public static Font gtk_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.handle = handle;
        font.device = device;
        return font;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, String name, int height, int style, byte[] fontString) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
        this.device = device;
        if (fontString != null) {
            this.handle = OS.pango_font_description_from_string((byte[])fontString);
            if (this.handle == 0) {
                SWT.error(2);
            }
        } else {
            this.handle = OS.pango_font_description_new();
            if (this.handle == 0) {
                SWT.error(2);
            }
            byte[] buffer = Converter.wcsToMbcs(null, name, true);
            OS.pango_font_description_set_family((int)this.handle, (byte[])buffer);
            OS.pango_font_description_set_size((int)this.handle, (int)(height * 1024));
            OS.pango_font_description_set_stretch((int)this.handle, (int)4);
            int pangoStyle = 0;
            int pangoWeight = 400;
            if ((style & 2) != 0) {
                pangoStyle = 2;
            }
            if ((style & 0x20) != 0) {
                pangoStyle = 1;
            }
            if ((style & 1) != 0) {
                pangoWeight = 700;
            }
            OS.pango_font_description_set_style((int)this.handle, (int)pangoStyle);
            OS.pango_font_description_set_weight((int)this.handle, (int)pangoWeight);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

