/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    int logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device(DeviceData data) {
        if (data != null) {
            this.debug = data.debug;
            this.tracking = data.tracking;
        }
        if (this.tracking) {
            this.errors = new Error[128];
            this.objects = new Object[128];
        }
        this.create(data);
        this.init();
        this.systemFont = this.getSystemFont();
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == object) {
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        int count = 0;
        int length = 0;
        if (this.tracking) {
            length = this.objects.length;
        }
        int i = 0;
        while (i < length) {
            if (this.objects[i] != null) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        data.objects = new Object[count];
        data.errors = new Error[count];
        int i2 = 0;
        while (i2 < length) {
            if (this.objects[i2] != null) {
                data.objects[index] = this.objects[i2];
                data.errors[index] = this.errors[i2];
                ++index;
            }
            ++i2;
        }
        return data;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(72, 72);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        int[] family = new int[1];
        int[] face = new int[1];
        int[] families = new int[1];
        int[] n_families = new int[1];
        int[] faces = new int[1];
        int[] n_faces = new int[1];
        int context = OS.gdk_pango_context_get();
        OS.pango_context_list_families((int)context, (int[])families, (int[])n_families);
        int nFds = 0;
        FontData[] fds = new FontData[faceName != null ? 4 : n_families[0]];
        int i = 0;
        while (i < n_families[0]) {
            OS.memmove((int[])family, (int)(families[0] + i * 4), (int)4);
            OS.pango_font_family_list_faces((int)family[0], (int[])faces, (int[])n_faces);
            int j = 0;
            while (j < n_faces[0]) {
                OS.memmove((int[])face, (int)(faces[0] + j * 4), (int)4);
                int fontDesc = OS.pango_font_face_describe((int)face[0]);
                Font font = Font.gtk_new(this, fontDesc);
                FontData data = font.getFontData()[0];
                if (faceName == null || Compatibility.equalsIgnoreCase(faceName, data.name)) {
                    if (nFds == fds.length) {
                        FontData[] newFds = new FontData[fds.length + n_families[0]];
                        System.arraycopy(fds, 0, newFds, 0, nFds);
                        fds = newFds;
                    }
                    fds[nFds++] = data;
                }
                OS.pango_font_description_free((int)fontDesc);
                ++j;
            }
            OS.g_free((int)faces[0]);
            ++i;
        }
        OS.g_free((int)families[0]);
        OS.g_object_unref((int)context);
        if (nFds == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[nFds];
        System.arraycopy(fds, 0, result, 0, nFds);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    protected void init() {
        this.logCallback = new Callback(this, "logProc", 4);
        this.logProc = this.logCallback.getAddress();
        if (this.logProc == 0) {
            SWT.error(3);
        }
        if (this.debug) {
            int flags = -1;
            int i = 0;
            while (i < this.log_domains.length) {
                byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                this.handler_ids[i] = OS.g_log_set_handler((byte[])log_domain, (int)flags, (int)this.logProc, (int)0);
                ++i;
            }
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    int logProc(int log_domain, int log_level, int message, int user_data) {
        if (DEBUG || this.debug && this.warningLevel == 0) {
            new Error().printStackTrace();
            OS.g_log_default_handler((int)log_domain, (int)log_level, (int)message, (int)0);
        }
        return 0;
    }

    void new_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == null) {
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            ++i;
        }
        Object[] newObjects = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
        newObjects[this.objects.length] = object;
        this.objects = newObjects;
        Error[] newErrors = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = new Error();
        this.errors = newErrors;
    }

    protected void release() {
        if (this.gdkColors != null) {
            int colormap = OS.gdk_colormap_get_system();
            int i = 0;
            while (i < this.gdkColors.length) {
                GdkColor color = this.gdkColors[i];
                if (color != null) {
                    while (this.colorRefCount[i] > 0) {
                        OS.gdk_colormap_free_colors((int)colormap, (GdkColor)color, (int)1);
                        int n = i;
                        this.colorRefCount[n] = this.colorRefCount[n] - 1;
                    }
                }
                ++i;
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        int i = 0;
        while (i < this.handler_ids.length) {
            if (this.handler_ids[i] != 0) {
                byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                OS.g_log_remove_handler((byte[])log_domain, (int)this.handler_ids[i]);
                this.handler_ids[i] = 0;
            }
            ++i;
        }
        this.logCallback.dispose();
        this.logCallback = null;
        this.handler_ids = null;
        this.log_domains = null;
        this.logProc = 0;
    }

    public void setWarnings(boolean warnings) {
        block7: {
            block6: {
                this.checkDevice();
                if (!warnings) break block6;
                if (--this.warningLevel != 0) break block7;
                if (this.debug) {
                    return;
                }
                int i = 0;
                while (i < this.handler_ids.length) {
                    if (this.handler_ids[i] != 0) {
                        byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                        OS.g_log_remove_handler((byte[])log_domain, (int)this.handler_ids[i]);
                        this.handler_ids[i] = 0;
                    }
                    ++i;
                }
                break block7;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                int flags = -1;
                int i = 0;
                while (i < this.log_domains.length) {
                    byte[] log_domain = Converter.wcsToMbcs(null, this.log_domains[i], true);
                    this.handler_ids[i] = OS.g_log_set_handler((byte[])log_domain, (int)flags, (int)this.logProc, (int)0);
                    ++i;
                }
            }
        }
    }
}

