/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;
import org.eclipse.core.internal.boot.InternalBootLoader;
import org.eclipse.core.internal.boot.URLContentFilter;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;

public final class PluginClassLoader
extends DelegatingURLClassLoader {
    private PluginDescriptor descriptor;
    private volatile boolean pluginActivationInProgress = false;
    public static boolean usePackagePrefixes = true;

    public PluginClassLoader(URL[] codePath, URLContentFilter[] codeFilters, URL[] resourcePath, URLContentFilter[] resourceFilters, ClassLoader parent, PluginDescriptor descriptor) {
        super(codePath, codeFilters, resourcePath, resourceFilters, parent);
        this.descriptor = descriptor;
        this.base = descriptor.getInstallURL();
        this.prefixes = PluginClassLoader.initializePrefixes(descriptor, this.getPrefixId());
        this.debugConstruction();
    }

    public static String[] initializePrefixes(IPluginDescriptor descriptor, String prefixId) {
        if (InternalBootLoader.useClassLoaderProperties()) {
            String list = (String)((Hashtable)DelegatingURLClassLoader.prefixTable).get(prefixId);
            if (list == null) {
                return null;
            }
            if (list.trim().length() == 0) {
                if (DelegatingURLClassLoader.DEBUG_PROPERTIES) {
                    System.out.println("Clearing prefixes for: " + descriptor.getUniqueIdentifier());
                }
                return null;
            }
            if (DelegatingURLClassLoader.DEBUG_PROPERTIES) {
                System.out.println("Using prefixes for " + descriptor.getUniqueIdentifier() + " from classloader.properties: " + list);
            }
            return DelegatingURLClassLoader.getArrayFromList((String)list);
        }
        if (usePackagePrefixes) {
            if (DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES) {
                System.out.println("Reading package prefixes for plug-in: " + descriptor.getUniqueIdentifier());
            }
            HashSet<String> set = new HashSet<String>(5);
            ILibrary[] libraries = descriptor.getRuntimeLibraries();
            int i = 0;
            while (libraries != null && i < libraries.length) {
                String[] entries = libraries[i].getPackagePrefixes();
                int j = 0;
                while (entries != null && j < entries.length) {
                    set.add(entries[j]);
                    ++j;
                }
                ++i;
            }
            String[] prefixes = null;
            if (set.size() != 0) {
                prefixes = set.toArray(new String[set.size()]);
            }
            if (DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES) {
                String list = PluginClassLoader.arrayToString(prefixes);
                System.out.println("Using the following prefixes: " + list);
            }
            return prefixes;
        }
        return null;
    }

    static String arrayToString(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i]);
            if (i != array.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void activatePlugin(String name) {
        try {
            try {
                if (DelegatingURLClassLoader.DEBUG && DelegatingURLClassLoader.DEBUG_SHOW_ACTIVATE && this.debugLoader()) {
                    this.debug("Attempting to activate " + this.descriptor.getUniqueIdentifier());
                }
                this.descriptor.doPluginActivation();
            }
            catch (CoreException e) {
                if (!DelegatingURLClassLoader.DEBUG) throw new DelegatingURLClassLoader.DelegatingLoaderException(Policy.bind("plugin.delegatingLoaderTrouble", this.descriptor.getUniqueIdentifier(), name), (Exception)e);
                if (!DelegatingURLClassLoader.DEBUG_SHOW_ACTIVATE) throw new DelegatingURLClassLoader.DelegatingLoaderException(Policy.bind("plugin.delegatingLoaderTrouble", this.descriptor.getUniqueIdentifier(), name), (Exception)e);
                if (!this.debugLoader()) throw new DelegatingURLClassLoader.DelegatingLoaderException(Policy.bind("plugin.delegatingLoaderTrouble", this.descriptor.getUniqueIdentifier(), name), (Exception)e);
                this.debug("Activation failed for " + this.descriptor.getUniqueIdentifier());
                throw new DelegatingURLClassLoader.DelegatingLoaderException(Policy.bind("plugin.delegatingLoaderTrouble", this.descriptor.getUniqueIdentifier(), name), (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (DelegatingURLClassLoader.DEBUG && DelegatingURLClassLoader.DEBUG_SHOW_ACTIVATE && this.debugLoader()) {
                this.debug("Exit activation for " + this.descriptor.getUniqueIdentifier());
            }
            this.pluginActivationInProgress = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        if (DelegatingURLClassLoader.DEBUG && DelegatingURLClassLoader.DEBUG_SHOW_ACTIVATE && this.debugLoader()) {
            this.debug("Exit activation for " + this.descriptor.getUniqueIdentifier());
        }
        this.pluginActivationInProgress = false;
    }

    public String debugId() {
        return this.descriptor.toString();
    }

    protected Class internalFindClassParentsSelf(String name, boolean resolve, DelegatingURLClassLoader requestor, boolean checkParents) {
        Class result = null;
        PluginClassLoader pluginClassLoader = this;
        synchronized (pluginClassLoader) {
            result = ((ClassLoader)((Object)this)).findLoadedClass(name);
            if (!(result == null || (result = this.checkClassVisibility(result, requestor, true)) == null && checkParents)) {
                return result;
            }
            if (checkParents && (result = this.findClassParents(name, resolve)) != null) {
                return result;
            }
            if (this.pluginActivationInProgress || this.descriptor.hasActivationStarted()) {
                try {
                    result = super.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                return this.checkClassVisibility(result, requestor, false);
            }
            if (!this.shouldLookForClass(name)) {
                return null;
            }
            this.pluginActivationInProgress = true;
        }
        this.activatePlugin(name);
        pluginClassLoader = this;
        synchronized (pluginClassLoader) {
            result = ((ClassLoader)((Object)this)).findLoadedClass(name);
            if (result != null) {
                return this.checkClassVisibility(result, requestor, true);
            }
            try {
                result = super.findClass(name);
                if (result == null) {
                    return null;
                }
                return this.checkClassVisibility(result, requestor, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public String getPrefixId() {
        return this.descriptor.getUniqueIdentifier();
    }

    public void initializeImportedLoaders() {
        PluginDescriptor desc = this.getPluginDescriptor();
        IPluginPrerequisite[] prereqs = desc.getPluginResolvedPrerequisites();
        if (prereqs.length == 0) {
            return;
        }
        PluginRegistry registry = desc.getPluginRegistry();
        DelegatingURLClassLoader.DelegateLoader[] importedLoaders = new DelegatingURLClassLoader.DelegateLoader[prereqs.length];
        int i = 0;
        while (i < prereqs.length) {
            String prereqId = prereqs[i].getUniqueIdentifier();
            desc = (PluginDescriptor)registry.getPluginDescriptor(prereqId, prereqs[i].getResolvedVersionIdentifier());
            importedLoaders[i] = new DelegatingURLClassLoader.DelegateLoader((DelegatingURLClassLoader)desc.getPluginClassLoader(true), prereqs[i].isExported());
            ++i;
        }
        this.setImportedLoaders(importedLoaders);
    }

    public void setPluginDescriptor(PluginDescriptor value) {
        this.descriptor = value;
    }

    protected boolean shouldLookForClass(String name) {
        String resource = name.replace('.', '/');
        if (this.findClassResource(String.valueOf(resource) + ".class") == null) {
            return false;
        }
        if (this.descriptor.isPluginDeactivated()) {
            String message = Policy.bind("plugin.deactivatedLoad", name, this.descriptor.getUniqueIdentifier());
            throw new DelegatingURLClassLoader.DelegatingLoaderException(message);
        }
        return true;
    }

    protected String getClassloaderId() {
        return this.descriptor.getId();
    }
}

