/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Searcher;

public final class Similarity {
    static final float[] NORM_TABLE = new float[256];

    private Similarity() {
    }

    public static float normalizeLength(int n) {
        return (float)(1.0 / Math.sqrt(n));
    }

    public static float decodeNorm(byte by) {
        return NORM_TABLE[by & 0xFF];
    }

    public static byte encodeNorm(float f) {
        return Similarity.floatToByte(f);
    }

    private static float byteToFloat(byte by) {
        if (by == 0) {
            return 0.0f;
        }
        int n = by & 7;
        int n2 = by >> 3 & 0x1F;
        int n3 = n2 + 48 << 24 | n << 21;
        return Float.intBitsToFloat(n3);
    }

    private static byte floatToByte(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f == 0.0f) {
            return 0;
        }
        int n = Float.floatToIntBits(f);
        int n2 = (n & 0xFFFFFF) >> 21;
        int n3 = (n >> 24 & 0x7F) - 63 + 15;
        if (n3 > 31) {
            n3 = 31;
            n2 = 7;
        }
        if (n3 < 1) {
            n3 = 1;
            n2 = 0;
        }
        return (byte)(n3 << 3 | n2);
    }

    static final float tf(int n) {
        return (float)Math.sqrt(n);
    }

    static final float tf(float f) {
        return (float)Math.sqrt(f);
    }

    static final float idf(Term term, Searcher searcher) throws IOException {
        return Similarity.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    static final float idf(int n, int n2) {
        return (float)(Math.log((double)n2 / (double)(n + 1)) + 1.0);
    }

    static final float coord(int n, int n2) {
        return (float)n / (float)n2;
    }

    static {
        int n = 0;
        while (n < 256) {
            Similarity.NORM_TABLE[n] = Similarity.byteToFloat((byte)n);
            ++n;
        }
    }
}

