/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

final class BooleanScorer
extends Scorer {
    private int currentDoc;
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable(this);
    private int maxCoord = 1;
    private float[] coordFactors = null;
    private int requiredMask = 0;
    private int prohibitedMask = 0;
    private int nextMask = 1;

    BooleanScorer() {
    }

    final void add(Scorer scorer, boolean bl, boolean bl2) {
        int n = 0;
        if (bl || bl2) {
            if (this.nextMask == 0) {
                throw new IndexOutOfBoundsException("More than 32 required/prohibited clauses in query.");
            }
            n = this.nextMask;
            this.nextMask <<= 1;
        } else {
            n = 0;
        }
        if (!bl2) {
            ++this.maxCoord;
        }
        if (bl2) {
            this.prohibitedMask |= n;
        } else if (bl) {
            this.requiredMask |= n;
        }
        this.scorers = new SubScorer(scorer, bl, bl2, this.bucketTable.newCollector(n), this.scorers);
    }

    private final void computeCoordFactors() throws IOException {
        this.coordFactors = new float[this.maxCoord];
        int n = 0;
        while (n < this.maxCoord) {
            this.coordFactors[n] = Similarity.coord(n, this.maxCoord);
            ++n;
        }
    }

    final void score(HitCollector hitCollector, int n) throws IOException {
        if (this.coordFactors == null) {
            this.computeCoordFactors();
        }
        while (this.currentDoc < n) {
            this.currentDoc = Math.min(this.currentDoc + 1024, n);
            SubScorer subScorer = this.scorers;
            while (subScorer != null) {
                subScorer.scorer.score(subScorer.collector, this.currentDoc);
                subScorer = subScorer.next;
            }
            this.bucketTable.collectHits(hitCollector);
        }
    }

    static final class Collector
    extends HitCollector {
        private BucketTable bucketTable;
        private int mask;

        public Collector(int n, BucketTable bucketTable) {
            this.mask = n;
            this.bucketTable = bucketTable;
        }

        public final void collect(int n, float f) {
            BucketTable bucketTable = this.bucketTable;
            int n2 = n & 0x3FF;
            Bucket bucket = bucketTable.buckets[n2];
            if (bucket == null) {
                bucketTable.buckets[n2] = bucket = new Bucket();
            }
            if (bucket.doc != n) {
                bucket.doc = n;
                bucket.score = f;
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = bucketTable.first;
                bucketTable.first = bucket;
            } else {
                bucket.score += f;
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }
    }

    static final class BucketTable {
        public static final int SIZE = 1024;
        public static final int MASK = 1023;
        final Bucket[] buckets = new Bucket[1024];
        Bucket first = null;
        private BooleanScorer scorer;

        public BucketTable(BooleanScorer booleanScorer) {
            this.scorer = booleanScorer;
        }

        public final void collectHits(HitCollector hitCollector) {
            int n = this.scorer.requiredMask;
            int n2 = this.scorer.prohibitedMask;
            float[] fArray = this.scorer.coordFactors;
            Bucket bucket = this.first;
            while (bucket != null) {
                if ((bucket.bits & n2) == 0 && (bucket.bits & n) == n) {
                    hitCollector.collect(bucket.doc, bucket.score * fArray[bucket.coord]);
                }
                bucket = bucket.next;
            }
            this.first = null;
        }

        public final int size() {
            return 1024;
        }

        public HitCollector newCollector(int n) {
            return new Collector(n, this);
        }
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean required = false;
        public boolean prohibited = false;
        public HitCollector collector;
        public SubScorer next;

        public SubScorer(Scorer scorer, boolean bl, boolean bl2, HitCollector hitCollector, SubScorer subScorer) {
            this.scorer = scorer;
            this.required = bl;
            this.prohibited = bl2;
            this.collector = hitCollector;
            this.next = subScorer;
        }
    }
}

