/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;

public class BooleanQuery
extends Query {
    private Vector clauses = new Vector();

    public void add(Query query, boolean bl, boolean bl2) {
        this.clauses.addElement(new BooleanClause(query, bl, bl2));
    }

    public void add(BooleanClause booleanClause) {
        this.clauses.addElement(booleanClause);
    }

    void prepare(IndexReader indexReader) {
        int n = 0;
        while (n < this.clauses.size()) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(n);
            booleanClause.query.prepare(indexReader);
            ++n;
        }
    }

    float sumOfSquaredWeights(Searcher searcher) throws IOException {
        float f = 0.0f;
        int n = 0;
        while (n < this.clauses.size()) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(n);
            if (!booleanClause.prohibited) {
                f += booleanClause.query.sumOfSquaredWeights(searcher);
            }
            ++n;
        }
        return f;
    }

    void normalize(float f) {
        int n = 0;
        while (n < this.clauses.size()) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(n);
            if (!booleanClause.prohibited) {
                booleanClause.query.normalize(f);
            }
            ++n;
        }
    }

    Scorer scorer(IndexReader indexReader) throws IOException {
        Object object;
        if (this.clauses.size() == 1) {
            object = (BooleanClause)this.clauses.elementAt(0);
            if (!((BooleanClause)object).prohibited) {
                return ((BooleanClause)object).query.scorer(indexReader);
            }
        }
        object = new BooleanScorer();
        int n = 0;
        while (n < this.clauses.size()) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(n);
            Scorer scorer = booleanClause.query.scorer(indexReader);
            if (scorer != null) {
                ((BooleanScorer)object).add(scorer, booleanClause.required, booleanClause.prohibited);
            } else if (booleanClause.required) {
                return null;
            }
            ++n;
        }
        return object;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.clauses.size()) {
            BooleanClause booleanClause = (BooleanClause)this.clauses.elementAt(n);
            if (booleanClause.prohibited) {
                stringBuffer.append("-");
            } else if (booleanClause.required) {
                stringBuffer.append("+");
            }
            Query query = booleanClause.query;
            if (query instanceof BooleanQuery) {
                BooleanQuery booleanQuery = (BooleanQuery)query;
                stringBuffer.append("(");
                stringBuffer.append(booleanClause.query.toString(string));
                stringBuffer.append(")");
            } else {
                stringBuffer.append(booleanClause.query.toString(string));
            }
            if (n != this.clauses.size() - 1) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

