/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianStemmer;

public final class RussianStemFilter
extends TokenFilter {
    private Token token = null;
    private RussianStemmer stemmer = null;

    public RussianStemFilter(TokenStream tokenStream, char[] cArray) {
        this.stemmer = new RussianStemmer(cArray);
        this.input = tokenStream;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        String string = this.stemmer.stem(this.token.termText());
        if (!string.equals(this.token.termText())) {
            return new Token(string, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(RussianStemmer russianStemmer) {
        if (russianStemmer != null) {
            this.stemmer = russianStemmer;
        }
    }
}

