/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

public class GermanStemmer {
    private StringBuffer sb = new StringBuffer();
    private boolean uppercase = false;
    private int substCount = 0;

    protected String stem(String string) {
        this.uppercase = Character.isUpperCase(string.charAt(0));
        if (!this.isStemmable(string = string.toLowerCase())) {
            return string;
        }
        this.sb.delete(0, this.sb.length());
        this.sb.insert(0, string);
        this.substitute(this.sb);
        this.strip(this.sb);
        this.optimize(this.sb);
        this.resubstitute(this.sb);
        this.removeParticleDenotion(this.sb);
        return this.sb.toString();
    }

    private boolean isStemmable(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isLetter(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void strip(StringBuffer stringBuffer) {
        boolean bl = true;
        while (bl && stringBuffer.length() > 3) {
            if (stringBuffer.length() + this.substCount > 5 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals("nd")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                continue;
            }
            if (stringBuffer.length() + this.substCount > 4 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals("em")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                continue;
            }
            if (stringBuffer.length() + this.substCount > 4 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals("er")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 'e') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 's') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 'n') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 't' && !this.uppercase) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            bl = false;
        }
    }

    private void optimize(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 5 && stringBuffer.substring(stringBuffer.length() - 5, stringBuffer.length()).equals("erin*")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            this.strip(stringBuffer);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == 'z') {
            stringBuffer.setCharAt(stringBuffer.length() - 1, 'x');
        }
    }

    private void removeParticleDenotion(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 4) {
            int n = 0;
            while (n < stringBuffer.length() - 3) {
                if (stringBuffer.substring(n, n + 4).equals("gege")) {
                    stringBuffer.delete(n, n + 2);
                    return;
                }
                ++n;
            }
        }
    }

    private void substitute(StringBuffer stringBuffer) {
        this.substCount = 0;
        int n = 0;
        while (n < stringBuffer.length()) {
            if (n > 0 && stringBuffer.charAt(n) == stringBuffer.charAt(n - 1)) {
                stringBuffer.setCharAt(n, '*');
            } else if (stringBuffer.charAt(n) == '\u00e4') {
                stringBuffer.setCharAt(n, 'a');
            } else if (stringBuffer.charAt(n) == '\u00f6') {
                stringBuffer.setCharAt(n, 'o');
            } else if (stringBuffer.charAt(n) == '\u00fc') {
                stringBuffer.setCharAt(n, 'u');
            }
            if (n < stringBuffer.length() - 1) {
                if (stringBuffer.charAt(n) == '\u00df') {
                    stringBuffer.setCharAt(n, 's');
                    stringBuffer.insert(n + 1, 's');
                    ++this.substCount;
                } else if (n < stringBuffer.length() - 2 && stringBuffer.charAt(n) == 's' && stringBuffer.charAt(n + 1) == 'c' && stringBuffer.charAt(n + 2) == 'h') {
                    stringBuffer.setCharAt(n, '$');
                    stringBuffer.delete(n + 1, n + 3);
                    this.substCount = 2;
                } else if (stringBuffer.charAt(n) == 'c' && stringBuffer.charAt(n + 1) == 'h') {
                    stringBuffer.setCharAt(n, '\u00a7');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 'e' && stringBuffer.charAt(n + 1) == 'i') {
                    stringBuffer.setCharAt(n, '%');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 'i' && stringBuffer.charAt(n + 1) == 'e') {
                    stringBuffer.setCharAt(n, '&');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 'i' && stringBuffer.charAt(n + 1) == 'g') {
                    stringBuffer.setCharAt(n, '#');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                } else if (stringBuffer.charAt(n) == 's' && stringBuffer.charAt(n + 1) == 't') {
                    stringBuffer.setCharAt(n, '!');
                    stringBuffer.deleteCharAt(n + 1);
                    ++this.substCount;
                }
            }
            ++n;
        }
    }

    private void resubstitute(StringBuffer stringBuffer) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '*') {
                char c = stringBuffer.charAt(n - 1);
                stringBuffer.setCharAt(n, c);
            } else if (stringBuffer.charAt(n) == '$') {
                stringBuffer.setCharAt(n, 's');
                stringBuffer.insert(n + 1, new char[]{'c', 'h'}, 0, 2);
            } else if (stringBuffer.charAt(n) == '\u00a7') {
                stringBuffer.setCharAt(n, 'c');
                stringBuffer.insert(n + 1, 'h');
            } else if (stringBuffer.charAt(n) == '%') {
                stringBuffer.setCharAt(n, 'e');
                stringBuffer.insert(n + 1, 'i');
            } else if (stringBuffer.charAt(n) == '&') {
                stringBuffer.setCharAt(n, 'i');
                stringBuffer.insert(n + 1, 'e');
            } else if (stringBuffer.charAt(n) == '#') {
                stringBuffer.setCharAt(n, 'i');
                stringBuffer.insert(n + 1, 'g');
            } else if (stringBuffer.charAt(n) == '!') {
                stringBuffer.setCharAt(n, 's');
                stringBuffer.insert(n + 1, 't');
            }
            ++n;
        }
    }
}

