/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XCrossingEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XFontStruct;
import org.eclipse.swt.internal.motif.XInputEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.internal.motif.XWindowChanges;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    Composite parent;
    Font font;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createWidget(int index) {
        int topHandle;
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.setParentTraversal();
        if (!this.hasIMSupport()) {
            OS.XmImRegister(this.handle, 0);
        }
        if (OS.XtIsRealized(topHandle = this.topHandle())) {
            int display;
            int window = OS.XtWindow(topHandle);
            if (window != 0 && (display = OS.XtDisplay(topHandle)) != 0) {
                OS.XLowerWindow(display, window);
            }
            this.realizeChildren();
        }
        Display display = this.getDisplay();
        OS.XtOverrideTranslations(this.handle, display.dragTranslations);
        this.font = this.defaultFont();
    }

    int defaultBackground() {
        return this.getDisplay().defaultBackground;
    }

    Font defaultFont() {
        return this.getDisplay().defaultFont;
    }

    int defaultForeground() {
        return this.getDisplay().defaultForeground;
    }

    void enableWidget(boolean enabled) {
        this.enableHandle(enabled, this.handle);
    }

    char findMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    void fixFocus() {
        Shell shell = this.getShell();
        Control control = this;
        while ((control = control.parent) != null) {
            if (!control.setFocus() && control != shell) continue;
            return;
        }
    }

    int fontHandle() {
        return this.handle;
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        shell.bringToTop(false);
        return this.XmProcessTraversal(this.handle, 0);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.motif_new(this.getDisplay(), this.getXColor(this.getBackgroundPixel()));
    }

    int getBackgroundPixel() {
        int[] argList = new int[]{OS.XmNbackground, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getBorderWidth() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] argList = new int[]{OS.XmNborderWidth, 0};
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        return argList[1];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] argList = new int[]{OS.XmNx, 0, OS.XmNy, 0, OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        int borders = argList[9] * 2;
        return new Rectangle((short)argList[1], (short)argList[3], argList[5] + borders, argList[7] + borders);
    }

    Point getClientLocation() {
        short[] handle_x = new short[1];
        short[] handle_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, handle_x, handle_y);
        short[] topHandle_x = new short[1];
        short[] topHandle_y = new short[1];
        OS.XtTranslateCoords(this.parent.handle, (short)0, (short)0, topHandle_x, topHandle_y);
        return new Point(handle_x[0] - topHandle_x[0], handle_y[0] - topHandle_y[0]);
    }

    String getCodePage() {
        return this.font.codePage;
    }

    public Display getDisplay() {
        Composite parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNsensitive, 0};
        OS.XtGetValues(this.topHandle(), argList, argList.length / 2);
        return argList[1] != 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font;
    }

    /*
     * WARNING - void declaration
     */
    int getFontAscent() {
        int fontListEntry;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, this.font.handle)) {
            this.error(2);
        }
        int context = buffer[0];
        int ascent = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            void var5_7;
            int fontPtr = OS.XmFontListEntryGetFont((int)var5_7, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int fontAscent = Math.max(fontStruct.ascent, fontStruct.max_bounds_ascent);
                if (fontAscent <= ascent) continue;
                ascent = fontAscent;
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                int fontAscent = Math.max(fontStruct.ascent, fontStruct.max_bounds_ascent);
                if (fontAscent > ascent) {
                    ascent = fontAscent;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return ascent;
    }

    /*
     * WARNING - void declaration
     */
    int getFontHeight() {
        int fontListEntry;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, this.font.handle)) {
            this.error(2);
        }
        int context = buffer[0];
        int height = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            void var5_7;
            int fontPtr = OS.XmFontListEntryGetFont((int)var5_7, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int fontAscent = Math.max(fontStruct.ascent, fontStruct.max_bounds_ascent);
                int fontDescent = Math.max(fontStruct.descent, fontStruct.max_bounds_descent);
                int fontHeight = fontAscent + fontDescent;
                if (fontHeight <= height) continue;
                height = fontHeight;
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                int fontAscent = Math.max(fontStruct.ascent, fontStruct.max_bounds_ascent);
                int fontDescent = Math.max(fontStruct.descent, fontStruct.max_bounds_descent);
                int fontHeight = fontAscent + fontDescent;
                if (fontHeight > height) {
                    height = fontHeight;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return height;
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.motif_new(this.getDisplay(), this.getXColor(this.getForegroundPixel()));
    }

    int getForegroundPixel() {
        int[] argList = new int[]{OS.XmNforeground, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    short[] getIMCaretPos() {
        return new short[]{0, 0};
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] argList = new int[]{OS.XmNx, 0, OS.XmNy, 0};
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        return new Point((short)argList[1], (short)argList[3]);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getNavigationType() {
        int[] argList = new int[]{OS.XmNnavigationType, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        int borders = argList[5] * 2;
        return new Point(argList[1] + borders, argList[3] + borders);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] argList = new int[]{OS.XmNmappedWhenManaged, 0};
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    XColor getXColor(int pixel) {
        int display = OS.XtDisplay(this.handle);
        if (display == 0) {
            return null;
        }
        int[] argList = new int[]{OS.XmNcolormap, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int colormap = argList[1];
        if (colormap == 0) {
            return null;
        }
        XColor color = new XColor();
        color.pixel = pixel;
        OS.XQueryColor(display, colormap, color);
        return color;
    }

    boolean hasFocus() {
        return this == this.getDisplay().getFocusControl();
    }

    boolean hasIMSupport() {
        return false;
    }

    void hookEvents() {
        int windowProc = this.getDisplay().windowProc;
        OS.XtAddEventHandler(this.handle, 1, false, windowProc, 6);
        OS.XtAddEventHandler(this.handle, 2, false, windowProc, 7);
        OS.XtAddEventHandler(this.handle, 4, false, windowProc, 1);
        OS.XtAddEventHandler(this.handle, 8, false, windowProc, 2);
        OS.XtAddEventHandler(this.handle, 64, false, windowProc, 27);
        OS.XtAddEventHandler(this.handle, 16, false, windowProc, 4);
        OS.XtAddEventHandler(this.handle, 32, false, windowProc, 8);
        OS.XtInsertEventHandler(this.handle, 32768, false, windowProc, 3, 1);
        OS.XtInsertEventHandler(this.handle, 0x200000, false, windowProc, 5, 1);
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, windowProc, 17);
    }

    int hoverProc(int id) {
        return this.hoverProc(id, true);
    }

    int hoverProc(int id, boolean showTip) {
        Display display = this.getDisplay();
        if (showTip) {
            display.showToolTip(this.handle, this.toolTipText);
        }
        this.sendMouseEvent(32, 0);
        return 0;
    }

    public int internal_new_GC(GCData data) {
        int xGC;
        int xWindow;
        int xDisplay;
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            Shell shell = this.getShell();
            shell.realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            SWT.error(2);
        }
        if ((xWindow = OS.XtWindow(this.handle)) == 0) {
            SWT.error(2);
        }
        if ((xGC = OS.XCreateGC(xDisplay, xWindow, 0, null)) == 0) {
            SWT.error(2);
        }
        OS.XSetGraphicsExposures(xDisplay, xGC, false);
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0, OS.XmNcolormap, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (data != null) {
            data.device = this.getDisplay();
            data.display = xDisplay;
            data.drawable = xWindow;
            data.foreground = argList[1];
            data.background = argList[3];
            data.fontList = this.font.handle;
            data.codePage = this.font.codePage;
            data.colormap = argList[5];
        }
        return xGC;
    }

    public void internal_dispose_GC(int xGC, GCData data) {
        this.checkWidget();
        int xDisplay = 0;
        if (data != null) {
            xDisplay = data.display;
        }
        if (xDisplay == 0 && this.handle != 0) {
            xDisplay = OS.XtDisplay(this.handle);
        }
        if (xDisplay == 0) {
            SWT.error(2);
        }
        OS.XFreeGC(xDisplay, xGC);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor() {
        Display display = this.getDisplay();
        Control control = display.getFocusControl();
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 1 || size.y == 1) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void manageChildren() {
        OS.XtSetMappedWhenManaged(this.handle, false);
        int topHandle = this.topHandle();
        int[] argList1 = new int[]{OS.XmNtraversalOn, 0};
        OS.XtGetValues(topHandle, argList1, argList1.length / 2);
        if (argList1[1] != 0) {
            int[] argList2 = new int[]{OS.XmNtraversalOn, 0};
            OS.XtSetValues(topHandle, argList2, argList2.length / 2);
        }
        OS.XtManageChild(this.handle);
        if (argList1[1] != 0) {
            OS.XtSetValues(topHandle, argList1, argList1.length / 2);
        }
        this.overrideTranslations();
        int[] argList3 = new int[]{OS.XmNborderWidth, 0};
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        OS.XtResizeWidget(this.handle, 1, 1, argList3[1]);
        OS.XtSetMappedWhenManaged(this.handle, true);
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    void overrideTranslations() {
        Display display = this.getDisplay();
        OS.XtOverrideTranslations(this.handle, display.tabTranslations);
        OS.XtOverrideTranslations(this.handle, display.arrowTranslations);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    void propagateChildren(boolean enabled) {
        this.propagateWidget(enabled);
    }

    void propagateWidget(boolean enabled) {
        this.propagateHandle(enabled, this.handle);
    }

    void realizeChildren() {
        if (!this.isEnabled()) {
            this.propagateWidget(false);
        }
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(0, 0, 0, 0, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        this.redrawWidget(x, y, width, height, all);
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        this.redrawHandle(x, y, width, height, this.handle);
    }

    void releaseWidget() {
        int fontList = this.defaultFont().handle;
        if (this.font.handle != fontList) {
            int fontHandle = this.fontHandle();
            int[] argList2 = new int[]{OS.XmNfontList, fontList};
            OS.XtSetValues(fontHandle, argList2, argList2.length / 2);
        }
        super.releaseWidget();
        Display display = this.getDisplay();
        display.releaseToolTipHandle(this.handle);
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (!this.hasIMSupport()) {
            OS.XmImUnregister(this.handle);
        }
        this.parent = null;
        this.layoutData = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    void sendHelpEvent(int callData) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return;
            }
            control = control.parent;
        }
    }

    byte[] sendIMKeyEvent(int type, XKeyEvent xEvent) {
        byte[] buffer = new byte[512];
        int[] status = new int[1];
        int[] unused = new int[1];
        int length = OS.XmImMbLookupString(this.handle, xEvent, buffer, buffer.length, unused, status);
        if (status[0] == -1) {
            buffer = new byte[length];
            length = OS.XmImMbLookupString(this.handle, xEvent, buffer, length, unused, status);
        }
        if (length == 0) {
            return null;
        }
        char[] result = Converter.mbcsToWcs(null, buffer);
        int index = 0;
        while (index < result.length) {
            if (result[index] == '\u0000') break;
            Event event = new Event();
            event.time = xEvent.time;
            event.character = result[index];
            this.setInputState(event, xEvent);
            this.postEvent(type, event);
            ++index;
        }
        return buffer;
    }

    void sendKeyEvent(int type, XKeyEvent xEvent) {
        Event event = new Event();
        event.time = xEvent.time;
        this.setKeyState(event, xEvent);
        Control control = this;
        if ((this.state & 0x1000) != 0 && (this.style & 0x80000) != 0) {
            Display display = this.getDisplay();
            control = display.getFocusControl();
        }
        if (control != null) {
            control.postEvent(type, event);
        }
    }

    void sendMouseEvent(int type, int button) {
        int xDisplay = OS.XtDisplay(this.handle);
        int xWindow = OS.XtWindow(this.handle);
        int[] windowX = new int[1];
        int[] windowY = new int[1];
        int[] mask = new int[1];
        int[] unused = new int[1];
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, unused, unused, windowX, windowY, mask);
        Event event = new Event();
        event.x = windowX[0];
        event.y = windowY[0];
        this.setInputState(event, mask[0]);
        this.postEvent(type, event);
    }

    void sendMouseEvent(int type, int button, XCrossingEvent xEvent) {
        Event event = new Event();
        event.time = xEvent.time;
        event.button = button;
        event.x = xEvent.x;
        event.y = xEvent.y;
        int[] unused = new int[1];
        int[] mask = new int[1];
        OS.XQueryPointer(xEvent.display, xEvent.window, unused, unused, unused, unused, unused, unused, mask);
        this.setInputState(event, mask[0]);
        this.postEvent(type, event);
    }

    void sendMouseEvent(int type, int button, XInputEvent xEvent) {
        Event event = new Event();
        event.time = xEvent.time;
        event.button = button;
        event.x = xEvent.x;
        event.y = xEvent.y;
        this.setInputState(event, xEvent);
        this.postEvent(type, event);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            this.setBackgroundPixel(this.defaultBackground());
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            this.setBackgroundPixel(color.handle.pixel);
        }
    }

    void setBackgroundPixel(int pixel) {
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNhighlightColor, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmChangeColor(this.handle, pixel);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int topHandle = this.topHandle();
        if (move && resize) {
            boolean sameExtent;
            int[] argList = new int[]{OS.XmNx, 0, OS.XmNy, 0, OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
            OS.XtGetValues(topHandle, argList, argList.length / 2);
            width = Math.max(width - argList[9] * 2, 1);
            height = Math.max(height - argList[9] * 2, 1);
            boolean sameOrigin = x == (short)argList[1] && y == (short)argList[3];
            boolean bl = sameExtent = width == argList[5] && height == argList[7];
            if (sameOrigin && sameExtent) {
                return false;
            }
            OS.XtConfigureWidget(topHandle, x, y, width, height, argList[9]);
            if (!sameOrigin) {
                this.sendEvent(10);
            }
            if (!sameExtent) {
                this.sendEvent(11);
            }
            return true;
        }
        if (move) {
            int[] argList = new int[]{OS.XmNx, 0, OS.XmNy, 0};
            OS.XtGetValues(topHandle, argList, argList.length / 2);
            if (x == (short)argList[1] && y == (short)argList[3]) {
                return false;
            }
            OS.XtMoveWidget(topHandle, x, y);
            this.sendEvent(10);
            return true;
        }
        if (resize) {
            int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
            OS.XtGetValues(topHandle, argList, argList.length / 2);
            width = Math.max(width - argList[5] * 2, 1);
            height = Math.max(height - argList[5] * 2, 1);
            if (width == argList[1] && height == argList[3]) {
                return false;
            }
            OS.XtResizeWidget(topHandle, width, height, argList[5]);
            this.sendEvent(11);
            return true;
        }
        return false;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, width, height, true, true);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height, true, true);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
        int display = OS.XtDisplay(this.handle);
        if (display == 0) {
            return;
        }
        if (capture) {
            int window = OS.XtWindow(this.handle);
            if (window == 0) {
                return;
            }
            OS.XGrabPointer(display, window, 0, 76, 1, 1, 0, 0, 0);
        } else {
            OS.XUngrabPointer(display, 0);
        }
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        int display = OS.XtDisplay(this.handle);
        if (display == 0) {
            return;
        }
        int window = OS.XtWindow(this.handle);
        if (window == 0) {
            if (!OS.XtIsRealized(this.handle)) {
                this.getShell().realizeWidget();
            }
            if ((window = OS.XtWindow(this.handle)) == 0) {
                return;
            }
        }
        if (cursor == null) {
            OS.XUndefineCursor(display, window);
        } else {
            if (cursor.isDisposed()) {
                SWT.error(5);
            }
            int xCursor = cursor.handle;
            OS.XDefineCursor(display, window, xCursor);
            OS.XFlush(display);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        boolean fixFocus = false;
        if (!enabled) {
            fixFocus = this.isFocusAncestor();
        }
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus();
        }
        if (!enabled || this.isEnabled() && enabled) {
            this.propagateChildren(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        shell.bringToTop(false);
        return this.XmProcessTraversal(this.handle, 0);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        int[] argList1 = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int fontHandle = this.fontHandle();
        int[] argList2 = new int[]{OS.XmNfontList, font.handle};
        OS.XtSetValues(fontHandle, argList2, argList2.length / 2);
        if (!this.hasIMSupport()) {
            OS.XmImSetValues(this.handle, argList2, argList2.length / 2);
        }
        OS.XtSetValues(this.handle, argList1, argList1.length / 2);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            this.setForegroundPixel(this.defaultForeground());
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            this.setForegroundPixel(color.handle.pixel);
        }
    }

    void setForegroundPixel(int pixel) {
        int[] argList = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        OS.XClearArea(xDisplay, xWindow, 0, 0, 0, 0, true);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    void setParentTraversal() {
        if ((this.parent.style & 0x80000) != 0) {
            int parentHandle = this.parent.handle;
            int[] argList = new int[]{OS.XmNtraversalOn, 0};
            OS.XtGetValues(parentHandle, argList, argList.length / 2);
            if (argList[1] == 0) {
                argList[1] = 1;
                OS.XtSetValues(parentHandle, argList, argList.length / 2);
                this.parent.overrideTranslations();
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.setFocus();
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, width, height, false, true);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, size.x, size.y, false, true);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Display display = this.getDisplay();
        this.toolTipText = string;
        display.setToolTipText(this.handle, this.toolTipText);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] argList = new int[]{OS.XmNmappedWhenManaged, 0};
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        if (argList[1] != 0 == visible) {
            return;
        }
        boolean fixFocus = false;
        if (!visible) {
            fixFocus = this.isFocusAncestor();
        }
        OS.XtSetMappedWhenManaged(topHandle, visible);
        if (fixFocus) {
            this.fixFocus();
        }
        this.sendEvent(visible ? 22 : 23);
    }

    void setZOrder(Control control, boolean above) {
        this.setZOrder(control, above, true);
    }

    void setZOrder(Control control, boolean above, boolean fixChildren) {
        int window2;
        int window1;
        int topHandle1 = this.topHandle();
        int display = OS.XtDisplay(topHandle1);
        if (display == 0) {
            return;
        }
        if (!OS.XtIsRealized(topHandle1)) {
            Shell shell = this.getShell();
            shell.realizeWidget();
        }
        if ((window1 = OS.XtWindow(topHandle1)) == 0) {
            return;
        }
        if (control == null) {
            if (above) {
                OS.XRaiseWindow(display, window1);
                if (fixChildren) {
                    this.parent.moveAbove(topHandle1, 0);
                }
            } else {
                OS.XLowerWindow(display, window1);
                if (fixChildren) {
                    this.parent.moveBelow(topHandle1, 0);
                }
            }
            return;
        }
        int topHandle2 = control.topHandle();
        if (display != OS.XtDisplay(topHandle2)) {
            return;
        }
        if (!OS.XtIsRealized(topHandle2)) {
            Shell shell = control.getShell();
            shell.realizeWidget();
        }
        if ((window2 = OS.XtWindow(topHandle2)) == 0) {
            return;
        }
        XWindowChanges struct = new XWindowChanges();
        struct.sibling = window2;
        struct.stack_mode = above ? 0 : 1;
        int screen = OS.XDefaultScreen(display);
        int flags = 96;
        OS.XReconfigureWMWindow(display, window1, screen, flags, struct);
        if (above) {
            if (fixChildren) {
                this.parent.moveAbove(topHandle1, topHandle2);
            }
        } else if (fixChildren) {
            this.parent.moveBelow(topHandle1, topHandle2);
        }
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, root_x, root_y);
        return new Point(x - root_x[0], y - root_y[0]);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)x, (short)y, root_x, root_y);
        return new Point(root_x[0], root_y[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateAccelerator(int key, int keysym, XKeyEvent xEvent) {
        return this.menuShell().translateAccelerator(key, keysym, xEvent);
    }

    boolean translateMnemonic(char key, XKeyEvent xEvent) {
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        Event event = new Event();
        event.doit = this.mnemonicMatch(key);
        event.detail = 128;
        event.time = xEvent.time;
        this.setKeyState(event, xEvent);
        return this.traverse(event);
    }

    boolean translateMnemonic(int key, XKeyEvent xEvent) {
        int code;
        if (xEvent.state == 0 ? ((code = this.traversalCode(key, xEvent)) & 0x80) == 0 : xEvent.state != 8) {
            return false;
        }
        Decorations shell = this.menuShell();
        if (shell.isVisible() && shell.isEnabled()) {
            char ch = this.mbcsToWcs(key);
            return ch >= ' ' && shell.translateMnemonic(ch, xEvent);
        }
        return false;
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        int detail = 0;
        int code = this.traversalCode(key, xEvent);
        boolean all = false;
        switch (key) {
            case 65307: 
            case 65385: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65289: {
                boolean next = (xEvent.state & 1) == 0;
                switch (xEvent.state) {
                    case 1: 
                    case 4: {
                        code |= 0x18;
                    }
                }
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next = key == 65364 || key == 65363;
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((xEvent.state & 4) == 0) {
                    return false;
                }
                code |= 0x300;
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = xEvent.time;
        this.setKeyState(event, xEvent);
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        int[] argList = new int[]{OS.XmNtraversalOn, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 0) {
            return 0;
        }
        int code = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        if (this.getNavigationType() == 0) {
            code |= 0x60;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        if (!this.isFocusControl() && !this.setFocus()) {
            return false;
        }
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus() || this.isDisposed() || this.isFocusControl()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (all) {
            Display display = this.getDisplay();
            display.update();
        } else {
            int display = OS.XtDisplay(this.handle);
            if (display == 0) {
                return;
            }
            int window = OS.XtWindow(this.handle);
            if (window == 0) {
                return;
            }
            XAnyEvent event = new XAnyEvent();
            OS.XSync(display, false);
            OS.XSync(display, false);
            while (OS.XCheckWindowEvent(display, window, 32768, event)) {
                OS.XtDispatchEvent(event);
            }
        }
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        Display display = this.getDisplay();
        Shell shell = this.getShell();
        display.hideToolTip();
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 96);
        this.sendMouseEvent(3, xEvent.button, xEvent);
        if (xEvent.button == 2 && this.hooks(29)) {
            this.postEvent(29);
        }
        if (xEvent.button == 3 && this.menu != null) {
            this.setFocus();
            display.runDeferredEvents();
            this.menu.setVisible(true);
        }
        int clickTime = display.getDoubleClickTime();
        int lastTime = display.lastTime;
        int eventTime = xEvent.time;
        int lastButton = display.lastButton;
        int eventButton = xEvent.button;
        if (lastButton == eventButton && lastTime != 0 && Math.abs(lastTime - eventTime) <= clickTime) {
            this.sendMouseEvent(8, eventButton, xEvent);
        }
        display.lastTime = eventTime == 0 ? 1 : eventTime;
        display.lastButton = eventButton;
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return 0;
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        Display display = this.getDisplay();
        display.hideToolTip();
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 96);
        this.sendMouseEvent(4, xEvent.button, xEvent);
        return 0;
    }

    int XEnterWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        XCrossingEvent xEvent = new XCrossingEvent();
        OS.memmove(xEvent, call_data, 96);
        if (xEvent.mode != 0) {
            return 0;
        }
        if (xEvent.subwindow != 0) {
            return 0;
        }
        this.sendMouseEvent(6, 0, xEvent);
        return 0;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        XExposeEvent xEvent = new XExposeEvent();
        OS.memmove(xEvent, call_data, 96);
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return 0;
        }
        Event event = new Event();
        event.count = xEvent.count;
        event.x = xEvent.x;
        event.y = xEvent.y;
        event.width = xEvent.width;
        event.height = xEvent.height;
        GC gc = event.gc = new GC(this);
        gc.setClipping(event.x, event.y, event.width, event.height);
        this.sendEvent(9, event);
        if (!gc.isDisposed()) {
            gc.dispose();
        }
        event.gc = null;
        return 0;
    }

    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        int widget;
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 96);
        if (xEvent.mode != 0) {
            return 0;
        }
        if (xEvent.detail != 0 && xEvent.detail != 2 && xEvent.detail != 3) {
            return 0;
        }
        int xDisplay = xEvent.display;
        if (xDisplay == 0) {
            return 0;
        }
        int[] unused = new int[1];
        int[] xWindow = new int[1];
        OS.XGetInputFocus(xDisplay, xWindow, unused);
        if (xWindow[0] != 0 && (widget = OS.XtWindowToWidget(xDisplay, xWindow[0])) != 0 && OS.XtClass(widget) == OS.XmMenuShellWidgetClass()) {
            return 0;
        }
        switch (xEvent.type) {
            case 9: {
                Shell shell = this.getShell();
                this.xFocusIn();
                if (shell.isDisposed()) break;
                shell.setActiveControl(this);
                break;
            }
            case 10: {
                Control control;
                Shell shell = this.getShell();
                Display display = this.getDisplay();
                this.xFocusOut();
                if (shell.isDisposed() || (control = display.getFocusControl()) != null && shell == control.getShell()) break;
                shell.setActiveControl(null);
                break;
            }
        }
        return 0;
    }

    int xFocusIn() {
        this.sendEvent(15);
        if (this.handle == 0) {
            return 0;
        }
        if (!this.hasIMSupport() && (this.hooks(1) || this.hooks(2))) {
            short[] point = this.getIMCaretPos();
            int ptr = OS.XtMalloc(4);
            OS.memmove(ptr, point, 4);
            int[] argList = new int[]{OS.XmNspotLocation, ptr, OS.XmNfontList, this.font.handle};
            OS.XmImSetValues(this.handle, argList, argList.length / 2);
            OS.XmImSetFocusValues(this.handle, null, 0);
            if (ptr != 0) {
                OS.XtFree(ptr);
            }
        }
        return 0;
    }

    int xFocusOut() {
        Display display = this.getDisplay();
        if (display.postFocusOut) {
            this.postEvent(16);
        } else {
            this.sendEvent(16);
            if (this.handle == 0) {
                return 0;
            }
        }
        if (!this.hasIMSupport() && (this.hooks(1) || this.hooks(2))) {
            OS.XmImUnsetFocus(this.handle);
        }
        return 0;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 96);
        if (xEvent.keycode != 0) {
            this.sendKeyEvent(1, xEvent);
        } else {
            this.sendIMKeyEvent(1, xEvent);
        }
        return 0;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 96);
        if (this.menu != null && xEvent.state == 1) {
            byte[] buffer = new byte[1];
            int[] keysym = new int[1];
            OS.XLookupString(xEvent, buffer, buffer.length, keysym, null);
            if (keysym[0] == 65479) {
                this.menu.setVisible(true);
                return 0;
            }
        }
        this.sendKeyEvent(2, xEvent);
        return 0;
    }

    int XLeaveWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        Display display = this.getDisplay();
        display.removeMouseHoverTimeOut();
        display.hideToolTip();
        XCrossingEvent xEvent = new XCrossingEvent();
        OS.memmove(xEvent, call_data, 96);
        if (xEvent.mode != 0) {
            return 0;
        }
        if (xEvent.subwindow != 0) {
            return 0;
        }
        this.sendMouseEvent(7, 0, xEvent);
        return 0;
    }

    int XmNhelpCallback(int w, int client_data, int call_data) {
        this.sendHelpEvent(call_data);
        return 0;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        Display display = this.getDisplay();
        display.addMouseHoverTimeOut(this.handle);
        XMotionEvent xEvent = new XMotionEvent();
        OS.memmove(xEvent, call_data, 96);
        this.sendMouseEvent(5, 0, xEvent);
        return 0;
    }
}

