/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Composite
extends Scrollable {
    Layout layout;
    int damagedRegion;
    Control[] tabList;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        int[] argList = new int[]{OS.XmNchildren, 0, OS.XmNnumChildren, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return new Control[0];
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        Control[] children = new Control[count];
        int i = 0;
        int j = 0;
        while (i < count) {
            Widget widget;
            int handle = handles[i];
            if (handle != 0 && (widget = WidgetTable.get(handle)) != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            ++i;
        }
        if (i == j) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    protected void checkSubclass() {
    }

    void createHandle(int index) {
        this.state |= 0x1800;
        int parentHandle = this.parent.handle;
        if ((this.style & 0x300) == 0) {
            int border = (this.style & 0x800) != 0 ? 1 : 0;
            int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNborderWidth, border, OS.XmNmarginWidth, 0, OS.XmNmarginHeight, 0, OS.XmNresizePolicy, 0, OS.XmNtraversalOn, (this.style & 0x80000) != 0 ? 0 : 1};
            this.handle = OS.XmCreateDrawingArea(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.createScrolledHandle(parentHandle);
        }
    }

    void createScrolledHandle(int topHandle) {
        int[] argList = new int[]{OS.XmNancestorSensitive, 1};
        this.scrolledHandle = OS.XmCreateMainWindow(topHandle, null, argList, argList.length / 2);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        if ((this.style & 0x300) != 0) {
            Display display = this.getDisplay();
            int thickness = display.buttonShadowThickness;
            int[] argList1 = new int[]{OS.XmNmarginWidth, 3, OS.XmNmarginHeight, 3, OS.XmNresizePolicy, 0, OS.XmNshadowType, 7, OS.XmNshadowThickness, thickness};
            this.formHandle = OS.XmCreateForm(this.scrolledHandle, null, argList1, argList1.length / 2);
            if (this.formHandle == 0) {
                this.error(2);
            }
            int[] argList2 = new int[]{OS.XmNtopAttachment, 1, OS.XmNbottomAttachment, 1, OS.XmNleftAttachment, 1, OS.XmNrightAttachment, 1, OS.XmNresizable, 0, OS.XmNmarginWidth, 0, OS.XmNmarginHeight, 0, OS.XmNresizePolicy, 0};
            this.handle = OS.XmCreateDrawingArea(this.formHandle, null, argList2, argList2.length / 2);
        } else {
            int[] argList3 = new int[]{OS.XmNmarginWidth, 0, OS.XmNmarginHeight, 0, OS.XmNresizePolicy, 0, OS.XmNtraversalOn, (this.style & 0x80000) != 0 ? 0 : 1};
            this.handle = OS.XmCreateDrawingArea(this.scrolledHandle, null, argList3, argList3.length / 2);
        }
        if (this.handle == 0) {
            this.error(2);
        }
    }

    int defaultBackground() {
        return this.getDisplay().compositeBackground;
    }

    int defaultForeground() {
        return this.getDisplay().compositeForeground;
    }

    public boolean forceFocus() {
        this.checkWidget();
        Display display = this.getDisplay();
        boolean oldFocusOut = display.postFocusOut;
        Control[] children = this._getChildren();
        int[] traversals = new int[children.length];
        int[] argList = new int[]{OS.XmNtraversalOn, 0};
        int i = 0;
        while (i < children.length) {
            int childHandle = children[i].topHandle();
            OS.XtGetValues(childHandle, argList, argList.length / 2);
            traversals[i] = argList[1];
            if (traversals[i] != 0) {
                argList[1] = 0;
                display.postFocusOut = true;
                OS.XtSetValues(childHandle, argList, argList.length / 2);
            }
            ++i;
        }
        boolean result = super.forceFocus();
        int i2 = 0;
        while (i2 < children.length) {
            argList[1] = traversals[i2];
            Control control = children[i2];
            if (!control.isDisposed()) {
                int childHandle = control.topHandle();
                OS.XtSetValues(childHandle, argList, argList.length / 2);
                if (argList[1] != 0) {
                    control.overrideTranslations();
                }
            }
            ++i2;
        }
        display.postFocusOut = oldFocusOut;
        if (!display.postFocusOut) {
            display.runFocusOutEvents();
        }
        return result;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int[] argList = new int[]{OS.XmNnumChildren, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 0x1000) != 0) {
            int windowProc = this.getDisplay().windowProc;
            OS.XtInsertEventHandler(this.handle, 0, true, windowProc, 26, 1);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        int count = this.getChildrenCount();
        if (count == 0) {
            return;
        }
        this.layout.layout(this, changed);
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void moveAbove(int handle1, int handle2) {
        if (handle1 == handle2) {
            return;
        }
        int[] argList = new int[]{OS.XmNchildren, 0, OS.XmNnumChildren, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return;
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        if (handle2 == 0) {
            handle2 = handles[0];
        }
        int i = 0;
        int index1 = -1;
        int index2 = -1;
        while (i < count) {
            int handle = handles[i];
            if (handle == handle1) {
                index1 = i;
            }
            if (handle == handle2) {
                index2 = i;
            }
            if (index1 != -1 && index2 != -1) break;
            ++i;
        }
        if (index1 == -1 || index2 == -1) {
            return;
        }
        if (index1 == index2) {
            return;
        }
        if (index1 < index2) {
            System.arraycopy(handles, index1 + 1, handles, index1, index2 - index1 - 1);
            handles[index2 - 1] = handle1;
        } else {
            System.arraycopy(handles, index2, handles, index2 + 1, index1 - index2);
            handles[index2] = handle1;
        }
        OS.memmove(ptr, handles, count * 4);
    }

    void moveBelow(int handle1, int handle2) {
        if (handle1 == handle2) {
            return;
        }
        int[] argList = new int[]{OS.XmNchildren, 0, OS.XmNnumChildren, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return;
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        if (handle2 == 0) {
            handle2 = handles[count - 1];
        }
        int i = 0;
        int index1 = -1;
        int index2 = -1;
        while (i < count) {
            int handle = handles[i];
            if (handle == handle1) {
                index1 = i;
            }
            if (handle == handle2) {
                index2 = i;
            }
            if (index1 != -1 && index2 != -1) break;
            ++i;
        }
        if (index1 == -1 || index2 == -1) {
            return;
        }
        if (index1 == index2) {
            return;
        }
        if (index1 < index2) {
            System.arraycopy(handles, index1 + 1, handles, index1, index2 - index1);
            handles[index2] = handle1;
        } else {
            System.arraycopy(handles, index2 + 1, handles, index2 + 2, index1 - index2 - 1);
            handles[index2 + 1] = handle1;
        }
        OS.memmove(ptr, handles, count * 4);
    }

    void propagateChildren(boolean enabled) {
        super.propagateChildren(enabled);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getEnabled()) {
                child.propagateChildren(enabled);
            }
            ++i;
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].realizeChildren();
            ++i;
        }
        if ((this.state & 0x1000) != 0) {
            if ((this.style & 0x40000) == 0 && (this.style & 0x100000) != 0) {
                return;
            }
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            int flags = 0;
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            if ((this.style & 0x40000) != 0) {
                flags |= 1;
                attributes.background_pixmap = 0;
            }
            if ((this.style & 0x100000) == 0) {
                flags |= 0x10;
                attributes.bit_gravity = 0;
            }
            if (flags != 0) {
                OS.XChangeWindowAttributes(xDisplay, xWindow, flags, attributes);
            }
        }
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        super.redrawWidget(x, y, width, height, all);
        if (!all) {
            return;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Point location = child.getClientLocation();
            child.redrawWidget(x - location.x, y - location.y, width, height, all);
            ++i;
        }
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (!child.isDisposed()) {
                child.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseChildren();
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
        if (this.damagedRegion != 0) {
            OS.XDestroyRegion(this.damagedRegion);
        }
        this.damagedRegion = 0;
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        if ((this.state & 0x1000) != 0 && (this.style & 0x40000) != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            attributes.background_pixmap = 0;
            OS.XChangeWindowAttributes(xDisplay, xWindow, 1, attributes);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize && this.layout != null) {
            this.layout.layout(this, false);
        }
        return changed;
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.setFocus()) {
                return true;
            }
            ++i;
        }
        return this.forceFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    boolean setTabGroupFocus() {
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        if ((this.style & 0x80000) == 0) {
            boolean takeFocus = true;
            if ((this.state & 0x1000) != 0) {
                takeFocus = this.hooksKeys();
            }
            if (takeFocus && this.setTabItemFocus()) {
                return true;
            }
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean setTabItemFocus() {
        if ((this.style & 0x80000) == 0) {
            boolean takeFocus = true;
            if ((this.state & 0x1000) != 0) {
                takeFocus = this.hooksKeys();
            }
            if (takeFocus) {
                if (!this.isShowing()) {
                    return false;
                }
                if (this.forceFocus()) {
                    return true;
                }
            }
        }
        return super.setTabItemFocus();
    }

    void setScrollbarVisible(int barHandle, boolean visible) {
        Display display = this.getDisplay();
        boolean oldFocusOut = display.postFocusOut;
        Control[] children = this._getChildren();
        int[] traversals = new int[children.length];
        int[] argList = new int[]{OS.XmNtraversalOn, 0};
        int i = 0;
        while (i < children.length) {
            int childHandle = children[i].topHandle();
            OS.XtGetValues(childHandle, argList, argList.length / 2);
            traversals[i] = argList[1];
            if (traversals[i] != 0 && !children[i].hasFocus()) {
                argList[1] = 0;
                display.postFocusOut = true;
                OS.XtSetValues(children[i].handle, argList, argList.length / 2);
            }
            ++i;
        }
        super.setScrollbarVisible(barHandle, visible);
        int i2 = 0;
        while (i2 < children.length) {
            argList[1] = traversals[i2];
            Control control = children[i2];
            if (!control.isDisposed()) {
                int childHandle = control.topHandle();
                OS.XtSetValues(childHandle, argList, argList.length / 2);
                if (argList[1] != 0) {
                    control.overrideTranslations();
                }
            }
            ++i2;
        }
        display.postFocusOut = oldFocusOut;
        if (!display.postFocusOut) {
            display.runFocusOutEvents();
        }
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        if ((this.state & 0x1000) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, xEvent);
    }

    boolean translateMnemonic(char key, XKeyEvent xEvent) {
        if (super.translateMnemonic(key, xEvent)) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.translateMnemonic(key, xEvent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        if ((this.state & 0x1000) == 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        if ((this.style & 0x200000) != 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        XExposeEvent xEvent = new XExposeEvent();
        OS.memmove(xEvent, call_data, 96);
        int exposeCount = xEvent.count;
        if (exposeCount == 0 && OS.XEventsQueued(xEvent.display, 1) != 0) {
            XAnyEvent xAnyEvent = new XAnyEvent();
            Display display = this.getDisplay();
            display.lastExpose = 0;
            display.exposeCount = 0;
            int checkExposeProc = display.checkExposeProc;
            OS.XCheckIfEvent(xEvent.display, xAnyEvent, checkExposeProc, xEvent.window);
            exposeCount = display.exposeCount;
            int lastExpose = display.lastExpose;
            if (exposeCount != 0 && lastExpose != 0) {
                XExposeEvent xExposeEvent = display.xExposeEvent;
                OS.memmove(xExposeEvent, lastExpose, 96);
                xExposeEvent.count = 0;
                OS.memmove(lastExpose, xExposeEvent, 96);
            }
        }
        if (exposeCount == 0 && this.damagedRegion == 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        if (this.damagedRegion == 0) {
            this.damagedRegion = OS.XCreateRegion();
        }
        OS.XtAddExposureToRegion(call_data, this.damagedRegion);
        if (exposeCount != 0) {
            return 0;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return 0;
        }
        Event event = new Event();
        GC gc = event.gc = new GC(this);
        Region region = Region.motif_new(this.damagedRegion);
        gc.setClipping(region);
        XRectangle rect = new XRectangle();
        OS.XClipBox(this.damagedRegion, rect);
        event.x = rect.x;
        event.y = rect.y;
        event.width = rect.width;
        event.height = rect.height;
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        OS.XDestroyRegion(this.damagedRegion);
        this.damagedRegion = 0;
        return 0;
    }

    int XNonMaskable(int w, int client_data, int call_data, int continue_to_dispatch) {
        if ((this.state & 0x1000) != 0) {
            XExposeEvent xEvent = new XExposeEvent();
            OS.memmove(xEvent, call_data, 96);
            if (xEvent.type == 13) {
                return this.XExposure(w, client_data, call_data, continue_to_dispatch);
            }
        }
        return 0;
    }
}

