/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RowLayout
extends Layout {
    public int type = 256;
    public boolean wrap = true;
    public boolean pack = true;
    public boolean justify = false;
    public int spacing = 3;
    public int marginLeft = 3;
    public int marginTop = 3;
    public int marginRight = 3;
    public int marginBottom = 3;

    public RowLayout() {
    }

    public RowLayout(int type) {
        this.type = type;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point extent = this.type == 256 ? this.layoutHorizontal(composite, false, wHint != -1 && this.wrap, wHint, flushCache) : this.layoutVertical(composite, false, hHint != -1 && this.wrap, hHint, flushCache);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        return extent;
    }

    Point getSize(Control control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        RowData data = (RowData)control.getLayoutData();
        if (data != null) {
            wHint = data.width;
            hHint = data.height;
        }
        return control.computeSize(wHint, hHint, flushCache);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        if (this.type == 256) {
            this.layoutHorizontal(composite, true, this.wrap, clientArea.width, flushCache);
        } else {
            this.layoutVertical(composite, true, this.wrap, clientArea.height, flushCache);
        }
    }

    Point layoutHorizontal(Composite composite, boolean move, boolean wrap, int width, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = children.length;
        int childWidth = 0;
        int childHeight = 0;
        int maxHeight = 0;
        if (!this.pack) {
            int i = 0;
            while (i < count) {
                Control child = children[i];
                Point pt = this.getSize(child, flushCache);
                childWidth = Math.max(childWidth, pt.x);
                childHeight = Math.max(childHeight, pt.y);
                ++i;
            }
            maxHeight = childHeight;
        }
        int clientX = 0;
        int clientY = 0;
        if (move) {
            Rectangle rect = composite.getClientArea();
            clientX = rect.x;
            clientY = rect.y;
        }
        boolean wrapped = false;
        Rectangle[] bounds = null;
        if (move && this.justify) {
            bounds = new Rectangle[count];
        }
        int maxX = 0;
        int x = this.marginLeft;
        int y = this.marginTop;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            if (this.pack) {
                Point pt = this.getSize(child, flushCache);
                childWidth = pt.x;
                childHeight = pt.y;
            }
            if (wrap && i != 0 && x + childWidth > width) {
                wrapped = true;
                x = this.marginLeft;
                y += this.spacing + maxHeight;
            }
            if (this.pack) {
                maxHeight = Math.max(maxHeight, childHeight);
            }
            if (move) {
                int childX = x + clientX;
                int childY = y + clientY;
                if (this.justify) {
                    bounds[i] = new Rectangle(childX, childY, childWidth, childHeight);
                } else {
                    child.setBounds(childX, childY, childWidth, childHeight);
                }
            }
            maxX = Math.max(maxX, x += this.spacing + childWidth);
            ++i;
        }
        if (!wrap) {
            maxX = x + this.marginRight;
        }
        if (move && this.justify) {
            int space = 0;
            int margin = 0;
            if (!wrapped) {
                space = Math.max(0, (width - maxX) / (count + 1));
                margin = Math.max(0, (width - maxX) % (count + 1) / 2);
            }
            int i2 = 0;
            while (i2 < count) {
                Control child = children[i2];
                bounds[i2].x += space * (i2 + 1) + margin;
                child.setBounds(bounds[i2]);
                ++i2;
            }
        }
        return new Point(maxX, y + maxHeight + this.marginBottom);
    }

    Point layoutVertical(Composite composite, boolean move, boolean wrap, int height, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = children.length;
        int childWidth = 0;
        int childHeight = 0;
        int maxWidth = 0;
        if (!this.pack) {
            int i = 0;
            while (i < count) {
                Control child = children[i];
                Point pt = this.getSize(child, flushCache);
                childWidth = Math.max(childWidth, pt.x);
                childHeight = Math.max(childHeight, pt.y);
                ++i;
            }
            maxWidth = childWidth;
        }
        int clientX = 0;
        int clientY = 0;
        if (move) {
            Rectangle rect = composite.getClientArea();
            clientX = rect.x;
            clientY = rect.y;
        }
        boolean wrapped = false;
        Rectangle[] bounds = null;
        if (move && this.justify) {
            bounds = new Rectangle[count];
        }
        int maxY = 0;
        int x = this.marginLeft;
        int y = this.marginTop;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            if (this.pack) {
                Point pt = this.getSize(child, flushCache);
                childWidth = pt.x;
                childHeight = pt.y;
            }
            if (wrap && i != 0 && y + childHeight > height) {
                wrapped = true;
                x += this.spacing + maxWidth;
                y = this.marginTop;
            }
            if (this.pack) {
                maxWidth = Math.max(maxWidth, childWidth);
            }
            if (move) {
                int childX = x + clientX;
                int childY = y + clientY;
                if (this.justify) {
                    bounds[i] = new Rectangle(childX, childY, childWidth, childHeight);
                } else {
                    child.setBounds(childX, childY, childWidth, childHeight);
                }
            }
            maxY = Math.max(maxY, y += this.spacing + childHeight);
            ++i;
        }
        if (!wrap) {
            maxY = y + this.marginBottom;
        }
        if (move && this.justify) {
            int space = 0;
            int margin = 0;
            if (!wrapped) {
                space = Math.max(0, (height - maxY) / (count + 1));
                margin = Math.max(0, (height - maxY) % (count + 1) / 2);
            }
            int i2 = 0;
            while (i2 < count) {
                Control child = children[i2];
                bounds[i2].y += space * (i2 + 1) + margin;
                child.setBounds(bounds[i2]);
                ++i2;
            }
        }
        return new Point(x + maxWidth + this.marginRight, maxY);
    }
}

