/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.PngDecodingDataStream;
import org.eclipse.swt.internal.image.PngHuffmanTables;

public class PngLzBlockReader {
    boolean readHeader;
    boolean isLastBlock;
    byte compressionType;
    int uncompressedBytesRemaining;
    PngDecodingDataStream stream;
    PngHuffmanTables huffmanTables;
    byte[] window;
    int windowIndex;
    int copyIndex;
    int copyBytesRemaining;
    static final int UNCOMPRESSED = 0;
    static final int COMPRESSED_FIXED = 1;
    static final int COMPRESSED_DYNAMIC = 2;
    static final int END_OF_COMPRESSED_BLOCK = 256;
    static final int FIRST_LENGTH_CODE = 257;
    static final int LAST_LENGTH_CODE = 285;
    static final int FIRST_DISTANCE_CODE = 1;
    static final int LAST_DISTANCE_CODE = 29;
    static final int FIRST_CODE_LENGTH_CODE = 4;
    static final int LAST_CODE_LENGTH_CODE = 19;
    static final int[] lengthBases = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    static final int[] extraLengthBits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    static final int[] distanceBases = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    static final int[] extraDistanceBits = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};

    PngLzBlockReader(PngDecodingDataStream stream) {
        this.stream = stream;
        this.readHeader = false;
        this.isLastBlock = false;
    }

    void setWindowSize(int windowSize) {
        this.window = new byte[windowSize];
    }

    void readNextBlockHeader() {
        this.isLastBlock = this.stream.getNextIdatBit() != 0;
        this.compressionType = (byte)(this.stream.getNextIdatBits(2) & 0xFF);
        if (this.compressionType > 2) {
            this.stream.error();
        }
        if (this.compressionType == 0) {
            byte b1 = this.stream.getNextIdatByte();
            byte b2 = this.stream.getNextIdatByte();
            byte b3 = this.stream.getNextIdatByte();
            byte b4 = this.stream.getNextIdatByte();
            if (b1 != ~b3 || b2 != ~b4) {
                this.stream.error();
            }
            this.uncompressedBytesRemaining = b1 & 0xFF | (b2 & 0xFF) << 8;
        } else {
            this.huffmanTables = this.compressionType == 2 ? PngHuffmanTables.getDynamicTables(this.stream) : PngHuffmanTables.getFixedTables();
        }
    }

    byte getNextByte() {
        if (this.compressionType == 0) {
            if (this.uncompressedBytesRemaining == 0) {
                this.readNextBlockHeader();
                return this.getNextByte();
            }
            --this.uncompressedBytesRemaining;
            return this.stream.getNextIdatByte();
        }
        byte value = this.getNextCompressedByte();
        if (value == 256) {
            if (this.isLastBlock) {
                this.stream.error();
            }
            this.readNextBlockHeader();
            return this.getNextByte();
        }
        return value;
    }

    private void assertBlockAtEnd() {
        if (this.compressionType == 0) {
            if (this.uncompressedBytesRemaining > 0) {
                this.stream.error();
            }
        } else if (this.copyBytesRemaining > 0 || this.huffmanTables.getNextLiteralValue(this.stream) != 256) {
            this.stream.error();
        }
    }

    void assertCompressedDataAtEnd() {
        this.assertBlockAtEnd();
        while (!this.isLastBlock) {
            this.readNextBlockHeader();
            this.assertBlockAtEnd();
        }
    }

    private byte getNextCompressedByte() {
        if (this.copyBytesRemaining > 0) {
            byte value;
            this.window[this.windowIndex] = value = this.window[this.copyIndex];
            --this.copyBytesRemaining;
            ++this.copyIndex;
            ++this.windowIndex;
            if (this.copyIndex == this.window.length) {
                this.copyIndex = 0;
            }
            if (this.windowIndex == this.window.length) {
                this.windowIndex = 0;
            }
            return value;
        }
        int value = this.huffmanTables.getNextLiteralValue(this.stream);
        if (value < 256) {
            this.window[this.windowIndex] = (byte)(value & 0xFF);
            ++this.windowIndex;
            if (this.windowIndex >= this.window.length) {
                this.windowIndex = 0;
            }
            return (byte)(value & 0xFF);
        }
        if (value == 256) {
            this.readNextBlockHeader();
            return this.getNextCompressedByte();
        }
        if (value <= 285) {
            int extraBits = extraLengthBits[value - 257];
            int length = lengthBases[value - 257];
            if (extraBits > 0) {
                length += this.stream.getNextIdatBits(extraBits);
            }
            if ((value = this.huffmanTables.getNextDistanceValue(this.stream)) > 29) {
                this.stream.error();
            }
            extraBits = extraDistanceBits[value];
            int distance = distanceBases[value];
            if (extraBits > 0) {
                distance += this.stream.getNextIdatBits(extraBits);
            }
            this.copyIndex = this.windowIndex - distance;
            if (this.copyIndex < 0) {
                this.copyIndex += this.window.length;
            }
            this.copyBytesRemaining = length;
            return this.getNextCompressedByte();
        }
        this.stream.error();
        return 0;
    }
}

