/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    private final int MAX_RETRIES = 10;
    private int shellHandle;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$Clipboard;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.display = display;
        int widgetClass = OS.TopLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(null, null, widgetClass, display.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtRealizeWidget(this.shellHandle);
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$Clipboard == null ? (class$org$eclipse$swt$dnd$Clipboard = Clipboard.class$("org.eclipse.swt.dnd.Clipboard")) : class$org$eclipse$swt$dnd$Clipboard).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    public void dispose() {
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
        }
        this.shellHandle = 0;
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        int xDisplay;
        if (this.display == null) {
            DND.error(24);
        }
        if (this.display.isDisposed()) {
            DND.error(45);
        }
        if (transfer == null) {
            DND.error(4);
        }
        if ((xDisplay = OS.XtDisplay(this.shellHandle)) == 0) {
            return null;
        }
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow == 0) {
            return null;
        }
        int retries = 0;
        int status = OS.XmClipboardStartRetrieve(xDisplay, xWindow, OS.XtLastTimestampProcessed(xDisplay));
        while (status == 4 && retries < 10) {
            ++retries;
            status = OS.XmClipboardStartRetrieve(xDisplay, xWindow, OS.XtLastTimestampProcessed(xDisplay));
        }
        if (status != 1) {
            return null;
        }
        byte[] type = null;
        int[] length = new int[1];
        String[] supportedTypes = transfer.getTypeNames();
        int i = 0;
        while (i < supportedTypes.length) {
            byte[] bName = Converter.wcsToMbcs(null, supportedTypes[i], true);
            if (OS.XmClipboardInquireLength(xDisplay, xWindow, bName, length) == 1) {
                type = bName;
                break;
            }
            ++i;
        }
        byte[] data = null;
        if (type != null && (status = OS.XmClipboardRetrieve(xDisplay, xWindow, type, data = new byte[length[0]], length[0], new int[1], new int[1])) != 1) {
            data = null;
        }
        status = OS.XmClipboardEndRetrieve(xDisplay, xWindow);
        if (data == null) {
            return null;
        }
        TransferData transferData = new TransferData();
        transferData.type = OS.XmInternAtom(xDisplay, type, true);
        transferData.pValue = OS.XtMalloc(data.length);
        OS.memmove(transferData.pValue, data, data.length);
        transferData.length = data.length;
        transferData.format = 8;
        transferData.result = 1;
        Object result = transfer.nativeToJava(transferData);
        OS.XtFree(transferData.pValue);
        return result;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        int xWindow;
        int xDisplay;
        if (this.display == null) {
            DND.error(24);
        }
        if (this.display.isDisposed()) {
            DND.error(45);
        }
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        if ((xDisplay = OS.XtDisplay(this.shellHandle)) == 0) {
            DND.error(2002);
        }
        if ((xWindow = OS.XtWindow(this.shellHandle)) == 0) {
            DND.error(2002);
        }
        int[] item_id = new int[1];
        int retries = 0;
        int status = OS.XmClipboardStartCopy(xDisplay, xWindow, 0, OS.XtLastTimestampProcessed(xDisplay), this.shellHandle, 0, item_id);
        while (status == 4 && retries < 10) {
            ++retries;
            status = OS.XmClipboardStartCopy(xDisplay, xWindow, 0, OS.XtLastTimestampProcessed(xDisplay), this.shellHandle, 0, item_id);
        }
        if (status != 1) {
            DND.error(2002);
        }
        int i = 0;
        while (i < dataTypes.length) {
            int[] ids = dataTypes[i].getTypeIds();
            String[] names = dataTypes[i].getTypeNames();
            int j = 0;
            while (j < names.length) {
                TransferData transferData = new TransferData();
                transferData.type = ids[j];
                dataTypes[i].javaToNative(data[i], transferData);
                status = 0;
                if (transferData.result == 1 && transferData.format == 8) {
                    byte[] buffer = new byte[transferData.length];
                    OS.memmove(buffer, transferData.pValue, transferData.length);
                    byte[] bName = Converter.wcsToMbcs(null, names[j], true);
                    status = OS.XmClipboardCopy(xDisplay, xWindow, item_id[0], bName, buffer, transferData.length, 0, null);
                }
                if (transferData.pValue != 0) {
                    OS.XtFree(transferData.pValue);
                }
                ++j;
            }
            ++i;
        }
        OS.XmClipboardEndCopy(xDisplay, xWindow, item_id[0]);
        if (status != 1) {
            DND.error(2002);
        }
    }

    public String[] getAvailableTypeNames() {
        int xWindow;
        if (this.display == null) {
            DND.error(24);
        }
        if (this.display.isDisposed()) {
            DND.error(45);
        }
        int[] count = new int[1];
        int[] max_length = new int[1];
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            DND.error(1);
        }
        if ((xWindow = OS.XtWindow(this.shellHandle)) == 0) {
            DND.error(1);
        }
        if (OS.XmClipboardInquireCount(xDisplay, xWindow, count, max_length) != 1) {
            DND.error(1);
        }
        String[] types = new String[count[0]];
        int i = 0;
        while (i < count[0]) {
            byte[] buffer = new byte[max_length[0]];
            int[] copied_length = new int[1];
            int rc = OS.XmClipboardInquireFormat(xDisplay, xWindow, i + 1, buffer, buffer.length, copied_length);
            if (rc == 6) {
                types[i] = "";
            } else {
                if (rc != 1) {
                    DND.error(1);
                }
                byte[] buffer2 = new byte[copied_length[0]];
                System.arraycopy(buffer, 0, buffer2, 0, copied_length[0]);
                char[] unicode = Converter.mbcsToWcs(null, buffer2);
                types[i] = new String(unicode);
            }
            ++i;
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

