/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class Window {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static Image defaultImage;
    private static IExceptionHandler exceptionHandler;
    private Shell parentShell;
    private int shellStyle = 1264;
    private WindowManager windowManager;
    private Shell shell;
    private Control contents;
    private int returnCode = 0;
    private static int globalReturnCode;
    private boolean block = false;
    private FontChangeListener fontChangeListener;
    private boolean resizeHasOccurred = false;
    private Listener resizeListener;

    static {
        exceptionHandler = new DefaultExceptionHandler();
        globalReturnCode = 0;
    }

    protected Window(Shell parentShell) {
        this.parentShell = parentShell;
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    public boolean close() {
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        if (this.fontChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fontChangeListener);
            this.fontChangeListener = null;
        }
        this.shell.dispose();
        this.shell = null;
        this.contents = null;
        if (this.windowManager != null) {
            this.windowManager.remove(this);
            this.windowManager = null;
        }
        return true;
    }

    protected void configureShell(Shell newShell) {
        if (defaultImage != null) {
            newShell.setImage(defaultImage);
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        newShell.setLayout((Layout)layout);
    }

    protected void constrainShellSize() {
        Point size = this.shell.getSize();
        Rectangle bounds = this.shell.getDisplay().getClientArea();
        int newX = Math.min(size.x, bounds.width);
        int newY = Math.min(size.y, bounds.height);
        if (size.x != newX || size.y != newY) {
            this.shell.setSize(newX, newY);
        }
    }

    public void create() {
        this.shell = this.createShell();
        this.contents = this.createContents((Composite)this.shell);
        this.initializeBounds();
    }

    protected Control createContents(Composite parent) {
        return new Composite(parent, 0);
    }

    protected final Shell createShell() {
        Shell newShell = new Shell(this.getParentShell(), this.getShellStyle());
        this.resizeListener = new Listener(){

            public void handleEvent(Event e) {
                Window.this.resizeHasOccurred = true;
            }
        };
        newShell.addListener(11, this.resizeListener);
        newShell.setData((Object)this);
        newShell.addShellListener(this.getShellListener());
        this.configureShell(newShell);
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new FontChangeListener();
        }
        JFaceResources.getFontRegistry().addListener(this.fontChangeListener);
        return newShell;
    }

    protected Control getContents() {
        return this.contents;
    }

    public static Image getDefaultImage() {
        return defaultImage;
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parentShell = this.shell.getParent();
        Rectangle containerBounds = parentShell != null ? parentShell.getBounds() : this.shell.getDisplay().getClientArea();
        int x = Math.max(0, containerBounds.x + (containerBounds.width - initialSize.x) / 2);
        int y = Math.max(0, containerBounds.y + (containerBounds.height - initialSize.y) / 3);
        return new Point(x, y);
    }

    protected Point getInitialSize() {
        return this.shell.computeSize(-1, -1, true);
    }

    protected Shell getParentShell() {
        return this.parentShell;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected ShellListener getShellListener() {
        return new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                if (Window.this.canHandleShellCloseEvent()) {
                    Window.this.handleShellCloseEvent();
                }
            }
        };
    }

    protected int getShellStyle() {
        return this.shellStyle;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    protected void handleFontChange(PropertyChangeEvent event) {
    }

    protected void handleShellCloseEvent() {
        this.setReturnCode(1);
        this.close();
    }

    protected void initializeBounds() {
        if (this.resizeListener != null) {
            this.shell.removeListener(11, this.resizeListener);
        }
        if (this.resizeHasOccurred) {
            return;
        }
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.shell.setBounds(location.x, location.y, size.x, size.y);
    }

    public int open() {
        if (this.shell == null) {
            this.create();
        }
        this.constrainShellSize();
        this.shell.open();
        if (this.block) {
            this.runEventLoop(this.shell);
        }
        return this.returnCode;
    }

    private void runEventLoop(Shell shell) {
        Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        while (shell != null && !shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                exceptionHandler.handleException(e);
            }
        }
        display.update();
    }

    public void setBlockOnOpen(boolean shouldBlock) {
        this.block = shouldBlock;
    }

    public static void setDefaultImage(Image image) {
        defaultImage = image;
    }

    protected void setReturnCode(int code) {
        this.returnCode = code;
        globalReturnCode = code;
    }

    protected void setShellStyle(int newShellStyle) {
        this.shellStyle = newShellStyle;
    }

    public void setWindowManager(WindowManager manager) {
        this.windowManager = manager;
        if (manager != null) {
            Window[] windows = manager.getWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i] == this) {
                    return;
                }
                ++i;
            }
            manager.add(this);
        }
    }

    public static void setExceptionHandler(IExceptionHandler handler) {
        if (exceptionHandler instanceof DefaultExceptionHandler) {
            exceptionHandler = handler;
        }
    }

    public static interface IExceptionHandler {
        public void handleException(Throwable var1);
    }

    private static class DefaultExceptionHandler
    implements IExceptionHandler {
        DefaultExceptionHandler() {
        }

        public void handleException(Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            t.printStackTrace();
        }
    }

    private class FontChangeListener
    implements IPropertyChangeListener {
        FontChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Window.this.handleFontChange(event);
        }
    }
}

