/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class MultiTermQuery
extends Query {
    private Term term;

    public MultiTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        FilteredTermEnum enumerator = this.getEnum(reader);
        BooleanQuery query = new BooleanQuery();
        try {
            do {
                Term t;
                if ((t = enumerator.term()) == null) continue;
                TermQuery tq = new TermQuery(t);
                tq.setBoost(this.getBoost() * enumerator.difference());
                query.add(tq, false, false);
            } while (enumerator.next());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            enumerator.close();
            throw throwable;
        }
        enumerator.close();
        return query;
    }

    public Query combine(Query[] queries) {
        return Query.mergeBooleanQueries(queries);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }
}

