/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    Font font;
    Font[] cellFont;
    boolean cached;

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        } else {
            this.handle = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child((int)parent.modelHandle, (int)this.handle, (int)0, (int)index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int columnCount = OS.gtk_tree_model_get_n_columns((int)this.parent.modelHandle);
            int i = 0;
            while (i < columnCount) {
                OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)i, (int)0, (int)-1);
                ++i;
            }
        }
        this.cached = false;
        this.font = null;
        this.cellFont = null;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)3, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 3), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        OS.gtk_widget_realize((int)parentHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area((int)parentHandle, (int)path, (int)column, (GdkRectangle)rect);
        OS.gtk_tree_path_free((int)path);
        if (index == 0 && (this.parent.style & 0x20) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION((int)2, (int)1, (int)3)) {
                int[] x = new int[1];
                int[] w = new int[1];
                OS.gtk_tree_view_column_cell_get_position((int)column, (int)this.parent.checkRenderer, (int[])x, (int[])w);
                rect.x += x[0] + w[0];
                rect.width -= x[0] + w[0];
            } else {
                int[] w = new int[1];
                OS.gtk_cell_renderer_get_size((int)this.parent.checkRenderer, (int)parentHandle, null, null, null, (int[])w, null);
                int[] buffer = new int[1];
                OS.gtk_widget_style_get((int)parentHandle, (byte[])OS.horizontal_separator, (int[])buffer, (int)0);
                rect.x += w[0] + buffer[0];
                rect.width -= w[0] + buffer[0];
            }
        }
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords((int)parentHandle, (int)rect.x, (int)0, (int[])wx, null);
        rect.x = wx[0];
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + border, rect.y + (headerHeight == 0 ? border : headerHeight), rect.width + 1, rect.height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)0, (int[])ptr, (int)-1);
        return ptr[0] != 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)2, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 2), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)1, (int[])ptr, (int)-1);
        return ptr[0] != 0;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return null;
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 0), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int imageIndex = imageList.indexOf(ptr[0]);
        if (imageIndex == -1) {
            return null;
        }
        return imageList.get(imageIndex);
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.handle;
        int column = 0;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        OS.gtk_widget_realize((int)parentHandle);
        OS.gtk_tree_view_get_cell_area((int)parentHandle, (int)path, (int)column, (GdkRectangle)rect);
        OS.gtk_tree_path_free((int)path);
        if (OS.GTK_VERSION >= OS.VERSION((int)2, (int)1, (int)3)) {
            int[] x = new int[1];
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_get_position((int)column, (int)pixbufRenderer, (int[])x, (int[])w);
            rect.x += x[0];
            rect.width = w[0];
        } else {
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.parent.modelHandle, (int)this.handle, (boolean)false, (boolean)false);
            OS.gtk_cell_renderer_get_size((int)pixbufRenderer, (int)parentHandle, null, null, null, (int[])w, null);
            rect.width = w[0];
        }
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords((int)parentHandle, (int)rect.x, (int)0, (int[])wx, null);
        rect.x = wx[0];
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + border, rect.y + (headerHeight == 0 ? border : headerHeight), rect.width, rect.height + 1);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return "";
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 1), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return "";
        }
        int length = OS.strlen((int)ptr[0]);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)ptr[0], (int)length);
        OS.g_free((int)ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.handle != 0) {
            OS.g_free((int)this.handle);
        }
        this.handle = 0;
        this.parent = null;
        this.font = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)3, (GdkColor)gdkColor, (int)-1);
        this.cached = true;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 3), (GdkColor)gdkColor, (int)-1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)this.display.textCellDataProc, (int)parentHandle, (int)0);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)imageRenderer, (int)this.display.pixbufCellDataProc, (int)parentHandle, (int)0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)0, (boolean)checked, (int)-1);
        this.cached = true;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        this.font = font;
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)4, (int)fontHandle, (int)-1);
        this.cached = true;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            this.cellFont = new Font[count];
        }
        if (this.cellFont[index] == font) {
            return;
        }
        if (this.cellFont[index] != null && this.cellFont[index].equals(font)) {
            return;
        }
        this.cellFont[index] = font;
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 4), (int)fontHandle, (int)-1);
        this.cached = true;
        if (font != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
                    if (column == 0) {
                        return;
                    }
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)this.display.textCellDataProc, (int)parentHandle, (int)0);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)imageRenderer, (int)this.display.pixbufCellDataProc, (int)parentHandle, (int)0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)2, (GdkColor)gdkColor, (int)-1);
        this.cached = true;
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 2), (GdkColor)gdkColor, (int)-1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int parentHandle = this.parent.handle;
                    int column = 0;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)this.display.textCellDataProc, (int)parentHandle, (int)0);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)imageRenderer, (int)this.display.pixbufCellDataProc, (int)parentHandle, (int)0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)1, (boolean)grayed, (int)-1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixbuf = 0;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 0), (int)pixbuf, (int)-1);
        this.cached = true;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int cfr_ignored_0 = this.parent.handle;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 1), (byte[])buffer, (int)-1);
        this.cached = true;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }
}

