/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.io.FilePermission;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;

public class BundleLocationCondition
implements Condition {
    boolean satisfied;

    public BundleLocationCondition(Bundle bundle, String location) {
        FilePermission locationPat = new FilePermission(location, "read");
        FilePermission sourcePat = new FilePermission(bundle.getLocation().toString(), "read");
        this.satisfied = locationPat.implies(sourcePat);
    }

    public boolean isEvaluated() {
        return true;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isSatisfied(Condition[] conds, Dictionary context) {
        int i = 0;
        while (i < conds.length) {
            if (!conds[i].isSatisfied()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

