/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;

public class HostSpecificationImpl
extends VersionConstraintImpl
implements HostSpecification {
    private BundleDescription[] hosts;

    public boolean isSatisfiedBy(BaseDescription supplier) {
        if (!(supplier instanceof BundleDescription)) {
            return false;
        }
        BundleDescription candidate = (BundleDescription)supplier;
        if (candidate.getHost() != null) {
            return false;
        }
        return this.getName() != null && this.getName().equals(candidate.getSymbolicName()) && (this.getVersionRange() == null || this.getVersionRange().isIncluded(candidate.getVersion()));
    }

    public BundleDescription[] getHosts() {
        return this.hosts;
    }

    public boolean isResolved() {
        return this.hosts != null && this.hosts.length > 0;
    }

    protected void setHosts(BundleDescription[] hosts) {
        this.hosts = hosts;
    }

    public String toString() {
        return "Fragment-Host: " + this.getName() + " - version: " + this.getVersionRange();
    }

    public BaseDescription getSupplier() {
        if (this.hosts == null || this.hosts.length == 0) {
            return null;
        }
        return this.hosts[0];
    }
}

