/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ReliableFile {
    protected static final byte[] identifier1 = new byte[]{46, 99, 114, 99};
    protected static final byte[] identifier2 = new byte[]{46, 118, 49, 10};
    public static final String tmpExt = ".tmp";
    public static final String oldExt = ".bak";
    public static final String newExt = ".new";
    private static Hashtable files = new Hashtable(30);
    private File orgFile;
    private File tmpFile;
    private File oldFile;
    private File newFile;
    private boolean locked;
    private int use;
    private static final int VERSION_UNKNOWN = 0;
    private static final int VERSION_PLAINTEXT = 1;
    private static final int VERSION_2 = 2;
    private int version;
    Checksum appendCrc;
    public static final String MINIMUM_AGING_INTERVAL_KEY = "reliablefile.minimumAgingInterval";
    private static final int AGING_INTERVAL_DEFAULT = 2000;
    private static int agingInterval = -1;
    private static final int CP_BUF_SIZE = 4096;

    static ReliableFile getReliableFile(String name) throws IOException {
        return ReliableFile.getReliableFile(new File(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReliableFile getReliableFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new FileNotFoundException("file is a directory");
        }
        Hashtable hashtable = files;
        synchronized (hashtable) {
            ReliableFile reliable = (ReliableFile)files.get(file);
            if (reliable == null) {
                reliable = new ReliableFile(file);
                files.put(file, reliable);
            }
            ++reliable.use;
            return reliable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Hashtable hashtable = files;
        synchronized (hashtable) {
            --this.use;
            if (this.use <= 0) {
                files.remove(this.orgFile);
            }
        }
    }

    private ReliableFile(File file) {
        String name = file.getPath();
        this.orgFile = file;
        this.tmpFile = new File(String.valueOf(name) + "." + new Random().nextInt(0x1000000) + tmpExt);
        this.oldFile = new File(String.valueOf(name) + oldExt);
        this.newFile = new File(String.valueOf(name) + newExt);
        this.use = 0;
        this.locked = false;
        this.version = 0;
        this.appendCrc = null;
        if (agingInterval == -1) {
            agingInterval = 2000;
            String value = System.getProperty(MINIMUM_AGING_INTERVAL_KEY);
            if (value != null) {
                try {
                    int i = Integer.parseInt(value);
                    if (i >= 0) {
                        agingInterval = i;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid property value for key \"reliablefile.minimumAgingInterval\".");
                }
            }
        }
    }

    synchronized InputStream getInputStream() throws IOException {
        try {
            this.lock();
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        try {
            BufferedInputStream bis = this.recoverFile();
            if (bis == null) {
                return new FileInputStream(this.orgFile.getPath());
            }
            return bis;
        }
        catch (IOException e) {
            this.unlock();
            this.release();
            throw e;
        }
    }

    void closeInputFile() throws IOException {
        this.unlock();
        this.release();
    }

    synchronized OutputStream getOutputStream(boolean append) throws IOException {
        block11: {
            try {
                this.lock();
            }
            catch (IOException e) {
                this.release();
                throw e;
            }
            try {
                BufferedInputStream bis = this.recoverFile();
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                if (!append) break block11;
                this.unlock();
                this.release();
                throw e;
            }
        }
        try {
            if (append) {
                if (this.orgFile.exists()) {
                    int truncate = this.version == 2 ? 16 : 0;
                    ReliableFile.cp(this.orgFile, this.tmpFile, truncate);
                } else if (this.tmpFile.exists()) {
                    ReliableFile.rm(this.tmpFile);
                }
            }
            return new FileOutputStream(this.tmpFile.getPath(), append);
        }
        catch (IOException e) {
            this.unlock();
            this.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void closeOutputFile() throws IOException {
        try {
            boolean orgExists = this.orgFile.exists();
            boolean newExists = this.newFile.exists();
            boolean backupOrg = true;
            long orgAge = System.currentTimeMillis() - this.orgFile.lastModified();
            if (orgAge >= 0L && orgAge < (long)agingInterval) {
                backupOrg = false;
            }
            if (newExists) {
                ReliableFile.rm(this.newFile);
            }
            ReliableFile.mv(this.tmpFile, this.newFile);
            if (orgExists) {
                if (newExists) {
                    ReliableFile.rm(this.orgFile);
                } else if (backupOrg) {
                    ReliableFile.rm(this.oldFile);
                    ReliableFile.mv(this.orgFile, this.oldFile);
                } else {
                    ReliableFile.rm(this.orgFile);
                }
            }
            ReliableFile.mv(this.newFile, this.orgFile);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unlock();
            this.release();
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.unlock();
            this.release();
            return;
        }
    }

    private BufferedInputStream recoverFile() throws IOException {
        boolean[] oldHasSig;
        boolean oldValid;
        boolean orgExists = this.orgFile.exists();
        boolean newExists = this.newFile.exists();
        boolean oldExists = this.oldFile.exists();
        Checksum orgCrc = null;
        Checksum newCrc = null;
        Checksum oldCrc = null;
        int orgVersion = 2;
        int oldVersion = 2;
        BufferedInputStream orgBis = null;
        BufferedInputStream newBis = null;
        BufferedInputStream oldBis = null;
        if (newExists && !(newExists = ReliableFile.isValidReliableFile(newBis = new BufferedInputStream(new FileInputStream(this.newFile)), newCrc = ReliableFile.getChecksumCalculator(), null))) {
            ReliableFile.rm(this.newFile);
        }
        orgCrc = ReliableFile.getChecksumCalculator();
        if (orgExists) {
            orgBis = new BufferedInputStream(new FileInputStream(this.orgFile));
            boolean[] orgHasSig = new boolean[1];
            boolean orgValid = ReliableFile.isValidReliableFile(orgBis, orgCrc, orgHasSig);
            if (!orgValid) {
                if (oldExists) {
                    boolean[] oldHasSig2;
                    oldBis = new BufferedInputStream(new FileInputStream(this.oldFile));
                    oldCrc = ReliableFile.getChecksumCalculator();
                    boolean oldValid2 = ReliableFile.isValidReliableFile(oldBis, oldCrc, oldHasSig2 = new boolean[1]);
                    if (oldValid2) {
                        if (this.tmpFile.exists()) {
                            ReliableFile.rm(this.tmpFile);
                        }
                        if (orgBis != null) {
                            orgBis.close();
                            orgBis = null;
                        }
                        if (oldBis != null) {
                            oldBis.close();
                            oldBis = null;
                        }
                        ReliableFile.mv(this.orgFile, this.tmpFile);
                        ReliableFile.mv(this.oldFile, this.orgFile);
                        ReliableFile.mv(this.tmpFile, this.oldFile);
                        orgVersion = 2;
                        oldVersion = 0;
                    } else if (!orgHasSig[0] && !oldHasSig2[0]) {
                        orgVersion = 1;
                        oldVersion = 1;
                    } else if (orgHasSig[0] && !oldHasSig2[0]) {
                        if (this.tmpFile.exists()) {
                            ReliableFile.rm(this.tmpFile);
                        }
                        if (orgBis != null) {
                            orgBis.close();
                            orgBis = null;
                        }
                        if (oldBis != null) {
                            oldBis.close();
                            oldBis = null;
                        }
                        ReliableFile.mv(this.orgFile, this.tmpFile);
                        ReliableFile.mv(this.oldFile, this.orgFile);
                        ReliableFile.mv(this.tmpFile, this.oldFile);
                        orgVersion = 1;
                        oldVersion = 0;
                    } else if (orgHasSig[0] && oldHasSig2[0]) {
                        if (!newExists) {
                            throw new IOException("ReliableFile is corrupt.");
                        }
                    } else if (!orgHasSig[0]) {
                        boolean cfr_ignored_0 = oldHasSig2[0];
                    }
                } else if (orgHasSig[0]) {
                    if (!newExists) {
                        throw new IOException("ReliableFile is corrupt.");
                    }
                } else {
                    orgVersion = 1;
                }
            }
        } else if (oldExists && !(oldValid = ReliableFile.isValidReliableFile(oldBis = new BufferedInputStream(new FileInputStream(this.oldFile)), oldCrc = ReliableFile.getChecksumCalculator(), oldHasSig = new boolean[1]))) {
            if (oldHasSig[0]) {
                if (!newExists) {
                    throw new IOException("ReliableFile is corrupt.");
                }
            } else {
                oldVersion = 1;
            }
        }
        if (newExists) {
            if (orgBis != null) {
                orgBis.close();
            }
            if (oldBis != null) {
                oldBis.close();
            }
            if (newBis != null) {
                newBis.close();
                newBis = null;
            }
            if (orgExists) {
                if (oldExists) {
                    ReliableFile.rm(this.oldFile);
                }
                ReliableFile.mv(this.orgFile, this.oldFile);
            }
            ReliableFile.mv(this.newFile, this.orgFile);
            this.appendCrc = newCrc;
            this.version = 2;
            return newBis;
        }
        if (oldExists && !orgExists) {
            if (orgBis != null) {
                orgBis.close();
            }
            ReliableFile.cp(this.oldFile, this.orgFile, 0);
            this.appendCrc = oldCrc;
            this.version = oldVersion;
            return oldBis;
        }
        if (oldBis != null) {
            oldBis.close();
        }
        this.appendCrc = orgCrc;
        this.version = orgVersion;
        return orgBis;
    }

    private void lock() throws IOException {
        if (this.locked) {
            throw new FileNotFoundException("file locked");
        }
        this.locked = true;
    }

    private void unlock() {
        this.locked = false;
    }

    private static void mv(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("rename failed");
        }
    }

    private static void cp(File from, File to, int truncateSize) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            int length = (int)from.length();
            length = truncateSize > length ? 0 : (length -= truncateSize);
            if (length > 0) {
                int count;
                if (length > 4096) {
                    length = 4096;
                }
                in = new FileInputStream(from);
                byte[] buffer = new byte[length];
                int size = 0;
                while ((count = in.read(buffer, 0, length)) > 0) {
                    if (size + count >= length) {
                        count = length - size;
                    }
                    out.write(buffer, 0, count);
                    size += count;
                }
                in.close();
                in = null;
            }
            out.close();
            out = null;
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }

    private static void rm(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("delete failed");
        }
    }

    public static boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        String name = file.getPath();
        return new File(String.valueOf(name) + oldExt).exists() || new File(String.valueOf(name) + newExt).exists();
    }

    public static long lastModified(File file) {
        String name = file.getPath();
        File newFile = new File(String.valueOf(name) + newExt);
        if (newFile.exists()) {
            return newFile.lastModified();
        }
        if (file.exists()) {
            return file.lastModified();
        }
        File oldFile = new File(String.valueOf(name) + oldExt);
        return oldFile.lastModified();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void delete() throws IOException {
        try {
            this.lock();
        }
        catch (IOException e) {
            this.release();
            throw e;
        }
        try {
            ReliableFile.rm(this.oldFile);
            ReliableFile.rm(this.orgFile);
            ReliableFile.rm(this.newFile);
            ReliableFile.rm(this.tmpFile);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.unlock();
            this.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.unlock();
            this.release();
            return;
        }
    }

    public static boolean delete(File file) {
        try {
            ReliableFile.getReliableFile(file).delete();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected int getSignatureSize() throws IOException {
        if (this.version == 0) {
            throw new IOException("Version is unknown!");
        }
        if (this.version == 2) {
            return 16;
        }
        return 0;
    }

    protected Checksum getFileChecksum() throws IOException {
        if (this.appendCrc == null) {
            throw new IOException("Checksum is invalid!");
        }
        return this.appendCrc;
    }

    protected static Checksum getChecksumCalculator() {
        return new CRC32();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isValidReliableFile(BufferedInputStream bis, Checksum crc, boolean[] containsSignature) throws IOException {
        block19: {
            block18: {
                if (containsSignature != null) {
                    containsSignature[0] = false;
                }
                bis.mark(bis.available());
                try {
                    block20: {
                        byte[] sig;
                        int len = bis.available();
                        if (len < 16) {
                            byte[] data;
                            int num;
                            if (crc != null && (num = bis.read(data = new byte[16])) > 0) {
                                crc.update(data, 0, num);
                            }
                            Object var12_8 = null;
                            break block18;
                        }
                        len -= 16;
                        if (crc == null) {
                            crc = ReliableFile.getChecksumCalculator();
                        }
                        int pos = 0;
                        byte[] data = new byte[8192];
                        while (true) {
                            int num;
                            if (pos >= len) {
                                sig = new byte[16];
                                num = bis.read(sig);
                                if (num != 16) {
                                    throw new IOException("Unable to read entire file.");
                                }
                                break;
                            }
                            int read = data.length;
                            if (pos + read > len) {
                                read = len - pos;
                            }
                            if ((num = bis.read(data, 0, read)) == -1) {
                                throw new IOException("Unable to read entire file.");
                            }
                            crc.update(data, 0, num);
                            pos += num;
                        }
                        int i = 0;
                        while (true) {
                            if (i >= 4) break;
                            if (identifier1[i] != sig[i]) {
                                crc.update(sig, 0, 16);
                                break block19;
                            }
                            ++i;
                        }
                        i = 0;
                        int j = 12;
                        while (true) {
                            if (i >= 4) {
                                long crccmp;
                                if (containsSignature != null) {
                                    containsSignature[0] = true;
                                }
                                if ((crccmp = Long.valueOf(new String(sig, 4, 8), 16).longValue()) == crc.getValue()) {
                                    break;
                                }
                                break block20;
                            }
                            if (identifier2[i] != sig[j]) {
                                crc.update(sig, 0, 16);
                                Object var12_10 = null;
                                bis.reset();
                                return false;
                            }
                            ++i;
                            ++j;
                        }
                        Object var12_11 = null;
                        bis.reset();
                        return true;
                    }
                    Object var12_12 = null;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    bis.reset();
                    throw throwable;
                }
                bis.reset();
                return false;
            }
            bis.reset();
            return false;
        }
        Object var12_9 = null;
        bis.reset();
        return false;
    }

    protected static String intToHex(int l) {
        byte[] buffer = new byte[8];
        int count = 8;
        do {
            int ch;
            ch = (ch = l & 0xF) > 9 ? ch - 10 + 97 : (ch += 48);
            buffer[--count] = (byte)ch;
            l >>= 4;
        } while (count > 0);
        return new String(buffer);
    }
}

