/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> allExports = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            ExportPackageDescription[] allDescriptions = this.framework.adaptor.getState().getExportedPackages();
            int i = 0;
            while (i < allDescriptions.length) {
                ExportedPackageImpl exportedPackage;
                if (allDescriptions[i].isRoot() && (exportedPackage = this.createExportedPackage(allDescriptions[i])) != null && (bundle == null || exportedPackage.supplier.getBundle() == bundle)) {
                    allExports.add(exportedPackage);
                }
                ++i;
            }
        }
        return allExports.size() == 0 ? null : allExports.toArray(new ExportedPackage[allExports.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription description) {
        BundleDescription exporter = description.getExporter();
        if (exporter == null || exporter.getHost() != null) {
            return null;
        }
        BundleLoaderProxy proxy = (BundleLoaderProxy)exporter.getUserObject();
        if (proxy == null) {
            BundleHost bundle = (BundleHost)this.framework.getBundle(exporter.getBundleId());
            if (bundle == null) {
                return null;
            }
            proxy = bundle.getLoaderProxy();
        }
        return new ExportedPackageImpl(description, proxy);
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ExportedPackage result = null;
        int i = 0;
        while (i < allExports.length) {
            if (name.equals(allExports[i].getName())) {
                if (result == null) {
                    result = allExports[i];
                } else {
                    Version curVersion = Version.parseVersion(result.getSpecificationVersion());
                    Version newVersion = Version.parseVersion(allExports[i].getSpecificationVersion());
                    if (newVersion.compareTo(curVersion) >= 0) {
                        result = allExports[i];
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public ExportedPackage[] getExportedPackages(String name) {
        ExportedPackage[] allExports = this.getExportedPackages((Bundle)null);
        if (allExports == null) {
            return null;
        }
        ArrayList<ExportedPackage> result = new ArrayList<ExportedPackage>(1);
        int i = 0;
        while (i < allExports.length) {
            if (name.equals(allExports[i].getName())) {
                result.add(allExports[i]);
            }
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new ExportedPackage[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshPackages(Bundle[] input) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        AbstractBundle[] copy = null;
        if (input != null) {
            Bundle[] bundleArray = input;
            // MONITORENTER : input
            copy = new AbstractBundle[input.length];
            System.arraycopy(input, 0, copy, 0, input.length);
            // MONITOREXIT : bundleArray
        }
        final AbstractBundle[] bundles = copy;
        Thread refresh = SecureAction.createThread(new Runnable(){

            public void run() {
                PackageAdminImpl.this.doResolveBundles(bundles, true);
            }
        }, "Refresh Packages");
        refresh.start();
    }

    public boolean resolveBundles(Bundle[] bundles) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundles == null) {
            bundles = this.framework.getAllBundles();
        }
        int i = 0;
        while (i < bundles.length) {
            if (!((AbstractBundle)bundles[i]).isResolved()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void doResolveBundles(AbstractBundle[] bundles, boolean refreshPackages) {
        try {
            block20: {
                try {
                    this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                    AbstractBundle[] refreshedBundles = null;
                    BundleDescription[] descriptions = null;
                    BundleRepository bundleRepository = this.framework.bundles;
                    synchronized (bundleRepository) {
                        int numBundles;
                        int n = numBundles = bundles == null ? 0 : bundles.length;
                        if (!refreshPackages) {
                            descriptions = new BundleDescription[]{};
                        } else if (numBundles > 0) {
                            ArrayList<BundleDescription> results = new ArrayList<BundleDescription>(numBundles);
                            int i = 0;
                            while (i < numBundles) {
                                AbstractBundle[] sameNames;
                                BundleDescription description = bundles[i].getBundleDescription();
                                if (description != null && description.getBundleId() != 0L && !results.contains(description)) {
                                    results.add(description);
                                }
                                if ((sameNames = this.framework.bundles.getBundles(bundles[i].getSymbolicName())) != null && sameNames.length > 1) {
                                    int j = 0;
                                    while (j < sameNames.length) {
                                        BundleDescription sameName;
                                        if (sameNames[j] != bundles[i] && (sameName = sameNames[j].getBundleDescription()) != null && sameName.getBundleId() != 0L && sameName.isSingleton() && !results.contains(sameName)) {
                                            results.add(sameName);
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                            descriptions = results.size() == 0 ? null : results.toArray(new BundleDescription[results.size()]);
                        }
                    }
                    StateDelta stateDelta = this.framework.adaptor.getState().resolve(descriptions);
                    refreshedBundles = this.processDelta(stateDelta.getChanges(), refreshPackages);
                    if (refreshPackages) {
                        AbstractBundle[] allBundles = this.framework.getAllBundles();
                        int i = 0;
                        while (i < allBundles.length) {
                            allBundles[i].unresolvePermissions(refreshedBundles);
                            ++i;
                        }
                        this.resumeBundles(refreshedBundles);
                    }
                }
                catch (Throwable t) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                        Debug.printStackTrace(t);
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (!(t instanceof Error)) break block20;
                    throw (Error)t;
                }
            }
            Object var13_18 = null;
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (!refreshPackages) return;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            return;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
            if (!refreshPackages) throw throwable;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            throw throwable;
        }
    }

    private void resumeBundles(AbstractBundle[] bundles) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (bundles == null) {
            return;
        }
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].isResolved()) {
                this.framework.resumeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private void insertBundle(AbstractBundle bundle, ArrayList bundleList) {
        int index = 0;
        Iterator iter = bundleList.iterator();
        while (iter.hasNext()) {
            Object current = iter.next();
            if (current == bundle) {
                return;
            }
            if (bundle.compareTo(current) < 0) break;
            ++index;
        }
        bundleList.add(index, bundle);
    }

    private void suspendBundle(AbstractBundle bundle) throws BundleException {
        if (bundle.isActive() && !bundle.isFragment()) {
            boolean suspended = this.framework.suspendBundle(bundle, true);
            if (!suspended) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
            }
        } else if (bundle.getStateChanging() != Thread.currentThread()) {
            bundle.beginStateChange();
        }
        if (Debug.DEBUG_PACKAGEADMIN && bundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + bundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundle = bundleDelta.getBundle();
            if (bundle.getDependents() != null && bundle.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundle);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.formatter.getString("OSGI_INTERNAL_ERROR"));
            }
            BundleLoaderProxy proxy = (BundleLoaderProxy)bundle.getUserObject();
            BundleHost.closeBundleLoader(proxy);
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle bundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (bundle == null) {
            BundleException be = new BundleException(Msg.formatter.getString("BUNDLE_NOT_IN_FRAMEWORK", bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            return null;
        }
        if (bundle.isFragment()) {
            BundleDescription[] hosts = bundleDescription.getHost().getHosts();
            int i = 0;
            while (i < hosts.length) {
                BundleHost host = (BundleHost)this.framework.getBundle(hosts[0].getBundleId());
                ((BundleFragment)bundle).addHost(host.getLoaderProxy());
                ++i;
            }
        }
        bundle.resolve();
        return bundle;
    }

    private AbstractBundle[] applyDeltas(BundleDelta[] bundleDeltas) throws BundleException {
        ArrayList<AbstractBundle> results = new ArrayList<AbstractBundle>(bundleDeltas.length);
        int i = 0;
        while (i < bundleDeltas.length) {
            AbstractBundle bundle;
            int type = bundleDeltas[i].getType();
            if ((type & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltas[i]);
            }
            if ((type & 8) != 0 && (bundle = this.setResolved(bundleDeltas[i].getBundle())) != null && bundle.isResolved()) {
                results.add(bundle);
            }
            ++i;
        }
        return results.size() == 0 ? null : results.toArray(new AbstractBundle[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractBundle[] processDelta(BundleDelta[] bundleDeltas, boolean refreshPackages) {
        bundlesList = new ArrayList<E>(bundleDeltas.length);
        i = 0;
        while (i < bundleDeltas.length) {
            changedBundle = this.framework.getBundle(bundleDeltas[i].getBundle().getBundleId());
            if (changedBundle != null) {
                this.insertBundle(changedBundle, bundlesList);
            }
            ++i;
        }
        refresh = bundlesList.toArray(new AbstractBundle[bundlesList.size()]);
        previouslyResolved = new boolean[refresh.length];
        resolved = null;
        try {
            block43: {
                block42: {
                    block41: {
                        try {
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                            }
                            restart = false;
                            i = refresh.length - 1;
                            while (i >= 0) {
                                previouslyResolved[i] = refresh[i].isResolved();
                                if (refresh[i] == this.framework.systemBundle) {
                                    restart = true;
                                } else if ((refresh[i].bundledata.getType() & 2) != 0 && previouslyResolved[i]) {
                                    restart = true;
                                } else if ((refresh[i].bundledata.getType() & 4) != 0) {
                                    restart = true;
                                }
                                --i;
                            }
                            if (restart) {
                                if (refreshPackages) {
                                    this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                                }
                                this.restartFramework();
                            }
                            if (refreshPackages) {
                                i = refresh.length - 1;
                                while (i >= 0) {
                                    this.suspendBundle(refresh[i]);
                                    --i;
                                }
                            }
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("refreshPackages: refresh the bundles");
                            }
                            i = this.framework.bundles;
                            synchronized (i) {
                                i = 0;
                                while (i < refresh.length) {
                                    refresh[i].refresh();
                                    ++i;
                                }
                            }
                            i = 0;
                            while (i < refresh.length) {
                                if (previouslyResolved[i]) {
                                    this.framework.publishBundleEvent(64, refresh[i]);
                                }
                                ++i;
                            }
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("refreshPackages: applying deltas to bundles");
                            }
                            var8_15 = this.framework.bundles;
                            synchronized (var8_15) {
                                resolved = this.applyDeltas(bundleDeltas);
                            }
                            var10_19 = null;
                            if (!Debug.DEBUG_PACKAGEADMIN) break block41;
                        }
                        catch (Throwable var11_17) {
                            var10_18 = null;
                            if (Debug.DEBUG_PACKAGEADMIN) {
                                Debug.println("refreshPackages: release the state change locks");
                            }
                            if (!refreshPackages) break block42;
                            i = 0;
                            if (true) ** GOTO lbl88
                        }
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    if (!refreshPackages) break block43;
                    i = 0;
                    if (true) ** GOTO lbl95
                    do {
                        changedBundle = refresh[i];
                        changedBundle.completeStateChange();
                        ++i;
lbl88:
                        // 2 sources

                    } while (i < refresh.length);
                }
                throw var11_17;
                do {
                    changedBundle = refresh[i];
                    changedBundle.completeStateChange();
                    ++i;
lbl95:
                    // 2 sources

                } while (i < refresh.length);
            }
            if (refreshPackages) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException e) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + e.getMessage());
                        Debug.printStackTrace(e);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), e));
                }
            }
        }
        catch (BundleException e) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + e.getMessage());
                Debug.printStackTrace(e.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.formatter.getString("BUNDLE_REFRESH_FAILURE"), e));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        if (resolved != null) {
            i = 0;
            while (i < resolved.length) {
                this.framework.publishBundleEvent(32, resolved[i]);
                ++i;
            }
        }
        return refresh;
    }

    private void restartFramework() {
        System.getProperties().put("osgi.forcedRestart", "true");
        this.framework.shutdown();
        System.exit(23);
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        AbstractBundle[] bundles = symbolicName == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null || bundles.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> result = new ArrayList<BundleLoaderProxy>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            if (!bundles[i].isFragment() && bundles[i].isResolved() && bundles[i].getSymbolicName() != null) {
                result.add(((BundleHost)bundles[i]).getLoaderProxy());
            }
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new RequiredBundle[result.size()]);
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] bundles = this.framework.getBundleBySymbolicName(symbolicName);
        if (bundles == null) {
            return null;
        }
        if (versionRange == null) {
            Bundle[] result = new AbstractBundle[bundles.length];
            System.arraycopy(bundles, 0, result, 0, result.length);
            return result;
        }
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>(bundles.length);
        VersionRange range = new VersionRange(versionRange);
        int i = 0;
        while (i < bundles.length) {
            if (range.isIncluded(bundles[i].getVersion())) {
                result.add(bundles[i]);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AbstractBundle[result.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleLoaderProxy[] hosts = ((AbstractBundle)bundle).getHosts();
        if (hosts == null) {
            return null;
        }
        Bundle[] result = new Bundle[hosts.length];
        int i = 0;
        while (i < hosts.length) {
            result[i] = hosts[i].getBundleHost();
            ++i;
        }
        return result;
    }

    Bundle getBundlePriv(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleLoader)((BundleClassLoader)((Object)cl)).getDelegate()).bundle;
        }
        if (cl == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PackageAdminImpl.this.getBundlePriv(clazz);
            }
        });
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(SystemBundle systemBundle) {
        try {
            BundleDescription newSystemBundle = this.framework.adaptor.getState().getFactory().createBundleDescription(systemBundle.getHeaders(""), systemBundle.getLocation(), 0L);
            if (newSystemBundle == null) {
                throw new BundleException(Msg.formatter.getString("OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR"));
            }
            State state = this.framework.adaptor.getState();
            BundleDescription oldSystemBundle = state.getBundle(0L);
            if (oldSystemBundle != null) {
                ExportPackageDescription[] newPackages;
                ExportPackageDescription[] oldPackages;
                boolean different = false;
                if (newSystemBundle.getVersion() != null && !newSystemBundle.getVersion().equals(oldSystemBundle.getVersion())) {
                    different = true;
                }
                if ((oldPackages = oldSystemBundle.getExportPackages()).length == (newPackages = newSystemBundle.getExportPackages()).length) {
                    int i = 0;
                    while (i < oldPackages.length) {
                        if (oldPackages[i].getName().equals(newPackages[i].getName())) {
                            Version oldVersion = oldPackages[i].getVersion();
                            Version newVersion = newPackages[i].getVersion();
                            if (oldVersion == null) {
                                if (newVersion != null) {
                                    different = true;
                                    break;
                                }
                            } else if (!((Object)oldVersion).equals(newVersion)) {
                                different = true;
                                break;
                            }
                        } else {
                            different = true;
                            break;
                        }
                        ++i;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    state.removeBundle(0L);
                    state.addBundle(newSystemBundle);
                    state.resolve(false);
                }
            } else {
                state.addBundle(newSystemBundle);
                state.resolve(false);
            }
            SystemBundleLoader.clearSystemPackages();
            ExportPackageDescription[] packages = newSystemBundle.getExportPackages();
            if (packages != null) {
                String[] systemPackages = new String[packages.length];
                int i = 0;
                while (i < packages.length) {
                    String version;
                    ExportPackageDescription spec = packages[i];
                    if (spec.getName().equals("org.osgi.framework") && (version = spec.getVersion().toString()) != null) {
                        System.getProperties().put("org.osgi.framework.version", version);
                    }
                    systemPackages[i] = spec.getName();
                    ++i;
                }
                if (System.getProperty("osgi.autoExportSystemPackages") != null) {
                    SystemBundleLoader.setSystemPackages(systemPackages);
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException(Msg.formatter.getString("OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION", e.getMessage()));
        }
        State state = this.framework.adaptor.getState();
        BundleDescription[] descriptions = state.getBundles();
        int i = 0;
        while (i < descriptions.length) {
            long bundleId = descriptions[i].getBundleId();
            if (bundleId != 0L) {
                this.setResolved(descriptions[i]);
            }
            ++i;
        }
    }
}

