/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.ListenerRegistry;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferences
implements IEclipsePreferences,
IScope {
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    protected static final IEclipsePreferences[] EMPTY_NODE_ARRAY = new IEclipsePreferences[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected static final String VERSION_KEY = "eclipse.preferences.version";
    protected static final String VERSION_VALUE = "1";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY_STRING = "";
    private String cachedPath;
    protected Map children;
    protected boolean dirty = false;
    protected boolean loading = false;
    protected final String name;
    protected final EclipsePreferences parent;
    protected Properties properties;
    protected boolean removed = false;

    public EclipsePreferences() {
        this(null, null);
    }

    protected EclipsePreferences(EclipsePreferences parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String parentPath;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((parentPath = this.parent.absolutePath()).length() == 1 ? String.valueOf(parentPath) + this.name() : String.valueOf(parentPath) + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        if (!visitor.visit(this)) {
            return;
        }
        IEclipsePreferences[] toVisit = this.getChildren(true);
        int i = 0;
        while (i < toVisit.length) {
            toVisit[i].accept(visitor);
            ++i;
        }
    }

    protected synchronized IEclipsePreferences addChild(String childName, IEclipsePreferences child) {
        if (this.children == null) {
            this.children = Collections.synchronizedMap(new HashMap());
        }
        this.children.put(childName, child == null ? childName : child);
        return child;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        this.getNodeChangeListenerRegistry().add(this.absolutePath(), listener);
        if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
            Policy.debug("Added preference node change listener: " + listener + " to: " + this.absolutePath());
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.getPreferenceChangeListenerRegistry().add(this.absolutePath(), listener);
        if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
            Policy.debug("Added preference property change listener: " + listener + " to: " + this.absolutePath());
        }
    }

    protected ListenerRegistry getNodeChangeListenerRegistry() {
        return this.parent.getNodeChangeListenerRegistry();
    }

    protected ListenerRegistry getPreferenceChangeListenerRegistry() {
        return this.parent.getPreferenceChangeListenerRegistry();
    }

    private IEclipsePreferences calculateRoot() {
        IEclipsePreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    protected void checkRemoved() {
        if (this.removed) {
            throw new IllegalStateException(NLS.bind((String)Messages.preferences_removedNode, (Object)this.name));
        }
    }

    public String[] childrenNames() {
        this.checkRemoved();
        return this.internalChildNames();
    }

    protected String[] internalChildNames() {
        Map temp = this.children;
        if (temp == null || temp.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return temp.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.checkRemoved();
        Properties temp = this.properties;
        if (temp == null) {
            return;
        }
        String[] keys = temp.keySet().toArray(EMPTY_STRING_ARRAY);
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            this.properties = null;
        }
        this.makeDirty();
    }

    protected String[] computeChildren(IPath root) {
        if (root == null) {
            return EMPTY_STRING_ARRAY;
        }
        IPath dir = root.append(DEFAULT_PREFERENCES_DIRNAME);
        final ArrayList result = new ArrayList();
        File file = dir.toFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File directory, String child) {
                if (new File(directory, child).isDirectory()) {
                    return false;
                }
                if (child.endsWith(".prefs")) {
                    String shortName = child.substring(0, child.length() - ".prefs".length());
                    result.add(shortName);
                }
                return false;
            }
        };
        file.list(filter);
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    protected IPath computeLocation(IPath root, String qualifier) {
        return root == null ? null : root.append(DEFAULT_PREFERENCES_DIRNAME).append(qualifier).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected void convertFromProperties(Properties table, boolean notify) {
        String version = table.getProperty(VERSION_KEY);
        if (version != null) {
            VERSION_VALUE.equals(version);
        }
        table.remove(VERSION_KEY);
        Iterator<Object> i = table.keySet().iterator();
        while (i.hasNext()) {
            String fullKey = (String)i.next();
            String value = table.getProperty(fullKey);
            if (value == null) continue;
            String[] splitPath = EclipsePreferences.decodePath(fullKey);
            String path = splitPath[0];
            path = EclipsePreferences.makeRelative(path);
            String key = splitPath[1];
            if (InternalPlatform.DEBUG_PREFERENCE_SET) {
                Policy.debug("Setting preference: " + path + '/' + key + '=' + value);
            }
            EclipsePreferences childNode = (EclipsePreferences)this.internalNode(path, false, null);
            String oldValue = childNode.internalPut(key, value);
            if (!notify || value.equals(oldValue)) continue;
            this.firePreferenceEvent(key, oldValue, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties convertToProperties(Properties result, String prefix) throws BackingStoreException {
        boolean addSeparator;
        Properties temp = this.properties;
        boolean bl = addSeparator = prefix.length() != 0;
        if (temp != null) {
            Properties properties = temp;
            synchronized (properties) {
                String[] keys = temp.keySet().toArray(EMPTY_STRING_ARRAY);
                int i = 0;
                while (i < keys.length) {
                    String value = temp.getProperty(keys[i], null);
                    if (value != null) {
                        result.put(EclipsePreferences.encodePath(prefix, keys[i]), value);
                    }
                    ++i;
                }
            }
        }
        IEclipsePreferences[] childNodes = this.getChildren(true);
        int i = 0;
        while (i < childNodes.length) {
            EclipsePreferences child = (EclipsePreferences)childNodes[i];
            String fullPath = addSeparator ? String.valueOf(prefix) + PATH_SEPARATOR + child.name() : child.name();
            child.convertToProperties(result, fullPath);
            ++i;
        }
        return result;
    }

    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName) {
        return this.create((EclipsePreferences)nodeParent, nodeName, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEclipsePreferences create(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        EclipsePreferences result = this.internalCreate(nodeParent, nodeName, context);
        nodeParent.addChild(nodeName, result);
        IEclipsePreferences loadLevel = result.getLoadLevel();
        if (loadLevel == null) {
            return result;
        }
        if (result != loadLevel) {
            return result;
        }
        if (this.isAlreadyLoaded(result)) {
            return result;
        }
        if (this.loading) {
            return result;
        }
        try {
            try {
                this.loading = true;
                result.loadLegacy();
                result.load();
                result.loaded();
                result.flush();
            }
            catch (BackingStoreException e) {
                IPath location = result.getLocation();
                String message = NLS.bind((String)Messages.preferences_loadException, (Object)(location == null ? EMPTY_STRING : location.toString()));
                Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
                InternalPlatform.getDefault().log(status);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.loading = false;
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.loading = false;
            return result;
        }
    }

    public void flush() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences loadLevel = this.getLoadLevel();
        if (loadLevel == null) {
            String[] childrenNames = this.childrenNames();
            int i = 0;
            while (i < childrenNames.length) {
                this.node(childrenNames[i]).flush();
                ++i;
            }
            return;
        }
        if (this != loadLevel) {
            loadLevel.flush();
            return;
        }
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        try {
            this.save();
        }
        catch (BackingStoreException e) {
            this.dirty = true;
            throw e;
        }
    }

    public String get(String key, String defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : Base64.decode(value.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences getChild(String key, Plugin context, boolean create) {
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.children == null) {
                return null;
            }
            Object value = this.children.get(key);
            if (value == null) {
                return null;
            }
            if (value instanceof IEclipsePreferences) {
                return (IEclipsePreferences)value;
            }
            if (!create) {
                return null;
            }
        }
        return this.addChild(key, this.create(this, key, context));
    }

    protected IEclipsePreferences[] getChildren(boolean create) {
        ArrayList<IEclipsePreferences> result = new ArrayList<IEclipsePreferences>();
        String[] names = this.internalChildNames();
        int i = 0;
        while (i < names.length) {
            IEclipsePreferences child = this.getChild(names[i], null, create);
            if (child != null) {
                result.add(child);
            }
            ++i;
        }
        return result.toArray(EMPTY_NODE_ARRAY);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.internalGet(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.internalGet(key);
        float result = defaultValue;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.internalGet(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    protected IEclipsePreferences getLoadLevel() {
        return null;
    }

    protected IPath getLocation() {
        return null;
    }

    public long getLong(String key, long defaultValue) {
        String value = this.internalGet(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new EclipsePreferences(nodeParent, nodeName);
    }

    protected String internalGet(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        Properties temp = this.properties;
        if (temp == null) {
            if (InternalPlatform.DEBUG_PREFERENCE_GET) {
                Policy.debug("Getting preference value: " + this.absolutePath() + '/' + key + "->null");
            }
            return null;
        }
        String result = temp.getProperty(key);
        if (InternalPlatform.DEBUG_PREFERENCE_GET) {
            Policy.debug("Getting preference value: " + this.absolutePath() + '/' + key + "->" + result);
        }
        return result;
    }

    protected IEclipsePreferences internalNode(String path, boolean notify, Plugin context) {
        this.checkRemoved();
        if (path.length() == 0) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return (IEclipsePreferences)this.calculateRoot().node(path.substring(1));
        }
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        boolean added = false;
        IEclipsePreferences child = this.getChild(key, context, true);
        if (child == null) {
            child = this.create(this, key, context);
            added = true;
        }
        if (added && notify) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent(this, child), true);
        }
        return (IEclipsePreferences)child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    protected synchronized String internalPut(String key, String newValue) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String oldValue = this.properties.getProperty(key);
        if (InternalPlatform.DEBUG_PREFERENCE_SET) {
            Policy.debug("Setting preference: " + this.absolutePath() + '/' + key + '=' + newValue);
        }
        this.properties.setProperty(key, newValue);
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemove(String key, String oldValue) {
        boolean wasRemoved = false;
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.properties == null) {
                return;
            }
            boolean bl = wasRemoved = this.properties.remove(key) != null;
            if (this.properties.size() == 0) {
                this.properties = null;
            }
            if (wasRemoved) {
                this.makeDirty();
            }
        }
        if (wasRemoved) {
            this.firePreferenceEvent(key, oldValue, null);
        }
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return true;
    }

    public String[] keys() {
        this.checkRemoved();
        Properties temp = this.properties;
        if (temp == null || temp.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return temp.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    protected void load() throws BackingStoreException {
        this.load(this.getLocation());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load(IPath location) throws BackingStoreException {
        Properties fromDisk;
        block13: {
            if (location == null) {
                if (!InternalPlatform.DEBUG_PREFERENCE_GENERAL) return;
                Policy.debug("Unable to determine location of preference file for node: " + this.absolutePath());
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("Loading preferences from file: " + location);
            }
            BufferedInputStream input = null;
            fromDisk = new Properties();
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(location.toFile()));
                    fromDisk.load(input);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                        Policy.debug("Preference file does not exist: " + location);
                    }
                    Object var6_4 = null;
                    if (input == null) return;
                    try {
                        ((InputStream)input).close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                catch (IOException e) {
                    String message = NLS.bind((String)Messages.preferences_loadException, (Object)location);
                    this.log(new Status(1, "org.eclipse.core.runtime", 1, message, e));
                    throw new BackingStoreException(message);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (input == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                ((InputStream)input).close();
                throw throwable;
                throw throwable;
            }
            {
                Object var6_6 = null;
                if (input == null) break block13;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)input).close();
        }
        this.convertFromProperties(fromDisk, false);
    }

    protected void loaded() {
    }

    protected void loadLegacy() {
    }

    protected void log(IStatus status) {
        InternalPlatform.getDefault().log(status);
    }

    protected void makeDirty() {
        EclipsePreferences node = this;
        while (node != null && !node.removed) {
            node.dirty = true;
            node = (EclipsePreferences)node.parent();
        }
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String pathName) {
        return this.internalNode(pathName, true, null);
    }

    protected void fireNodeEvent(final IEclipsePreferences.NodeChangeEvent event, final boolean added) {
        Object[] listeners = this.getNodeChangeListenerRegistry().getListeners(this.absolutePath());
        int i = 0;
        while (i < listeners.length) {
            final IEclipsePreferences.INodeChangeListener listener = (IEclipsePreferences.INodeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    if (added) {
                        listener.added(event);
                    } else {
                        listener.removed(event);
                    }
                }
            };
            Platform.run(job);
            ++i;
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        if (path.length() == 0) {
            return !this.removed;
        }
        this.checkRemoved();
        if (path.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(path.substring(1));
        }
        int index = path.indexOf(47);
        String childName = index == -1 ? path : path.substring(0, index);
        IEclipsePreferences child = this.getChild(childName, null, true);
        if (child == null) {
            return false;
        }
        return child.nodeExists(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    protected void firePreferenceEvent(String key, Object oldValue, Object newValue) {
        final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent(this, key, oldValue, newValue);
        Object[] listeners = this.getPreferenceChangeListenerRegistry().getListeners(this.absolutePath());
        int i = 0;
        while (i < listeners.length) {
            final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.preferenceChange(event);
                }
            };
            Platform.run(job);
            ++i;
        }
    }

    public void put(String key, String newValue) {
        if (key == null || newValue == null) {
            throw new NullPointerException();
        }
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putBoolean(String key, boolean value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = value ? TRUE : FALSE;
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putByteArray(String key, byte[] value) {
        String oldValue;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        String newValue = new String(Base64.encode(value));
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putDouble(String key, double value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Double.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putFloat(String key, float value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Float.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putInt(String key, int value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Integer.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putLong(String key, long value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Long.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void remove(String key) {
        String oldValue = this.internalGet(key);
        if (oldValue != null) {
            this.internalRemove(key, oldValue);
        }
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
        if (this.parent != null && !(this.parent instanceof RootPreferences)) {
            this.removed = true;
            this.parent.removeNode(this);
        }
        IEclipsePreferences[] childNodes = this.getChildren(false);
        int i2 = 0;
        while (i2 < childNodes.length) {
            try {
                childNodes[i2].removeNode();
            }
            catch (IllegalStateException illegalStateException) {}
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(IEclipsePreferences child) {
        boolean wasRemoved = false;
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.children != null) {
                boolean bl = wasRemoved = this.children.remove(child.name()) != null;
                if (wasRemoved) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }
        if (wasRemoved) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent(this, child), false);
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        this.getNodeChangeListenerRegistry().remove(this.absolutePath(), listener);
        if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
            Policy.debug("Removed preference node change listener: " + listener + " from: " + this.absolutePath());
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        this.getPreferenceChangeListenerRegistry().remove(this.absolutePath(), listener);
        if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
            Policy.debug("Removed preference property change listener: " + listener + " from: " + this.absolutePath());
        }
    }

    protected void save() throws BackingStoreException {
        this.save(this.getLocation());
    }

    /*
     * Exception decompiling
     */
    protected void save(IPath location) throws BackingStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 265->269)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String encodePath(String path, String key) {
        int pathLength;
        int n = pathLength = path == null ? 0 : path.length();
        String result = key.indexOf(47) == -1 ? (pathLength == 0 ? key : String.valueOf(path) + '/' + key) : (pathLength == 0 ? DOUBLE_SLASH + key : String.valueOf(path) + DOUBLE_SLASH + key);
        return result;
    }

    public static String getSegment(String path, int segment) {
        int start = path.indexOf(47) == 0 ? 1 : 0;
        int end = path.indexOf(47, start);
        if (end == path.length() - 1) {
            end = -1;
        }
        int i = 0;
        while (i < segment) {
            if (end == -1) {
                return null;
            }
            start = end + 1;
            end = path.indexOf(47, start);
            ++i;
        }
        if (end == -1) {
            end = path.length();
        }
        return path.substring(start, end);
    }

    public static int getSegmentCount(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf('/'));
        return tokenizer.countTokens();
    }

    public static String makeRelative(String path) {
        String result = path;
        if (path == null) {
            return EMPTY_STRING;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result = path.length() == 0 ? EMPTY_STRING : path.substring(1);
        }
        return result;
    }

    public static String[] decodePath(String fullPath) {
        String key = null;
        String path = null;
        int index = fullPath.indexOf(DOUBLE_SLASH);
        if (index == -1) {
            int lastIndex = fullPath.lastIndexOf(47);
            if (lastIndex == -1) {
                key = fullPath;
            } else {
                path = fullPath.substring(0, lastIndex);
                key = fullPath.substring(lastIndex + 1);
            }
        } else {
            path = fullPath.substring(0, index);
            key = fullPath.substring(index + 2);
        }
        if (path != null) {
            if (path.length() == 0) {
                path = null;
            } else if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        return new String[]{path, key};
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences node = this.getLoadLevel();
        if (node == null) {
            if (InternalPlatform.DEBUG_PREFERENCE_GENERAL) {
                Policy.debug("Preference node is not a load root: " + this.absolutePath());
            }
            return;
        }
        if (node instanceof EclipsePreferences) {
            ((EclipsePreferences)node).load();
            node.flush();
        }
    }

    public String toDeepDebugString() {
        final StringBuffer buffer = new StringBuffer();
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                buffer.append(node);
                buffer.append('\n');
                String[] keys = node.keys();
                int i = 0;
                while (i < keys.length) {
                    buffer.append(node.absolutePath());
                    buffer.append(PATH_SEPARATOR);
                    buffer.append(keys[i]);
                    buffer.append('=');
                    buffer.append(node.get(keys[i], "*default*"));
                    buffer.append('\n');
                    ++i;
                }
                return true;
            }
        };
        try {
            this.accept(visitor);
        }
        catch (BackingStoreException e) {
            System.out.println("Exception while calling #toDeepDebugString()");
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public String toString() {
        return this.absolutePath();
    }
}

