/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.argosdic.dictionary.HistoryListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;

public class SearchHistory {
    private static Log log = LogFactory.getLog(SearchHistory.class);
    private List words;
    private Map documents;
    private int historySize;
    private int currentIndex = 0;
    private ListenerList listeners;
    static /* synthetic */ Class class$0;

    public SearchHistory() {
        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
        preferences.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SearchHistory.this.createMap();
            }
        });
        this.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMap() {
        SearchHistory searchHistory = this;
        synchronized (searchHistory) {
            IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
            int value = preferences.getInt("history.size");
            Assert.isTrue((value > 0 ? 1 : 0) != 0);
            this.historySize = value;
            ArrayList list = new ArrayList(this.historySize);
            HashMap map = new HashMap(this.historySize);
            if (this.words != null) {
                if (this.words.size() > this.historySize) {
                    list.addAll(this.words.subList(0, this.historySize - 1));
                } else {
                    list.addAll(this.words);
                }
                for (String word : list) {
                    map.put(word, this.documents.get(word));
                }
            }
            this.words = list;
            this.documents = map;
        }
    }

    public void add(Document document) {
        String word = document.getField("word").stringValue();
        if (log.isDebugEnabled()) {
            String msg = "Added to search history : " + word;
            log.debug((Object)msg);
        }
        this.words.add(this.currentIndex, word);
        if (this.documents.containsKey(word)) {
            int size = this.words.size();
            int i = 0;
            while (i < size) {
                String value = (String)this.words.get(i);
                if (word.equals(value)) {
                    this.words.remove(i);
                    break;
                }
                ++i;
            }
        } else {
            ++this.currentIndex;
        }
        while (this.currentIndex < this.words.size()) {
            int index = this.words.size() - 1;
            String value = (String)this.words.get(index);
            this.words.remove(index);
            this.documents.remove(value);
        }
        this.documents.put(word, document);
        while (this.words.size() > this.historySize) {
            word = (String)this.words.get(0);
            this.documents.remove(word);
            this.words.remove(0);
            --this.currentIndex;
        }
        this.fireHistoryUpdated();
    }

    public String forward() {
        String word = null;
        if (this.isForwardEnabled()) {
            ++this.currentIndex;
            word = (String)this.words.get(this.currentIndex - 1);
        }
        this.fireHistoryUpdated();
        return word;
    }

    public String back() {
        String word = null;
        if (this.isBackEnabled()) {
            --this.currentIndex;
            word = (String)this.words.get(this.currentIndex - 1);
        }
        this.fireHistoryUpdated();
        return word;
    }

    public String go(int index) {
        String word = null;
        if (index >= 0 && index < this.words.size()) {
            this.currentIndex = index + 1;
            word = (String)this.words.get(index);
            this.fireHistoryUpdated();
        }
        return word;
    }

    public boolean isBackEnabled() {
        return this.currentIndex > 1;
    }

    public boolean isForwardEnabled() {
        return this.currentIndex < this.words.size();
    }

    public Document get(String word) {
        Assert.isNotNull((Object)word);
        return (Document)this.documents.get(word);
    }

    public int getSize() {
        return this.words.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBackwardHistory() {
        List list = null;
        List list2 = this.words;
        synchronized (list2) {
            if (this.words.size() > 0) {
                list = this.words.subList(0, this.currentIndex - 1);
                list = new ArrayList(list);
                Collections.reverse(list);
            } else {
                list = new ArrayList(0);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getForwardHistory() {
        List list = null;
        List list2 = this.words;
        synchronized (list2) {
            if (this.words.size() > 0) {
                list = this.words.subList(this.currentIndex, this.words.size());
                list = new ArrayList(list);
            } else {
                list = new ArrayList(0);
            }
        }
        return list;
    }

    public int getCurrentIndex() {
        return this.currentIndex - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SearchHistory searchHistory = this;
        synchronized (searchHistory) {
            this.currentIndex = 0;
            this.words.clear();
            this.documents.clear();
        }
        this.fireHistoryUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryListener(HistoryListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.listeners == null) {
            SearchHistory searchHistory = this;
            synchronized (searchHistory) {
                this.listeners = new ListenerList(30);
            }
        }
        this.listeners.add((Object)listener);
    }

    public void removeHistoryListener(HistoryListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHistoryUpdated() {
        if (this.listeners != null) {
            Object[] array = null;
            ListenerList listenerList = this.listeners;
            synchronized (listenerList) {
                array = this.listeners.getListeners();
            }
            Event event = new Event();
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    HistoryListener listener = (HistoryListener)array[i];
                    listener.historyUpdated(event);
                    ++i;
                }
            }
        }
    }
}

