/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XButtonEvent;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.internal.gtk.XVisibilityEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int gdkEventCount;
    int[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    int fds;
    int allocated_nfds;
    boolean wake;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    Callback filterCallback;
    GdkEventButton gdkEvent = new GdkEventButton();
    int eventProc;
    int filterProc;
    int windowProc2;
    int windowProc3;
    int windowProc4;
    int windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    int freeSlot;
    int[] indexTable;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    int focusEvent;
    Control focusControl;
    Control imControl;
    int preeditWindow;
    int preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    int caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    int mouseHoverHandle;
    int mouseHoverProc;
    Callback mouseHoverCallback;
    int menuPositionProc;
    Callback menuPositionCallback;
    int shellMapProc;
    Callback shellMapCallback;
    int[] treeSelection;
    int treeSelectionLength;
    int treeSelectionProc;
    Callback treeSelectionCallback;
    int textCellDataProc;
    Callback textCellDataCallback;
    int pixbufCellDataProc;
    Callback pixbufCellDataCallback;
    int checkIfEventProc;
    Callback checkIfEventCallback;
    int flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    XVisibilityEvent visibilityEvent = new XVisibilityEvent();
    int[] flushData = new int[1];
    int dragStartX;
    int dragStartY;
    boolean dragging;
    int defaultFont;
    int errorPixmap;
    int infoPixmap;
    int questionPixmap;
    int warningPixmap;
    int errorMask;
    int infoMask;
    int questionMask;
    int warningMask;
    Cursor[] cursors = new Cursor[22];
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Menu[] popups;
    int lastEventTime;
    static int fixed_type;
    static int fixed_info_ptr;
    static Callback fixedClassInitCallback;
    static Callback fixedMapCallback;
    static int fixedClassInitProc;
    static int fixedMapProc;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final Class OS_LOCK;
    static final int MAJOR = 2;
    static final int MINOR = 0;
    static final int MICRO = 6;
    Object data;
    String[] keys;
    Object[] values;
    int borderTrimWidth = 4;
    int borderTrimHeight = 4;
    int resizeTrimWidth = 6;
    int resizeTrimHeight = 6;
    int titleBorderTrimWidth = 5;
    int titleBorderTrimHeight = 28;
    int titleResizeTrimWidth = 6;
    int titleResizeTrimHeight = 29;
    int titleTrimWidth = 0;
    int titleTrimHeight = 23;

    static {
        byte[] buffer = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string((byte[])buffer);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[4];
        Class<?> lock = null;
        try {
            lock = Class.forName("org.eclipse.swt.internal.gtk.OS");
        }
        catch (Throwable throwable) {}
        OS_LOCK = lock;
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addGdkEvent(int event) {
        int length;
        if (this.gdkEvents == null) {
            length = 1024;
            this.gdkEvents = new int[length];
            this.gdkEventWidgets = new Widget[length];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            length = this.gdkEventCount + 1024;
            int[] newEvents = new int[length];
            System.arraycopy(this.gdkEvents, 0, newEvents, 0, this.gdkEventCount);
            this.gdkEvents = newEvents;
            Widget[] newWidgets = new Widget[length];
            System.arraycopy(this.gdkEventWidgets, 0, newWidgets, 0, this.gdkEventCount);
            this.gdkEventWidgets = newWidgets;
        }
        Widget widget = null;
        int handle = OS.gtk_get_event_widget((int)event);
        if (handle != 0) {
            while ((widget = this.getWidget(handle)) == null && (handle = OS.gtk_widget_get_parent((int)handle)) != 0) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = event;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMouseHoverTimeout(int handle) {
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove((int)this.mouseHoverId);
        }
        this.mouseHoverId = OS.gtk_timeout_add((int)400, (int)this.mouseHoverProc, (int)handle);
        this.mouseHoverHandle = handle;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        int index = this.freeSlot + 1;
        OS.g_object_set_qdata((int)handle, (int)SWT_OBJECT_INDEX, (int)index);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.gdk_beep();
        OS.gdk_flush();
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null && Display.Displays[i].thread == thread) {
                SWT.error(22);
            }
            ++i;
        }
    }

    int checkIfEventProc(int display, int xEvent, int userData) {
        OS.memmove((XExposeEvent)this.exposeEvent, (int)xEvent, (int)XExposeEvent.sizeof);
        switch (this.exposeEvent.type) {
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            default: {
                return 0;
            }
        }
        int window = OS.gdk_window_lookup((int)this.exposeEvent.window);
        if (window == 0) {
            return 0;
        }
        if (this.flushWindow != 0) {
            if (this.flushAll) {
                int tempWindow = window;
                while (tempWindow != this.flushWindow && (tempWindow = OS.gdk_window_get_parent((int)tempWindow)) != 0) {
                }
                if (tempWindow != this.flushWindow) {
                    return 0;
                }
            } else if (window != this.flushWindow) {
                return 0;
            }
        }
        switch (this.exposeEvent.type) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = this.exposeEvent.width;
                this.flushRect.height = this.exposeEvent.height;
                OS.gdk_window_invalidate_rect((int)window, (GdkRectangle)this.flushRect, (boolean)true);
                this.exposeEvent.type = -1;
                OS.memmove((int)xEvent, (XExposeEvent)this.exposeEvent, (int)XExposeEvent.sizeof);
                break;
            }
            case 15: {
                Control control;
                Widget widget;
                OS.memmove((XVisibilityEvent)this.visibilityEvent, (int)xEvent, (int)XVisibilityEvent.sizeof);
                OS.gdk_window_get_user_data((int)window, (int[])this.flushData);
                int handle = this.flushData[0];
                Widget widget2 = widget = handle != 0 ? this.getWidget(handle) : null;
                if (widget == null || !(widget instanceof Control) || window != (control = (Control)widget).paintWindow()) break;
                if (this.visibilityEvent.state == 2) {
                    control.state |= 0x40;
                    break;
                }
                control.state &= 0xFFFFFFBF;
            }
        }
        return 0;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(data);
        this.register();
        if (Default == null) {
            Default = this;
        }
    }

    synchronized void createDisplay(DeviceData data) {
        int ptr;
        if (!OS.g_thread_supported()) {
            OS.g_thread_init((int)0);
        }
        OS.gtk_set_locale();
        if (!OS.gtk_init_check((int[])new int[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        if ((ptr = OS.gtk_check_version((int)2, (int)0, (int)6)) != 0) {
            int length = OS.strlen((int)ptr);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)ptr, (int)length);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(null, buffer)));
            System.out.println("***WARNING: SWT requires GTK 2.0.6");
            int major = OS.gtk_major_version();
            int minor = OS.gtk_minor_version();
            int micro = OS.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + major + "." + minor + "." + micro);
        }
        if (fixed_type == 0) {
            byte[] type_name = Converter.wcsToMbcs(null, "SwtFixed", true);
            fixedClassInitCallback = new Callback(this.getClass(), "fixedClassInitProc", 2);
            fixedClassInitProc = fixedClassInitCallback.getAddress();
            if (fixedClassInitProc == 0) {
                SWT.error(3);
            }
            if ((fixedMapProc = (fixedMapCallback = new Callback(this.getClass(), "fixedMapProc", 1)).getAddress()) == 0) {
                SWT.error(3);
            }
            GTypeInfo fixed_info = new GTypeInfo();
            fixed_info.class_size = (short)OS.GtkFixedClass_sizeof();
            fixed_info.class_init = fixedClassInitProc;
            fixed_info.instance_size = (short)OS.GtkFixed_sizeof();
            fixed_info_ptr = OS.g_malloc((int)GTypeInfo.sizeof);
            OS.memmove((int)fixed_info_ptr, (GTypeInfo)fixed_info, (int)GTypeInfo.sizeof);
            fixed_type = OS.g_type_register_static((int)OS.GTK_TYPE_FIXED(), (byte[])type_name, (int)fixed_info_ptr, (int)0);
        }
        OS.gtk_widget_set_default_direction((int)1);
        OS.gdk_rgb_init();
        byte[] buffer = Converter.wcsToMbcs(null, APP_NAME, true);
        OS.gdk_set_program_class((byte[])buffer);
        byte[] flatStyle = Converter.wcsToMbcs(null, "style \"swt-flat\" { GtkToolbar::shadow-type = none } widget \"*swt-toolbar-flat*\" style : highest \"swt-flat\"", true);
        OS.gtk_rc_parse_string((byte[])flatStyle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0) {
            SWT.error(3);
        }
        OS.gdk_event_handler_set((int)this.eventProc, (int)0, (int)0);
        this.filterCallback = new Callback(this, "filterProc", 3);
        this.filterProc = this.filterCallback.getAddress();
        if (this.filterProc == 0) {
            this.error(3);
        }
        OS.gdk_window_add_filter((int)0, (int)this.filterProc, (int)0);
    }

    int[] createImage(String name) {
        int style = OS.gtk_widget_get_default_style();
        byte[] buffer = Converter.wcsToMbcs(null, name, true);
        int pixbuf = OS.gtk_icon_set_render_icon((int)OS.gtk_icon_factory_lookup_default((byte[])buffer), (int)style, (int)0, (int)0, (int)6, (int)0, (int)0);
        if (pixbuf == 0) {
            return null;
        }
        int[] pixmap_return = new int[1];
        int[] mask_return = new int[1];
        OS.gdk_pixbuf_render_pixmap_and_mask((int)pixbuf, (int[])pixmap_return, (int[])mask_return, (int)128);
        OS.g_object_unref((int)pixbuf);
        return new int[]{pixmap_return[0], mask_return[0]};
    }

    synchronized void deregister() {
        int i = 0;
        while (i < Displays.length) {
            if (this == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        this.deregister();
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    int eventProc(int event, int data) {
        OS.memmove((GdkEventButton)this.gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        boolean dispatch = true;
        if (this.dispatchEvents != null) {
            dispatch = false;
            int i = 0;
            while (i < this.dispatchEvents.length) {
                if (this.gdkEvent.type == this.dispatchEvents[i]) {
                    dispatch = true;
                    break;
                }
                ++i;
            }
        }
        if (!dispatch) {
            this.addGdkEvent(OS.gdk_event_copy((int)event));
            return 0;
        }
        int time = OS.gdk_event_get_time((int)event);
        if (time != 0) {
            this.lastEventTime = time;
        }
        Control control = null;
        int window = 0;
        block0 : switch (this.gdkEvent.type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                window = this.gdkEvent.window;
                int[] user_data = new int[1];
                do {
                    Widget widget;
                    OS.gdk_window_get_user_data((int)window, (int[])user_data);
                    int handle = user_data[0];
                    if (handle == 0 || (widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
                    control = (Control)widget;
                    break block0;
                } while ((window = OS.gdk_window_get_parent((int)window)) != 0);
            }
        }
        Shell shell = null;
        if (control != null) {
            shell = control.getShell();
            if ((shell.style & 0x4000) != 0) {
                OS.gtk_grab_add((int)shell.shellHandle);
            }
        }
        OS.gtk_main_do_event((int)event);
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        if (control != null && shell != null && !shell.isDisposed() && (shell.style & 0x4000) != 0) {
            OS.gtk_grab_remove((int)shell.shellHandle);
        }
        return 0;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id) {
        return null;
    }

    static int fixedClassInitProc(int g_class, int class_data) {
        GtkWidgetClass klass = new GtkWidgetClass();
        OS.memmove((GtkWidgetClass)klass, (int)g_class);
        klass.map = fixedMapProc;
        OS.memmove((int)g_class, (GtkWidgetClass)klass);
        return 0;
    }

    static int fixedMapProc(int handle) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.fixedMapProc(handle);
        }
        return 0;
    }

    void flushExposes(int window, boolean all) {
        OS.gdk_flush();
        OS.gdk_flush();
        if (OS.GDK_WINDOWING_X11()) {
            this.flushWindow = window;
            this.flushAll = all;
            int xDisplay = OS.GDK_DISPLAY();
            int xEvent = OS.g_malloc((int)XEvent.sizeof);
            OS.XCheckIfEvent((int)xDisplay, (int)xEvent, (int)this.checkIfEventProc, (int)0);
            OS.g_free((int)xEvent);
            this.flushWindow = 0;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                Shell shell = (Shell)widget;
                if (shell.hasFocus) {
                    return shell;
                }
            }
            ++i;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.gdk_screen_width(), OS.gdk_screen_height());
    }

    public static synchronized Display getCurrent() {
        Thread current = Thread.currentThread();
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == current) {
                return display;
            }
            ++i;
        }
        return null;
    }

    int getCaretBlinkTime() {
        int settings = OS.gtk_settings_get_default();
        if (settings == 0) {
            return 500;
        }
        int[] buffer = new int[1];
        OS.g_object_get((int)settings, (byte[])OS.gtk_cursor_blink_time, (int[])buffer, (int)0);
        if (buffer[0] == 0) {
            return 500;
        }
        return buffer[0] / 2;
    }

    public Control getCursorControl() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        int window = OS.gdk_window_at_pointer((int[])x, (int[])y);
        if (window == 0) {
            return null;
        }
        int[] user_data = new int[1];
        OS.gdk_window_get_user_data((int)window, (int[])user_data);
        int handle = user_data[0];
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) continue;
            return control;
        } while ((handle = OS.gtk_widget_get_parent((int)handle)) != 0);
        return null;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    int filterProc(int xEvent, int gdkEvent, int data) {
        if (data == 0) {
            XButtonEvent mouseEvent = new XButtonEvent();
            OS.memmove((XButtonEvent)mouseEvent, (int)xEvent, (int)4);
            if (mouseEvent.type == 5) {
                OS.memmove((XButtonEvent)mouseEvent, (int)xEvent, (int)XButtonEvent.sizeof);
                switch (mouseEvent.button) {
                    case 6: 
                    case 7: {
                        mouseEvent.button = -mouseEvent.button;
                        OS.memmove((int)xEvent, (XButtonEvent)mouseEvent, (int)XButtonEvent.sizeof);
                    }
                }
            }
            return 0;
        }
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.filterProc(xEvent, gdkEvent, data);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        return new Point(x[0], y[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public Point getDPI() {
        this.checkDevice();
        int widthMM = OS.gdk_screen_width_mm();
        int width = OS.gdk_screen_width();
        int dpi = Compatibility.round(254 * width, widthMM * 10);
        return new Point(dpi, dpi);
    }

    int gtk_fixed_get_type() {
        return fixed_type;
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        int settings = OS.gtk_settings_get_default();
        int[] buffer = new int[1];
        OS.g_object_get((int)settings, (byte[])OS.gtk_double_click_time, (int[])buffer, (int)0);
        return buffer[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        Shell shell = this.getActiveShell();
        if (shell == null) {
            return null;
        }
        int shellHandle = shell.shellHandle;
        int handle = OS.gtk_window_get_focus((int)shellHandle);
        if (handle == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((handle = OS.gtk_widget_get_parent((int)handle)) != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getDepth() {
        this.checkDevice();
        GdkVisual visual = new GdkVisual();
        OS.memmove((GdkVisual)visual, (int)OS.gdk_visual_get_system());
        return visual.depth;
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    int getLastEventTime() {
        int time = OS.gtk_get_current_event_time();
        return time != 0 ? time : this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        int monitorCount;
        this.checkDevice();
        Monitor[] monitors = null;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0 && (monitorCount = OS.gdk_screen_get_n_monitors((int)screen)) > 0) {
            monitors = new Monitor[monitorCount];
            GdkRectangle dest = new GdkRectangle();
            int i = 0;
            while (i < monitorCount) {
                OS.gdk_screen_get_monitor_geometry((int)screen, (int)i, (GdkRectangle)dest);
                Monitor monitor = new Monitor();
                monitor.handle = i;
                monitor.x = dest.x;
                monitor.y = dest.y;
                monitor.width = dest.width;
                monitor.height = dest.height;
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
                monitors[i] = monitor;
                ++i;
            }
        }
        if (monitors == null) {
            Monitor monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
            monitors = new Monitor[]{monitor};
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitors = this.getMonitors();
        return monitors[0];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                int j = 0;
                while (j < index) {
                    if (result[j] == widget) break;
                    ++j;
                }
                if (j == index) {
                    if (index == result.length) {
                        Shell[] newResult = new Shell[index + 16];
                        System.arraycopy(result, 0, newResult, 0, index);
                        result = newResult;
                    }
                    result[index++] = (Shell)widget;
                }
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        GdkColor gdkColor = null;
        switch (id) {
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkColor);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        int imagePixmap = 0;
        int imageMask = 0;
        switch (id) {
            case 1: {
                int[] image;
                if (this.errorPixmap == 0 && (image = this.createImage("gtk-dialog-error")) != null) {
                    this.errorPixmap = image[0];
                    this.errorMask = image[1];
                }
                imagePixmap = this.errorPixmap;
                imageMask = this.errorMask;
                break;
            }
            case 2: 
            case 16: {
                int[] image;
                if (this.infoPixmap == 0 && (image = this.createImage("gtk-dialog-info")) != null) {
                    this.infoPixmap = image[0];
                    this.infoMask = image[1];
                }
                imagePixmap = this.infoPixmap;
                imageMask = this.infoMask;
                break;
            }
            case 4: {
                int[] image;
                if (this.questionPixmap == 0 && (image = this.createImage("gtk-dialog-question")) != null) {
                    this.questionPixmap = image[0];
                    this.questionMask = image[1];
                }
                imagePixmap = this.questionPixmap;
                imageMask = this.questionMask;
                break;
            }
            case 8: {
                int[] image;
                if (this.warningPixmap == 0 && (image = this.createImage("gtk-dialog-warning")) != null) {
                    this.warningPixmap = image[0];
                    this.warningMask = image[1];
                }
                imagePixmap = this.warningPixmap;
                imageMask = this.warningMask;
            }
        }
        if (imagePixmap == 0) {
            return null;
        }
        return Image.gtk_new(this, 1, imagePixmap, imageMask);
    }

    void initializeSystemResources() {
        int shellHandle = OS.gtk_window_new((int)0);
        if (shellHandle == 0) {
            SWT.error(2);
        }
        OS.gtk_widget_realize((int)shellHandle);
        int tooltipShellHandle = OS.gtk_window_new((int)1);
        if (tooltipShellHandle == 0) {
            SWT.error(2);
        }
        byte[] gtk_tooltips = Converter.wcsToMbcs(null, "gtk-tooltips", true);
        OS.gtk_widget_set_name((int)tooltipShellHandle, (byte[])gtk_tooltips);
        OS.gtk_widget_realize((int)tooltipShellHandle);
        int style = OS.gtk_widget_get_style((int)shellHandle);
        int tooltipStyle = OS.gtk_widget_get_style((int)tooltipShellHandle);
        this.defaultFont = OS.pango_font_description_copy((int)OS.gtk_style_get_font_desc((int)style));
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_black((int)style, (GdkColor)gdkColor);
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_dark((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base((int)style, (int)0, (GdkColor)gdkColor);
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text((int)style, (int)3, (GdkColor)gdkColor);
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base((int)style, (int)3, (GdkColor)gdkColor);
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg((int)tooltipStyle, (int)0, (GdkColor)gdkColor);
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg((int)tooltipStyle, (int)0, (GdkColor)gdkColor);
        this.COLOR_INFO_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg((int)style, (int)3, (GdkColor)gdkColor);
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg((int)style, (int)3, (GdkColor)gdkColor);
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light((int)style, (int)3, (GdkColor)gdkColor);
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg((int)style, (int)4, (GdkColor)gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg((int)style, (int)4, (GdkColor)gdkColor);
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light((int)style, (int)4, (GdkColor)gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
        OS.gtk_widget_destroy((int)tooltipShellHandle);
        OS.gtk_widget_destroy((int)shellHandle);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return Font.gtk_new(this, this.defaultFont);
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    Widget getWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        int index = OS.g_object_get_qdata((int)handle, (int)SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            return this.widgetTable[index];
        }
        return null;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSystemResources();
        this.initializeWidgetTable();
    }

    void initializeCallbacks() {
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0) {
            SWT.error(3);
        }
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0) {
            SWT.error(3);
        }
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0) {
            SWT.error(3);
        }
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0) {
            SWT.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.menuPositionCallback = new Callback(this, "menuPositionProc", 5);
        this.menuPositionProc = this.menuPositionCallback.getAddress();
        if (this.menuPositionProc == 0) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0) {
            this.error(3);
        }
        this.treeSelectionCallback = new Callback(this, "treeSelectionProc", 4);
        this.treeSelectionProc = this.treeSelectionCallback.getAddress();
        if (this.treeSelectionProc == 0) {
            this.error(3);
        }
        this.textCellDataCallback = new Callback(this, "textCellDataProc", 5);
        this.textCellDataProc = this.textCellDataCallback.getAddress();
        if (this.textCellDataProc == 0) {
            this.error(3);
        }
        this.pixbufCellDataCallback = new Callback(this, "pixbufCellDataProc", 5);
        this.pixbufCellDataProc = this.pixbufCellDataCallback.getAddress();
        if (this.pixbufCellDataProc == 0) {
            this.error(3);
        }
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        if (this.checkIfEventProc == 0) {
            this.error(3);
        }
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        OS.g_object_unref((int)gdkGC);
    }

    public int internal_new_GC(GCData data) {
        int root;
        int gdkGC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((gdkGC = OS.gdk_gc_new((int)(root = OS.GDK_ROOT_PARENT()))) == 0) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow((int)gdkGC, (int)1);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = root;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.defaultFont;
        }
        return gdkGC;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        int[] origin_y;
        int[] origin_x;
        int window;
        int eventHandle;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from != null) {
            eventHandle = from.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            point.x += origin_x[0];
            point.y += origin_y[0];
        }
        if (to != null) {
            eventHandle = to.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            point.x -= origin_x[0];
            point.y -= origin_y[0];
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static char mbcsToWcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = key <= 255 ? new byte[]{(byte)key} : new byte[]{(byte)(key >> 8 & 0xFF), (byte)(key & 0xFF)};
        char[] result = Converter.mbcsToWcs(null, buffer);
        if (result.length == 0) {
            return '\u0000';
        }
        return result[0];
    }

    int menuPositionProc(int menu, int x, int y, int push_in, int user_data) {
        Widget widget = this.getWidget(menu);
        if (widget == null) {
            return 0;
        }
        return widget.menuPositionProc(menu, x, y, push_in, user_data);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        int[] origin_y;
        int[] origin_x;
        int window;
        int eventHandle;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from != null) {
            eventHandle = from.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            rect.x += origin_x[0];
            rect.y += origin_y[0];
        }
        if (to != null) {
            eventHandle = to.eventHandle();
            OS.gtk_widget_realize((int)eventHandle);
            window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
            rect.x -= origin_x[0];
            rect.y -= origin_y[0];
        }
        return rect;
    }

    int mouseHoverProc(int handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(handle);
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        if (!OS.GDK_WINDOWING_X11()) {
            return false;
        }
        int xDisplay = OS.GDK_DISPLAY();
        int type = event.type;
        switch (type) {
            case 1: 
            case 2: {
                int keyCode = 0;
                int keysym = Display.untranslateKey(event.keyCode);
                if (keysym != 0) {
                    keyCode = OS.XKeysymToKeycode((int)xDisplay, (int)keysym);
                }
                if (keyCode == 0) {
                    char key = event.character;
                    switch (key) {
                        case '\b': {
                            keysym = 65288;
                            break;
                        }
                        case '\r': {
                            keysym = 65293;
                            break;
                        }
                        case '\u007f': {
                            keysym = 65535;
                            break;
                        }
                        case '\u001b': {
                            keysym = 65307;
                            break;
                        }
                        case '\t': {
                            keysym = 65289;
                            break;
                        }
                        case '\n': {
                            keysym = 65290;
                            break;
                        }
                        default: {
                            keysym = Display.wcsToMbcs(key);
                        }
                    }
                    keyCode = OS.XKeysymToKeycode((int)xDisplay, (int)keysym);
                    if (keyCode == 0) {
                        return false;
                    }
                }
                OS.XTestFakeKeyEvent((int)xDisplay, (int)keyCode, (type == 1 ? 1 : 0) != 0, (int)0);
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                if (type == 5) {
                    OS.XTestFakeMotionEvent((int)xDisplay, (int)-1, (int)event.x, (int)event.y, (int)0);
                } else {
                    int button = event.button;
                    if (button < 1 || button > 3) {
                        return false;
                    }
                    OS.XTestFakeButtonEvent((int)xDisplay, (int)button, (type == 3 ? 1 : 0) != 0, (int)0);
                }
                return true;
            }
        }
        return false;
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            int i = 0;
            while (i < this.gdkEventCount) {
                int event = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    OS.gdk_event_put((int)event);
                }
                OS.gdk_event_free((int)event);
                this.gdkEvents[i] = 0;
                this.gdkEventWidgets[i] = null;
                ++i;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        boolean events = this.runPopups();
        if (events |= OS.g_main_context_iteration((int)0, (boolean)false)) {
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages(false);
    }

    synchronized void register() {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = this;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = this;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int i;
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        this.filterCallback.dispose();
        this.filterCallback = null;
        this.filterProc = 0;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0;
        if (this.preeditWindow != 0) {
            OS.gtk_widget_destroy((int)this.preeditWindow);
        }
        this.imControl = null;
        this.menuPositionCallback.dispose();
        this.menuPositionCallback = null;
        this.menuPositionProc = 0;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0;
        this.treeSelectionCallback.dispose();
        this.treeSelectionCallback = null;
        this.treeSelectionProc = 0;
        this.textCellDataCallback.dispose();
        this.textCellDataCallback = null;
        this.textCellDataProc = 0;
        this.pixbufCellDataCallback.dispose();
        this.pixbufCellDataCallback = null;
        this.pixbufCellDataProc = 0;
        if (this.caretId != 0) {
            OS.gtk_timeout_remove((int)this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        if (this.timerIds != null) {
            i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.gtk_timeout_remove((int)this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove((int)this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        this.thread = null;
        this.windowProc5 = 0;
        this.windowProc4 = 0;
        this.windowProc3 = 0;
        this.windowProc2 = 0;
        if (this.defaultFont != 0) {
            OS.pango_font_description_free((int)this.defaultFont);
        }
        this.defaultFont = 0;
        if (this.errorPixmap != 0) {
            OS.g_object_unref((int)this.errorPixmap);
            OS.g_object_unref((int)this.errorMask);
        }
        if (this.infoPixmap != 0) {
            OS.g_object_unref((int)this.infoPixmap);
            OS.g_object_unref((int)this.infoMask);
        }
        if (this.questionPixmap != 0) {
            OS.g_object_unref((int)this.questionPixmap);
            OS.g_object_unref((int)this.questionMask);
        }
        if (this.warningPixmap != 0) {
            OS.g_object_unref((int)this.warningPixmap);
            OS.g_object_unref((int)this.warningMask);
        }
        this.warningPixmap = 0;
        this.questionPixmap = 0;
        this.infoPixmap = 0;
        this.errorPixmap = 0;
        this.warningMask = 0;
        this.questionMask = 0;
        this.infoMask = 0;
        this.errorMask = 0;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0) {
            OS.g_free((int)this.fds);
        }
        this.fds = 0;
        OS.gdk_event_handler_set((int)0, (int)0, (int)0);
        this.eventCallback.dispose();
        this.eventCallback = null;
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    int removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0;
        }
        int event = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return event;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMouseHoverTimeout(int handle) {
        if (handle != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove((int)this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        Widget widget = null;
        int index = OS.g_object_get_qdata((int)handle, (int)SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.g_object_set_qdata((int)handle, (int)SWT_OBJECT_INDEX, (int)0);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            menu._setVisible(true);
            result = true;
        }
        this.popups = null;
        return result;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        if (OS.GDK_WINDOWING_X11()) {
            int xDisplay = OS.GDK_DISPLAY();
            int xWindow = OS.XDefaultRootWindow((int)xDisplay);
            OS.XWarpPointer((int)xDisplay, (int)0, (int)xWindow, (int)0, (int)0, (int)0, (int)0, (int)x, (int)y);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY) && (value == null || value instanceof int[])) {
            this.dispatchEvents = (int[])value;
            if (value == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages(true);
        }
        this.synchronizer = synchronizer;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0) {
            this.preeditWindow = OS.gtk_window_new((int)1);
            if (this.preeditWindow == 0) {
                this.error(2);
            }
            this.preeditLabel = OS.gtk_label_new(null);
            if (this.preeditLabel == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)this.preeditWindow, (int)this.preeditLabel);
            OS.gtk_widget_show((int)this.preeditLabel);
        }
        int[] preeditString = new int[1];
        int[] pangoAttrs = new int[1];
        int imHandle = control.imHandle();
        OS.gtk_im_context_get_preedit_string((int)imHandle, (int[])preeditString, (int[])pangoAttrs, null);
        if (preeditString[0] != 0 && OS.strlen((int)preeditString[0]) > 0) {
            OS.gtk_widget_modify_bg((int)this.preeditWindow, (int)0, (GdkColor)control.getBackgroundColor());
            OS.gtk_widget_modify_fg((int)this.preeditLabel, (int)0, (GdkColor)control.getForegroundColor());
            OS.gtk_widget_modify_font((int)this.preeditLabel, (int)control.getFontDescription());
            if (pangoAttrs[0] != 0) {
                OS.gtk_label_set_attributes((int)this.preeditLabel, (int)pangoAttrs[0]);
            }
            OS.gtk_label_set_text((int)this.preeditLabel, (int)preeditString[0]);
            Point point = control.toDisplay(control.getIMCaretPos());
            OS.gtk_window_move((int)this.preeditWindow, (int)point.x, (int)point.y);
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)this.preeditLabel, (GtkRequisition)requisition);
            OS.gtk_window_resize((int)this.preeditWindow, (int)requisition.width, (int)requisition.height);
            OS.gtk_widget_show((int)this.preeditWindow);
        } else {
            OS.gtk_widget_hide((int)this.preeditWindow);
        }
        if (preeditString[0] != 0) {
            OS.g_free((int)preeditString[0]);
        }
        if (pangoAttrs[0] != 0) {
            OS.pango_attr_list_unref((int)pangoAttrs[0]);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.getMessageCount() != 0) {
            return true;
        }
        if (this.fds == 0) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc((int)(OS.GPollFD_sizeof() * this.allocated_nfds));
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        context = OS.g_main_context_default();
        result = false;
        do {
            block16: {
                if (!OS.g_main_context_acquire((int)context)) continue;
                result = OS.g_main_context_prepare((int)context, (int[])this.max_priority);
                while (true) {
                    if ((nfds = OS.g_main_context_query((int)context, (int)this.max_priority[0], (int[])this.timeout, (int)this.fds, (int)this.allocated_nfds)) <= this.allocated_nfds) {
                        poll = OS.g_main_context_get_poll_func((int)context);
                        if (poll == 0 || nfds <= 0 && this.timeout[0] == 0) break block16;
                        if (this.timeout[0] < 0) {
                            this.timeout[0] = 50;
                        }
                        break;
                    }
                    OS.g_free((int)this.fds);
                    this.allocated_nfds = nfds;
                    this.fds = OS.g_malloc((int)(OS.GPollFD_sizeof() * this.allocated_nfds));
                }
                lock = OS.lock;
                count = lock.lock();
                i = 0;
                while (true) {
                    if (i >= count) {
                        ** try [egrp 0[TRYBLOCK] [0 : 228->253)] { 
lbl35:
                        // 1 sources

                        break;
                    }
                    lock.unlock();
                    ++i;
                }
                {
                    this.wake = false;
                    OS.Call((int)poll, (int)this.fds, (int)nfds, (int)this.timeout[0]);
                    ** GOTO lbl-1000
                }
lbl43:
                // 1 sources

                catch (Throwable var8_11) {
                    var7_9 = null;
                    i = 0;
                }
                while (true) {
                    if (i >= count) {
                        lock.unlock();
                        throw var8_11;
                    }
                    lock.lock();
                    ++i;
                }
lbl-1000:
                // 1 sources

                {
                    var7_7 = null;
                    i = 0;
                }
                while (true) {
                    if (i >= count) {
                        lock.unlock();
                        break;
                    }
                    lock.lock();
                    ++i;
                }
            }
            OS.g_main_context_check((int)context, (int)this.max_priority[0], (int)this.fds, (int)nfds);
            OS.g_main_context_release((int)context);
        } while (!result && this.getMessageCount() == 0 && !this.wake);
        this.wake = false;
        return true;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.gtk_timeout_remove((int)this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = OS.gtk_timeout_add((int)milliseconds, (int)this.timerProc, (int)index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int i) {
        if (this.timerList == null) {
            return 0;
        }
        int index = i;
        if (index >= 0 && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    int caretProc(int clientData) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            this.caretId = OS.gtk_timeout_add((int)blinkRate, (int)this.caretProc, (int)0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int pixbufCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.pixbufCellDataProc(tree_column, cell, tree_model, iter, data);
    }

    int textCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.textCellDataProc(tree_column, cell, tree_model, iter, data);
    }

    int treeSelectionProc(int model, int path, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.treeSelectionProc(model, path, iter, this.treeSelection, this.treeSelectionLength++);
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.gtk_timeout_remove((int)this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int blinkRate = this.currentCaret.blinkRate;
        this.caretId = OS.gtk_timeout_add((int)blinkRate, (int)this.caretProc, (int)0);
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.shellMapProc(handle, arg0, user_data);
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0, true);
        OS.gdk_window_process_all_updates();
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        this.wakeThread();
    }

    void wakeThread() {
        OS.g_main_context_wakeup((int)0);
        this.wake = true;
    }

    static char wcsToMbcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = Converter.wcsToMbcs(null, new char[]{ch}, false);
        if (buffer.length == 1) {
            return (char)buffer[0];
        }
        if (buffer.length == 2) {
            return (char)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
        }
        return '\u0000';
    }

    int windowProc(int handle, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, user_data);
    }

    int windowProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, arg1, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, arg1, arg2, user_data);
    }

    int windowTimerProc(int handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(handle);
    }
}

