/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.internal.CloneableCompatibility;

public class StyleRange
implements CloneableCompatibility {
    public int start;
    public int length;
    public Color foreground;
    public Color background;
    public int fontStyle = 0;

    public StyleRange() {
    }

    public StyleRange(int start, int length, Color foreground, Color background) {
        this.start = start;
        this.length = length;
        this.foreground = foreground;
        this.background = background;
    }

    public StyleRange(int start, int length, Color foreground, Color background, int fontStyle) {
        this.start = start;
        this.length = length;
        this.foreground = foreground;
        this.background = background;
        this.fontStyle = fontStyle;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StyleRange)) {
            return false;
        }
        StyleRange style = (StyleRange)object;
        if (this.start != style.start) {
            return false;
        }
        if (this.length != style.length) {
            return false;
        }
        if (this.foreground != null ? !this.foreground.equals(style.foreground) : style.foreground != null) {
            return false;
        }
        if (this.background != null ? !this.background.equals(style.background) : style.background != null) {
            return false;
        }
        return this.fontStyle == style.fontStyle;
    }

    public int hashCode() {
        int code = this.start + this.length;
        if (this.foreground != null) {
            code += this.foreground.hashCode();
        }
        if (this.background != null) {
            code += this.background.hashCode();
        }
        return code + this.fontStyle;
    }

    public boolean isUnstyled() {
        if (this.foreground != null) {
            return false;
        }
        if (this.background != null) {
            return false;
        }
        return this.fontStyle == 0;
    }

    public boolean similarTo(StyleRange style) {
        if (this.foreground != null ? !this.foreground.equals(style.foreground) : style.foreground != null) {
            return false;
        }
        if (this.background != null ? !this.background.equals(style.background) : style.background != null) {
            return false;
        }
        return this.fontStyle == style.fontStyle;
    }

    public Object clone() {
        StyleRange style = new StyleRange(this.start, this.length, this.foreground, this.background, this.fontStyle);
        return style;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.start) + "," + this.length + " fg:" + this.foreground + " bg:" + this.background + " fStyle:");
        switch (this.fontStyle) {
            case 1: {
                buf.append("bold");
                break;
            }
            case 2: {
                buf.append("italic");
                break;
            }
            case 3: {
                buf.append("bold-italic");
                break;
            }
            default: {
                buf.append("normal");
            }
        }
        return buf.toString();
    }
}

