/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeBuilder;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class ContentTypeManager
implements IContentTypeManager,
IRegistryChangeListener {
    private static ContentTypeManager instance;
    public static final int BLOCK_SIZE = 1024;
    public static final String CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String OPTION_DEBUG_CONTENT_TYPES = "org.eclipse.core.runtime/contenttypes/debug";
    static final boolean DEBUGGING;
    private ContentTypeCatalog catalog;
    protected ListenerList contentTypeListeners = new ListenerList();

    static {
        DEBUGGING = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption(OPTION_DEBUG_CONTENT_TYPES));
    }

    public static void startup() {
        instance = new ContentTypeManager();
        Platform.getExtensionRegistry().addRegistryChangeListener(instance, "org.eclipse.core.runtime");
    }

    public static void shutdown() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(instance);
        instance = null;
    }

    public static ContentTypeManager getInstance() {
        Assert.isNotNull(instance);
        return instance;
    }

    static String getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        return dotPosition == -1 || dotPosition == fileName.length() - 1 ? null : fileName.substring(dotPosition + 1);
    }

    protected static LazyInputStream readBuffer(InputStream contents) {
        return new LazyInputStream(contents, 1024);
    }

    protected static LazyReader readBuffer(Reader contents) {
        return new LazyReader(contents, 1024);
    }

    protected ContentTypeBuilder createBuilder(ContentTypeCatalog newCatalog) {
        return new ContentTypeBuilder(newCatalog);
    }

    public IContentType findContentTypeFor(InputStream contents, String fileName) throws IOException {
        IContentType[] all = this.findContentTypesFor(contents, fileName);
        return all.length > 0 ? all[0] : null;
    }

    public IContentType findContentTypeFor(String fileName) {
        IContentType[] associated = this.findContentTypesFor(fileName);
        return associated.length == 0 ? null : associated[0];
    }

    public IContentType[] findContentTypesFor(InputStream contents, String fileName) throws IOException {
        return this.getCatalog().findContentTypesFor(contents, fileName);
    }

    public IContentType[] findContentTypesFor(String fileName) {
        return this.getCatalog().findContentTypesFor(fileName);
    }

    public IContentType[] getAllContentTypes() {
        return this.getCatalog().getAllContentTypes();
    }

    protected synchronized ContentTypeCatalog getCatalog() {
        if (this.catalog != null) {
            return this.catalog;
        }
        ContentTypeCatalog newCatalog = new ContentTypeCatalog(this);
        ContentTypeBuilder builder = this.createBuilder(newCatalog);
        try {
            builder.buildCatalog();
            this.catalog = newCatalog;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
        newCatalog.organize();
        return newCatalog;
    }

    public IContentType getContentType(String contentTypeIdentifier) {
        return this.getCatalog().getContentType(contentTypeIdentifier);
    }

    public IContentDescription getDescriptionFor(InputStream contents, String fileName, QualifiedName[] options) throws IOException {
        return this.getCatalog().getDescriptionFor(contents, fileName, options);
    }

    public IContentDescription getDescriptionFor(Reader contents, String fileName, QualifiedName[] options) throws IOException {
        return this.getCatalog().getDescriptionFor(contents, fileName, options);
    }

    Preferences getPreferences() {
        return new InstanceScope().getNode(CONTENT_TYPE_PREF_NODE);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        if (event.getExtensionDeltas("org.eclipse.core.runtime", "contentTypes").length == 0) {
            return;
        }
        this.invalidate();
    }

    synchronized void invalidate() {
        if (DEBUGGING && this.catalog != null) {
            Policy.debug("Registry discarded");
        }
        this.catalog = null;
    }

    public void addContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.add(listener);
    }

    public void removeContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.remove(listener);
    }

    public void fireContentTypeChangeEvent(ContentType type) {
        Object[] listeners = this.contentTypeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IContentTypeManager.ContentTypeChangeEvent event = new IContentTypeManager.ContentTypeChangeEvent(type);
            final IContentTypeManager.IContentTypeChangeListener listener = (IContentTypeManager.IContentTypeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.contentTypeChanged(event);
                }
            };
            Platform.run(job);
            ++i;
        }
    }
}

