/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.argosdic.resource.ResourceManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler
implements Window.IExceptionHandler {
    static Log log = LogFactory.getLog(ExceptionHandler.class);
    static /* synthetic */ Class class$0;

    public void handleException(Throwable t) {
        ExceptionHandler.handleException(null, t);
    }

    public static void handleException(String msg, Throwable t) {
        ResourceManager resources = ResourceManager.getInstance();
        try {
            if (msg == null) {
                msg = resources.getString("error.message.unknown");
            }
        }
        catch (Throwable th) {
            msg = "Unhandled exception has occurred.";
        }
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            t.printStackTrace(printer);
            Status status = new Status(4, ExceptionHandler.class.getName(), 0, writer.toString(), t);
            MultiStatus multiStatus = new MultiStatus(ExceptionHandler.class.getName(), 0, msg, t);
            multiStatus.add((IStatus)status);
            Display display = Display.getCurrent();
            Shell parent = display != null ? display.getActiveShell() : null;
            String title = resources.getString("dialog.title.error");
            ErrorDialog.openError((Shell)parent, (String)title, null, (IStatus)multiStatus);
        }
        catch (Throwable th) {
            log.warn((Object)("Unable to open error dialog : " + th.getMessage()), th);
        }
        if (log.isErrorEnabled()) {
            log.error((Object)msg, t);
        }
    }
}

