/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.search;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SearchIndexer
extends DefaultHandler
implements ContentHandler {
    private static Log log = LogFactory.getLog(SearchIndexer.class);
    private StringWriter writer;
    private IndexWriter indexer;
    private String source;
    private String target;
    private Analyzer analyzer;
    private String element;
    private String key;
    private String value;
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    static /* synthetic */ Class class$0;

    public SearchIndexer(String source, String target) throws IOException {
        this.source = source;
        this.target = target;
        this.analyzer = new SimpleAnalyzer();
        this.indexer = new IndexWriter(new File(target), this.analyzer, true);
    }

    public SearchIndexer(String source, String target, String analyzerClass) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.source = source;
        this.target = target;
        if (analyzerClass != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Instantiating anayzer : " + analyzerClass));
            }
            Class<?> cl = Class.forName(analyzerClass);
            this.analyzer = (Analyzer)cl.newInstance();
        } else {
            this.analyzer = new SimpleAnalyzer();
        }
        this.indexer = new IndexWriter(new File(target), this.analyzer, true);
    }

    public void characters(char[] ch, int offset, int length) throws SAXException {
        if (this.writer != null) {
            this.writer.write(ch, offset, length);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.element = localName;
        this.writer = new StringWriter();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.writer != null) {
            try {
                if (localName.equals("key")) {
                    this.key = this.writer.toString();
                } else {
                    this.value = this.writer.toString();
                    Document document = new Document();
                    Field field = Field.Text((String)"word", (String)this.key);
                    document.add(field);
                    field = Field.UnIndexed((String)"definition", (String)this.value);
                    document.add(field);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Indexing definition for : " + this.key));
                    }
                    this.indexer.addDocument(document);
                }
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writer = null;
        }
    }

    public void endDocument() throws SAXException {
        block2: {
            try {
                this.indexer.optimize();
                this.indexer.close();
            }
            catch (Exception e) {
                String msg = "Unable to save index database : " + e.toString();
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    private static void printUsage() {
        System.out.print("Usage : java -cp (classpath) ");
        System.out.print("org.argosdic.search.SearchIndexer ");
        System.out.println("[options] (source file) [(target directory)]");
        System.out.println();
        System.out.println("\t-help : print usage(this screen).");
        System.out.println("\t-analyzer=(class name) : specify analyzer class.");
    }

    public static void main(String[] args) throws Exception {
        String msg;
        XMLReader parser = null;
        String source = null;
        String target = null;
        String analyzer = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim();
            if (arg.startsWith("-help")) {
                SearchIndexer.printUsage();
                System.exit(0);
            } else if (arg.startsWith("-analyzer=")) {
                analyzer = arg.substring(10);
            } else if (source == null) {
                source = arg;
            } else {
                if (target != null) break;
                target = arg;
            }
            ++i;
        }
        if (source == null || target == null) {
            SearchIndexer.printUsage();
            System.exit(0);
        }
        try {
            File file = new File(source);
            if (!file.exists() || !file.canRead() || file.isDirectory()) {
                System.err.println("Unable to read the source file : " + source);
                System.exit(-1);
            }
            if (!(file = new File(target)).exists()) {
                if (!file.mkdirs()) {
                    System.err.println("Unable to create the target directory : " + source);
                    System.exit(-1);
                }
            } else if (!file.isDirectory()) {
                System.err.println("Target path is not a directory : " + source);
                System.exit(-1);
            }
            SearchIndexer handler = new SearchIndexer(source, target, analyzer);
            parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            parser.setContentHandler(handler);
            long startTime = System.currentTimeMillis();
            parser.parse(new File(source).toURL().toExternalForm());
            long elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println();
            System.out.println("Elapsed time : " + elapsedTime + " seconds.");
        }
        catch (SAXParseException e) {
            msg = "Parse error has occurred while reading the source file : " + e.toString();
            System.err.println(msg);
            if (log.isErrorEnabled()) {
                log.error((Object)msg, (Throwable)e);
            }
            System.exit(-1);
        }
        catch (Exception e) {
            msg = "Unhandled exception has occurred : " + e.toString();
            System.err.println(msg);
            if (log.isErrorEnabled()) {
                log.error((Object)msg, (Throwable)e);
            }
            System.exit(-1);
        }
    }
}

