/*
 * Decompiled with CFR 0.152.
 */
package org.argosdic.dictionary;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.argosdic.dictionary.Dictionary;
import org.argosdic.dictionary.DictionaryEvent;
import org.argosdic.dictionary.DictionaryListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;

public class DictionaryManager {
    private static DictionaryManager instance;
    private static Log log;
    private static final int EVENT_DICTIONARY_UPDATED = 0;
    private static final int EVENT_DICTIONARY_CHANGED = 1;
    private ListenerList listeners;
    private Map dictionaries;
    private Dictionary selectedDictionary;
    static /* synthetic */ Class class$0;

    static {
        log = LogFactory.getLog(DictionaryManager.class);
    }

    private DictionaryManager() {
        this.initialize();
    }

    public void initialize() {
        File dataDir;
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing DictionaryManager...");
        }
        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();
        String path = preferences.getString("data.dir");
        if (log.isInfoEnabled()) {
            log.info((Object)("Searching for dictionaries : " + path));
        }
        if (!(dataDir = new File(path)).exists() || !dataDir.isDirectory()) {
            String msg = "The specified path is not a valid data directory : " + dataDir;
            log.warn((Object)msg);
            return;
        }
        File[] files = dataDir.listFiles();
        int count = files.length;
        this.dictionaries = new HashMap(count);
        int i = 0;
        while (i < count) {
            block7: {
                File dir = files[i];
                if (dir.isDirectory()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(dir.getAbsolutePath());
                    buffer.append(File.separator);
                    buffer.append("dictionary.properties");
                    try {
                        String id = dir.getName();
                        File descriptor = new File(buffer.toString());
                        this.addDictionary(id, descriptor);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block7;
                        String msg = "Unable to read directory file : " + e.toString();
                        log.warn((Object)msg, (Throwable)e);
                    }
                }
            }
            ++i;
        }
        this.fireDictionaryUpdated();
    }

    private void addDictionary(String id, File descriptor) throws IOException {
        if (descriptor.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing : " + descriptor.getAbsolutePath()));
            }
            InputStream in = null;
            try {
                in = new FileInputStream(descriptor);
                in = new BufferedInputStream(in);
                Properties props = new Properties();
                props.load(in);
                Dictionary dictionary = new Dictionary(id, props);
                this.dictionaries.put(dictionary.getId(), dictionary);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Added new dictionary : ");
                    log.info((Object)("  - id : " + dictionary.getId()));
                    log.info((Object)("  - name : " + dictionary.getName()));
                    log.info((Object)("  - analyzer : " + dictionary.getAnalyzer()));
                    log.info((Object)("  - description : " + dictionary.getDescription()));
                    log.info((Object)("  - copyright : " + dictionary.getCopyright()));
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public Dictionary getDictionary(String id) {
        Assert.isNotNull((Object)id);
        if (this.dictionaries == null) {
            String msg = "DictionaryManager has not been initialized.";
            throw new IllegalStateException(msg);
        }
        return (Dictionary)this.dictionaries.get(id);
    }

    public int getDictionaryCount() {
        return this.dictionaries != null ? this.dictionaries.size() : 0;
    }

    public Iterator getDictionaries() {
        if (this.dictionaries == null) {
            String msg = "DictionaryManager has not been initialized.";
            throw new IllegalStateException(msg);
        }
        return this.dictionaries.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDictionaryListener(DictionaryListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.listeners == null) {
            DictionaryManager dictionaryManager = this;
            synchronized (dictionaryManager) {
                this.listeners = new ListenerList(30);
            }
        }
        this.listeners.add((Object)listener);
    }

    public Dictionary getSelectedDictionary() {
        return this.selectedDictionary;
    }

    public void setSelectedDictionary(String id) {
        Assert.isNotNull((Object)id);
        this.selectedDictionary = (Dictionary)this.dictionaries.get(id);
        this.fireDictionaryChanged();
    }

    public void removeDictionaryListener(DictionaryListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    protected void fireDictionaryUpdated() {
        this.fireDictionaryEvent(0);
    }

    protected void fireDictionaryChanged() {
        if (log.isInfoEnabled() && this.selectedDictionary != null) {
            log.info((Object)("Use dictionary : " + this.selectedDictionary.getName()));
        }
        this.fireDictionaryEvent(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDictionaryEvent(int eventCode) {
        if (this.listeners != null) {
            Object[] array = null;
            ListenerList listenerList = this.listeners;
            synchronized (listenerList) {
                array = this.listeners.getListeners();
            }
            DictionaryEvent event = new DictionaryEvent(this, this.selectedDictionary);
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    DictionaryListener listener = (DictionaryListener)array[i];
                    switch (eventCode) {
                        case 1: {
                            listener.dictionaryChanged(event);
                            break;
                        }
                        case 0: {
                            listener.dictionaryUpdated(event);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DictionaryManager getInstance() {
        if (instance != null) return instance;
        Class<DictionaryManager> clazz = DictionaryManager.class;
        synchronized (DictionaryManager.class) {
            instance = new DictionaryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

