/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;

public class GroupingChecker {
    HashMap constraints = new HashMap();

    void addConstraint(ResolverExport constrained, ResolverExport constraint) {
        ArrayList<ResolverExport> list = (ArrayList<ResolverExport>)this.constraints.get(constrained);
        if (list == null) {
            list = new ArrayList<ResolverExport>();
            this.constraints.put(constrained, list);
        }
        if (!list.contains(constraint)) {
            list.add(constraint);
        }
    }

    private void addConstraints(ResolverExport constrained, ArrayList newConstraints) {
        ArrayList list = (ArrayList)this.constraints.get(constrained);
        if (list == null) {
            this.constraints.put(constrained, newConstraints);
        } else {
            int i = 0;
            while (i < newConstraints.size()) {
                list.add(newConstraints.get(i));
                ++i;
            }
        }
    }

    void removeConstraint(ResolverExport constrained, ResolverExport constraint) {
        ArrayList list = (ArrayList)this.constraints.get(constrained);
        if (list == null) {
            return;
        }
        list.remove(constraint);
    }

    void removeAllConstraints(ResolverExport constrained) {
        this.constraints.put(constrained, null);
    }

    ResolverExport isConsistent(ResolverImport imp, ResolverExport exp) {
        ResolverImport[] imports = imp.getBundle().getImportPackages();
        BundleConstraint[] requires = imp.getBundle().getRequires();
        int i = 0;
        while (i < imports.length) {
            ResolverExport wire = imports[i].getMatchingExport();
            if (wire != null) {
                ResolverExport re;
                int j;
                ArrayList list = (ArrayList)this.constraints.get(wire);
                if (list != null) {
                    j = 0;
                    while (j < list.size()) {
                        re = (ResolverExport)list.get(j);
                        if (re.getExporter().isResolvable() && exp.getName().equals(re.getName()) && !imp.isOnRootPath(re.getExporter()) && !imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) {
                            return wire;
                        }
                        ++j;
                    }
                }
                if ((list = (ArrayList)this.constraints.get(exp)) != null) {
                    j = 0;
                    while (j < list.size()) {
                        re = (ResolverExport)list.get(j);
                        if (re.getExporter().isResolvable() && wire.getName().equals(re.getName()) && !imports[i].isOnRootPath(re.getExporter()) && !imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) {
                            return wire;
                        }
                        int k = 0;
                        while (k < requires.length) {
                            if (requires[k].getMatchingBundle() != null) {
                                ResolverExport[] exports = requires[k].getMatchingBundle().getExportPackages();
                                int m = 0;
                                while (m < exports.length) {
                                    if (re.getExporter().isResolvable() && exports[m].getName().equals(re.getName()) && !exports[m].isOnRootPath(re.getExporter())) {
                                        return re;
                                    }
                                    ++m;
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                j = 0;
                while (j < requires.length) {
                    ResolverBundle matchingBundle = requires[j].getMatchingBundle();
                    if (matchingBundle != null) {
                        ResolverExport[] exports = matchingBundle.getExportPackages();
                        int k = 0;
                        while (k < exports.length) {
                            if (imports[i].getName().equals(exports[k].getName()) && imports[i].getMatchingExport() != exports[k]) {
                                return imports[i].getMatchingExport();
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() != null) {
                ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    ArrayList list = (ArrayList)this.constraints.get(exports[j]);
                    if (list != null) {
                        int k = 0;
                        while (k < list.size()) {
                            ResolverExport re = (ResolverExport)list.get(k);
                            if (re.getExporter().isResolvable() && exp.getName().equals(re.getName()) && !imp.isOnRootPath(re.getExporter())) {
                                return re;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    boolean checkRequiresConstraints(ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        if (requires == null) {
            return true;
        }
        int i = 0;
        while (i < requires.length) {
            ResolverBundle matchingBundle = requires[i].getMatchingBundle();
            if (matchingBundle != null) {
                ResolverExport[] exports = matchingBundle.getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    ArrayList list = (ArrayList)this.constraints.get(exports[j]);
                    if (list != null) {
                        int k = 0;
                        while (k < list.size()) {
                            ResolverExport constraint = (ResolverExport)list.get(k);
                            boolean foundPotential = false;
                            boolean found = false;
                            int m = 0;
                            while (m < requires.length) {
                                if (requires[m].getMatchingBundle() != null) {
                                    ResolverExport[] exps = requires[m].getMatchingBundle().getExportPackages();
                                    int n = 0;
                                    while (n < exps.length) {
                                        if (constraint.getExporter().isResolvable() && constraint.getName().equals(exps[n].getName())) {
                                            foundPotential = true;
                                            if (exps[n] == constraint || exps[n].isOnRootPath(constraint.getExporter())) {
                                                found = true;
                                                break;
                                            }
                                        }
                                        ++n;
                                    }
                                    if (found) break;
                                }
                                ++m;
                            }
                            if (foundPotential && !found) {
                                return false;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    void addInitialGroupingConstraints(ResolverBundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            HashMap<String, ArrayList<ResolverExport>> groups = new HashMap<String, ArrayList<ResolverExport>>();
            ResolverExport[] exports = bundles[i].getExportPackages();
            int j = 0;
            while (j < exports.length) {
                if (exports[j].getExportPackageDescription().isRoot()) {
                    String group = exports[j].getGrouping();
                    ArrayList<ResolverExport> list = (ArrayList<ResolverExport>)groups.get(group);
                    if (list == null) {
                        list = new ArrayList<ResolverExport>();
                        groups.put(group, list);
                    }
                    list.add(exports[j]);
                }
                ++j;
            }
            Iterator it = groups.values().iterator();
            while (it.hasNext()) {
                ArrayList list = (ArrayList)it.next();
                if (list.size() <= 1) continue;
                int j2 = 0;
                while (j2 < list.size()) {
                    this.addConstraints((ResolverExport)list.get(j2), list);
                    ++j2;
                }
            }
            ++i;
        }
    }

    void addPropagationAndReExportConstraints(ResolverBundle bundle) {
        String grouping;
        ResolverImport[] imports = bundle.getImportPackages();
        ResolverExport[] exports = bundle.getExportPackages();
        int i = 0;
        while (i < imports.length) {
            String[] propagates = imports[i].getImportPackageSpecification().getPropagate();
            if (propagates != null) {
                int j = 0;
                while (j < propagates.length) {
                    int k = 0;
                    while (k < exports.length) {
                        String grouping2 = exports[k].getGrouping();
                        if (propagates[j].equals(grouping2)) {
                            this.addConstraint(exports[k], imports[i].getMatchingExport());
                            this.addConstraint(exports[k], exports[k]);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < exports.length) {
            grouping = exports[i].getGrouping();
            if (grouping != null && !exports[i].getName().equals(grouping)) {
                int j = 0;
                while (j < exports.length) {
                    if (grouping.equals(exports[j].getGrouping())) {
                        this.addConstraint(exports[j], exports[i]);
                        this.addConstraint(exports[i], exports[j]);
                    }
                    if (!exports[j].getExportPackageDescription().isRoot()) {
                        this.addConstraint(exports[i], exports[j].getRoot());
                    }
                    ++j;
                }
            }
            if (!exports[i].getExportPackageDescription().isRoot()) {
                ResolverImport imp = bundle.getImport(exports[i]);
                if (imp == null) {
                    this.addReprovideConstraints(exports[i]);
                } else {
                    this.addReExportChainConstraints(exports[i], imp.getMatchingExport());
                }
            }
            ++i;
        }
        i = 0;
        while (i < exports.length) {
            if (exports[i].getExportPackageDescription().isRoot() && (grouping = exports[i].getGrouping()) != null) {
                int j = 0;
                while (j < exports.length) {
                    if (!exports[j].getExportPackageDescription().isRoot() && grouping.equals(exports[j].getGrouping())) {
                        ArrayList list = (ArrayList)this.constraints.get(exports[j]);
                        int k = 0;
                        while (k < list.size()) {
                            this.addConstraint(exports[i], (ResolverExport)list.get(k));
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addReExportChainConstraints(ResolverExport reexport, ResolverExport next) {
        if (next == null) {
            return;
        }
        ResolverExport[] grouped = next.getExporter().getGroupedExports(next.getGrouping());
        int i = 0;
        while (i < grouped.length) {
            this.addConstraint(reexport, grouped[i]);
            ++i;
        }
        if (!next.getExportPackageDescription().isRoot()) {
            ResolverImport imp = next.getExporter().getImport(next);
            if (imp == null || imp.getMatchingExport() == null) {
                return;
            }
            this.addReExportChainConstraints(reexport, imp.getMatchingExport());
            String[] groups = imp.getImportPackageSpecification().getPropagate();
            if (groups == null) {
                return;
            }
            ResolverExport[] exports = imp.getBundle().getExportPackages();
            int i2 = 0;
            while (i2 < exports.length) {
                if (exports[i2] != next) {
                    int j = 0;
                    while (j < groups.length) {
                        if (exports[i2].getGrouping().equals(groups[j])) {
                            ResolverImport imp2;
                            this.addConstraint(reexport, exports[i2]);
                            if (!exports[i2].getExportPackageDescription().isRoot() && (imp2 = exports[i2].getExporter().getImport(exports[i2])) != null && imp2.getMatchingExport() != null) {
                                this.addReExportChainConstraints(reexport, imp2.getMatchingExport());
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
    }

    void addRequireConstraints(ResolverExport[] exports, ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        int i = 0;
        while (i < exports.length) {
            if (!exports[i].getExportPackageDescription().isRoot() || exports[i].isReprovide()) {
                int j = 0;
                while (j < requires.length) {
                    if (requires[j].getMatchingBundle() != null && exports[i].getExporter() != requires[j].getMatchingBundle()) {
                        ResolverExport[] requireExports = requires[j].getMatchingBundle().getExportPackages();
                        int k = 0;
                        while (k < requireExports.length) {
                            ArrayList list;
                            if (exports[i].getName().equals(requireExports[k].getName()) && (list = (ArrayList)this.constraints.get(requireExports[k])) != null) {
                                int m = 0;
                                while (m < list.size()) {
                                    this.addConstraint(exports[i], (ResolverExport)list.get(m));
                                    ++m;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void addReprovideConstraints(ResolverExport re) {
        BundleConstraint[] requires = re.getExporter().getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() == null) {
                return;
            }
            ResolverExport[] requireExports = requires[i].getMatchingBundle().getExportPackages();
            int j = 0;
            while (j < requireExports.length) {
                ArrayList list;
                if (re.getName().equals(requireExports[j].getName()) && (list = (ArrayList)this.constraints.get(requireExports[j])) != null) {
                    int k = 0;
                    while (k < list.size()) {
                        this.addConstraint(re, (ResolverExport)list.get(k));
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

