/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;

public class Headers
extends Dictionary {
    protected Dictionary headers;
    protected Dictionary values;

    public Headers(int initialCapacity) {
        this.headers = new Hashtable(initialCapacity);
        this.values = new Hashtable(initialCapacity);
    }

    public Headers(Dictionary values) {
        this.headers = new Hashtable(values.size());
        this.values = values;
        Enumeration keys = values.keys();
        while (keys.hasMoreElements()) {
            String header;
            Object key = keys.nextElement();
            if (!(key instanceof String) || this.headers.put(header = ((String)key).toLowerCase(), key) == null) continue;
            throw new IllegalArgumentException(Msg.formatter.getString("HEADER_DUPLICATE_KEY_EXCEPTION", header));
        }
    }

    public synchronized Enumeration keys() {
        return this.values.keys();
    }

    public synchronized Enumeration elements() {
        return this.values.elements();
    }

    public synchronized Object get(Object key) {
        Object keyLower;
        Object value = this.values.get(key);
        if (value == null && key instanceof String && (keyLower = this.headers.get(((String)key).toLowerCase())) != null) {
            value = this.values.get(keyLower);
        }
        return value;
    }

    public synchronized Object set(Object key, Object value) {
        Object oldKey;
        String header;
        String string = header = key instanceof String ? ((String)key).toLowerCase() : null;
        if (value == null) {
            if (header != null) {
                key = this.headers.remove(header);
                if (key != null) {
                    value = this.values.remove(key);
                }
            } else {
                value = this.values.remove(key);
            }
            return value;
        }
        if (header != null && (oldKey = this.headers.put(header, key)) != null && !header.equals(oldKey)) {
            this.headers.put(header, oldKey);
            throw new IllegalArgumentException(Msg.formatter.getString("HEADER_DUPLICATE_KEY_EXCEPTION", header));
        }
        return this.values.put(key, value);
    }

    public synchronized int size() {
        return this.values.size();
    }

    public synchronized boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.values.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Headers parseManifest(InputStream in) throws BundleException {
        Headers headers2;
        try {
            try {
                BufferedReader br;
                Headers headers = new Headers(10);
                try {
                    br = new BufferedReader(new InputStreamReader(in, "UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    br = new BufferedReader(new InputStreamReader(in));
                }
                String header = null;
                StringBuffer value = new StringBuffer(256);
                boolean firstLine = true;
                while (true) {
                    int colon;
                    String line;
                    if ((line = br.readLine()) == null || line.length() == 0) {
                        if (firstLine) break;
                        headers.set(header, null);
                        headers.set(header, value.toString().trim());
                        break;
                    }
                    if (line.charAt(0) == ' ') {
                        if (firstLine) {
                            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_SPACE", line));
                        }
                        value.append(line.substring(1));
                        continue;
                    }
                    if (!firstLine) {
                        headers.set(header, null);
                        headers.set(header, value.toString().trim());
                        value.setLength(0);
                    }
                    if ((colon = line.indexOf(58)) == -1) {
                        throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_LINE_NOCOLON", line));
                    }
                    header = line.substring(0, colon).trim();
                    value.append(line.substring(colon + 1));
                    firstLine = false;
                }
                headers2 = headers;
                Object var8_10 = null;
            }
            catch (IOException e) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_IOEXCEPTION"), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        in.close();
        return headers2;
    }
}

