/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;

public class ServiceUse {
    protected ServiceFactory factory;
    protected Object service;
    protected BundleContextImpl context;
    protected ServiceRegistrationImpl registration;
    protected int useCount;

    protected ServiceUse(BundleContextImpl context, ServiceRegistrationImpl registration) {
        this.context = context;
        this.registration = registration;
        this.useCount = 0;
        Object service = registration.service;
        if (service instanceof ServiceFactory) {
            this.factory = (ServiceFactory)service;
            this.service = null;
        } else {
            this.factory = null;
            this.service = service;
        }
    }

    protected Object getService() {
        if (this.useCount == 0 && this.factory != null) {
            Object service;
            BundleHost factorybundle = this.registration.context.bundle;
            try {
                service = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ServiceUse.this.factory.getService(ServiceUse.this.context.bundle, ServiceUse.this.registration);
                    }
                });
            }
            catch (Throwable t) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".getService() exception: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.context.framework.adaptor.handleRuntimeError(t);
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_FACTORY_EXCEPTION", this.factory.getClass().getName(), "getService"), t);
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                return null;
            }
            if (service == null) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".getService() returned null.");
                }
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_OBJECT_NULL_EXCEPTION", this.factory.getClass().getName()));
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                return null;
            }
            String[] clazzes = this.registration.clazzes;
            String invalidService = BundleContextImpl.checkServiceClass(clazzes, service);
            if (invalidService != null) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("Service object is not an instanceof " + invalidService);
                }
                throw new IllegalArgumentException(Msg.formatter.getString("SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION", invalidService));
            }
            this.service = service;
        }
        ++this.useCount;
        return this.service;
    }

    protected boolean ungetService() {
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount == 0) {
            if (this.factory != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ServiceUse.this.factory.ungetService(ServiceUse.this.context.bundle, ServiceUse.this.registration, ServiceUse.this.service);
                            return null;
                        }
                    });
                }
                catch (Throwable t) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(this.factory + ".ungetService() exception");
                        Debug.printStackTrace(t);
                    }
                    BundleHost factorybundle = this.registration.context.bundle;
                    BundleException be = new BundleException(Msg.formatter.getString("SERVICE_FACTORY_EXCEPTION", this.factory.getClass().getName(), "ungetService"), t);
                    this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                }
                this.service = null;
            }
            return true;
        }
        return false;
    }

    protected void releaseService() {
        if (this.useCount > 0 && this.factory != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ServiceUse.this.factory.ungetService(ServiceUse.this.context.bundle, ServiceUse.this.registration, ServiceUse.this.service);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".ungetService() exception");
                    Debug.printStackTrace(t);
                }
                BundleHost factorybundle = this.registration.context.bundle;
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_FACTORY_EXCEPTION", this.factory.getClass().getName(), "ungetService"), t);
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
            }
            this.service = null;
        }
        this.useCount = 0;
    }
}

