// Slots.cpp: implementation of the CSlots class.
//
//////////////////////////////////////////////////////////////////////

#include "arch/frame/stdafx.h"
#include "arch/frame/mainfrm.h"

#include "slots.h"
#include "appleclock.h"
#include "phasor.h"
#include "diskinterface.h"
#include "mousecard.h"


extern BYTE MemReturnRandomData(BYTE highbit);
extern CALLBACK_HANDLER(OnDiskLightChange);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSlots::CSlots()
{
	int i;
	for( i = 0; i < MAX_SLOTS; i++ )
	{
		m_slots[i] = NULL;
	}
}

CSlots::~CSlots()
{
	int i;
	for( i=0; i < MAX_SLOTS; i++ )
	{
		if ( m_slots[i] != NULL )
		{
			delete m_slots[i];
			m_slots[i] = NULL;
		}
	}
}

// slot ī尡     ϵ Ѵ.
BOOL CSlots::Initialize()
{
	int i, nDeviceNum;
	int nDiskInterface;
	nDiskInterface = 0;
	for ( i = MAX_SLOTS-1; i >= 0; i-- )
	{
		if ( m_slots[i] != NULL )
		{
			nDeviceNum = m_slots[i]->GetDeviceNum();
			switch( nDeviceNum )
			{
			case CARD_DISK_INTERFACE:
				((CDiskInterface*)m_slots[i])->SetMotorLightHandler( (void*)nDiskInterface, OnDiskLightChange );
				nDiskInterface ^= 1;
				break;
			case CARD_MOUSE_INTERFACE:
			case CARD_PHASOR:
				break;
			}
		}
	}
	return TRUE;
}

void CSlots::PowerOn()
{
	int i;
	for( i = 0; i < MAX_SLOTS; i++ )
		if ( m_slots[i] != NULL )
			m_slots[i]->PowerOn();
}

void CSlots::PowerOff()
{
	int i;
	for( i = 0; i < 7; i++ )
		if ( m_slots[i] != NULL )
			m_slots[i]->PowerOff();
}

BYTE CSlots::Read(WORD addr)
{
	int slot;
	BYTE retval;
	slot = ( ( addr >> 4 ) & 0x07 ) - 1;
	if ( m_slots[slot] )
	{
		retval = m_slots[slot]->Read(addr);
		return( retval );
	}
	return MemReturnRandomData( 0 );
}

BYTE CSlots::ReadRom(WORD addr)
{
	int slot;
	slot = ( ( addr >> 8 ) & 0x7 ) - 1;
	if( m_slots[slot] )
		return m_slots[slot]->ReadRom(addr);
				
	return MemReturnRandomData( 0 );
}

void CSlots::Write(WORD addr, BYTE data)
{
	int slot;
	slot = ( ( addr >> 4 ) & 0x07 ) - 1;
	if ( m_slots[slot] )
		m_slots[slot]->Write(addr, data);
}

void CSlots::WriteRom(WORD addr, BYTE data)
{
	int slot;
	slot = ( ( addr >> 8 ) & 0x7 ) - 1;
	if ( m_slots[slot] )
		m_slots[slot]->WriteRom(addr, data);
}

void CSlots::Reset()
{
	int i;
	for( i = 0; i < MAX_SLOTS; i++ )
	{
		if ( m_slots[i] != NULL )
		{
			m_slots[i]->Reset();
		}
	}
}

void CSlots::Clock(DWORD clock)
{
	int i;
	for ( i = 0; i < MAX_SLOTS; i++ )
	{
		if ( m_slots[i] )
			m_slots[i]->Clock( clock );
	}
}

CCard* CSlots::GetCard(int slot)
{
	if ( slot < 0 || slot >= MAX_SLOTS )
		return NULL;
	return m_slots[slot];
}

void CSlots::RemoveCard(int nSlot)
{
	if ( m_slots[nSlot] == NULL )
		return;
	delete m_slots[nSlot];
	m_slots[nSlot] = NULL;
}

BOOL CSlots::InsertCard(int nSlot, int nDeviceNum)
{
	CCard* pCard;
	if ( m_slots[nSlot] != NULL )
		return FALSE;

	switch( nDeviceNum & 0xFF )
	{
	case CARD_DISK_INTERFACE:
		pCard = new CDiskInterface();
		break;
	case CARD_MOUSE_INTERFACE:
		pCard = new CMouseCard();
		break;
	case CARD_PHASOR:
		pCard = new CPhasor();
		break;
	default:
		return FALSE;
	}
	m_slots[nSlot] = pCard;
	pCard->SetDipSwitch(nDeviceNum >> 8);
	return TRUE;
}

BOOL CSlots::InsertCard(int nSlot, CCard* pCard)
{
	if ( m_slots[nSlot] != NULL || pCard == NULL )
		return FALSE;
	m_slots[nSlot] = pCard;
	return TRUE;
}

void CSlots::SetDipSwitch(int nSlot, int nDipSwitch)
{
	if ( nSlot < 0 || nSlot >	MAX_SLOTS )
		return;
	if ( m_slots[nSlot] == NULL )
		return;
	m_slots[nSlot]->SetDipSwitch(nDipSwitch);
}
