// AppleStatusBar.cpp : implementation file
//
#include "arch/frame/stdafx.h"
#include "arch/frame/aipc.h"
#include "arch/frame/mainfrm.h"
#include "arch/frame/applestatusbar.h"
#include "arch/frame/screen.h"
#include "appleclock.h"
#include "diskdrive.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CAppleClock* g_pBoard;

CALLBACK_HANDLER(OnDiskLightChange)
{
	g_pBoard->m_lpwndMainFrame->m_wndStatusBar.SetDiskStatus( (int)objTo, lParam );
}

/////////////////////////////////////////////////////////////////////////////
// CAppleStatusBar

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_DISK,
	ID_INDICATOR_CLOCK_SPEED,
	ID_INDICATOR_FRAME_SPEED,
	ID_INDICATOR_CAPS,
};

CAppleStatusBar::CAppleStatusBar()
{
	VERIFY(m_bmDisk.LoadBitmap( IDB_DISK ));
	VERIFY(m_bmDiskRead.LoadBitmap( IDB_DISK_READ ));
	VERIFY(m_bmDiskWrite.LoadBitmap( IDB_DISK_WRITE ));
	VERIFY(m_bmDiskOff.LoadBitmap( IDB_DISK_OFF ));
	int i;
	for( i = 0; i < 4; i++ )
		m_iDiskStatus[i] = 0;
}

CAppleStatusBar::~CAppleStatusBar()
{

}


BEGIN_MESSAGE_MAP(CAppleStatusBar, CStatusBar)
	//{{AFX_MSG_MAP(CAppleStatusBar)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAppleStatusBar message handlers

void CAppleStatusBar::DrawItem(LPDRAWITEMSTRUCT lpDrawItem)
{
	switch( lpDrawItem->itemID )
	{
	case 1:
		DrawDiskLight( lpDrawItem->hDC, lpDrawItem->rcItem );
		return;
	}
	CStatusBar::DrawItem( lpDrawItem );
}

BOOL CAppleStatusBar::Create(CWnd *pParentWnd, DWORD dwStyle)
{
	if ( !CStatusBar::Create(pParentWnd, dwStyle , AFX_IDW_STATUS_BAR)
		||	!SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)) )
		return FALSE;
	SetPaneInfo( 1, GetItemID( 1 ), GetPaneStyle( 1 ) | SBT_OWNERDRAW, 70 );
	SetPaneInfo( 2, GetItemID( 2 ), GetPaneStyle( 2 ), 60 );
	SetPaneInfo( 3, GetItemID( 3 ), GetPaneStyle( 3 ), 60 );
	SetPaneInfo( 4, GetItemID( 4 ), GetPaneStyle( 4 ), 30 );
	GetItemRect( 1, &m_rectDisk );
	return TRUE;
}

void CAppleStatusBar::SetSpeed(double speed)
{
	CString szSpeed;
	szSpeed.Format( "%3.2f MHz", speed );
	SetPaneText( 2, szSpeed );
}

void CAppleStatusBar::SetFrame(double frame)
{
	CString szFrame;
	szFrame.Format( "%3.2f f/s", frame );
	SetPaneText( 3, szFrame );
}

void CAppleStatusBar::SetDiskStatus(int index, int status)
{

	if ( index < -1 || index >= 2 )
		return;
	int old1 = 0, old2 = 0;

	if ( index >= 0 )
	{
		index <<= 1;
		int w = status >> 2;
		
		old1 = m_iDiskStatus[index];
		old2 = m_iDiskStatus[index+1];
		
		m_iDiskStatus[index] = ( status & 1 );
		m_iDiskStatus[index+1] = ( status >> 1 ) & 1;
		if ( m_iDiskStatus[index] )
			m_iDiskStatus[index] += w;
		else if ( m_iDiskStatus[index+1] )
			m_iDiskStatus[index+1] += w;
	}
	if ( index == -1 || old1 != m_iDiskStatus[index] ||
		 old2 != m_iDiskStatus[index+1] )
	{
		CScreen* pScreen = g_pBoard->m_pScreen;

		if ( pScreen->m_bWindowed )
		{
			InvalidateRect(&m_rectDisk, FALSE);
		}
		else
		{
			RECT rc = { 1, 1, DISK_VIEW_WIDTH-2, DISK_VIEW_HEIGHT-2 };
			HRESULT hr;
			HDC hDC;
			CSurface* pSurface = pScreen->GetDiskSurface();
			LPDIRECTDRAWSURFACE7 lpdds = pSurface->GetDDrawSurface();
			if ( lpdds == NULL )
				return;
			hr = lpdds->GetDC(&hDC);
			if FAILED(hr)
				return;
			if ( hDC )
			{
				DrawDiskLight( hDC, rc );
				lpdds->ReleaseDC(hDC);
				pScreen->UpdateDiskSurface();
			}
		}
	}
}

void CAppleStatusBar::OnSize(UINT nType, int cx, int cy) 
{
	CStatusBar::OnSize(nType, cx, cy);
	GetItemRect( 1, &m_rectDisk );
	// TODO: Add your message handler code here
}

void CAppleStatusBar::DrawDiskLight(HDC hDC, RECT rc)
{
	CDC dc;
	dc.Attach(hDC);
	CRect rect(rc);
	CDC srcDC;
	CDC maskDC;
	BITMAP info;
	CBitmap* pOldBitmap;
	
	srcDC.CreateCompatibleDC(NULL);
	pOldBitmap = srcDC.SelectObject(&m_bmDisk);
	m_bmDisk.GetObject(sizeof(BITMAP), &info);
	
	dc.BitBlt( rect.left, rect.top+(rect.Height()-info.bmHeight)/2,
		info.bmWidth, info.bmHeight, &srcDC, 0, 0, SRCCOPY );
	
	rect.left += info.bmWidth + 2;
	
	m_bmDiskOff.GetObject(sizeof(BITMAP), &info);
	rect.top += ( rect.Height()-info.bmHeight ) / 2;
	
	int i;
	for( i = 0; i < 4; i++ )
	{
		if ( m_iDiskStatus[i] == 1 )
			srcDC.SelectObject( &m_bmDiskRead );
		else if ( m_iDiskStatus[i] == 2 )
			srcDC.SelectObject( &m_bmDiskWrite );
		else
			srcDC.SelectObject( &m_bmDiskOff );
		
		dc.BitBlt( rect.left, rect.top, info.bmWidth, info.bmHeight,
			&srcDC, 0, 0, SRCCOPY );
		rect.left += info.bmWidth;
	}
	
	srcDC.SelectObject(pOldBitmap);
	dc.Detach();
}
