// Joystick.h: interface for the CJoystick class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_JOYSTICK_H__4DF81BD0_F4BF_4630_BCB4_82A4983195E4__INCLUDED_)
#define AFX_JOYSTICK_H__4DF81BD0_F4BF_4630_BCB4_82A4983195E4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "dinput.h"

#define JM_NONE			0
#define JM_KEYPAD		1
#define JM_PCJOYSTICK	2

#define JE_NOPCJOYSTICK	1
class CAppleClock;

class CJoystick
{
public:
	int GetDevice();
	int ChangeDevice(int nMode);
	void Strobe();
	BYTE GetStatus( BYTE num );
	CJoystick();
	virtual ~CJoystick();

	BOOL m_bHasPCJoystick;

protected:
	void Poll();
	BOOL m_bStrobe;
	DWORD m_dwLastClock;
	DWORD m_dwLastPoll;
	int	m_nJoystickMode;
	DIJOYSTATE2 *m_stJState;
};

#endif // !defined(AFX_JOYSTICK_H__4DF81BD0_F4BF_4630_BCB4_82A4983195E4__INCLUDED_)
