// Cpu.h: interface for the CCpu class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CPU_H__4143AA29_8CA5_4EBB_9EDB_87147331C999__INCLUDED_)
#define AFX_CPU_H__4143AA29_8CA5_4EBB_9EDB_87147331C999__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define	SIG_CPU_SHUTDOWN	(1<<0)
#define	SIG_CPU_RES			(1<<1)
#define	SIG_CPU_NMI			(1<<2)
#define	SIG_CPU_IRQ			(1<<3)

class CCpu
{
public:
	virtual void Assert_NMI();
	virtual void Assert_IRQ();
	virtual void Shutdown();
	virtual void Reset();
	virtual void Clock(int nClock);
	virtual void Process() = NULL;
	DWORD GetClock();
	DWORD GetCpuClock();
	void SetSpeed(int nSpeed);
	CCpu();
	virtual ~CCpu();
	unsigned m_uException_Register;
protected:
	int m_nClock;
	int m_nSpeed;
};

#endif // !defined(AFX_CPU_H__4143AA29_8CA5_4EBB_9EDB_87147331C999__INCLUDED_)
